/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckinstaller.views.settings;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -2579851322257142775L;
    private static final Logger logger = LoggerFactory.getLogger(DirectoryFileChooser.class);

    public DirectoryFileChooser(String string, File file) {
        this.setSelectedFile(file);
        this.setDialogTitle(string);
        this.setFileSelectionMode(1);
        this.setAcceptAllFileFilterUsed(false);
        this.setApproveButtonText("Select");
        this.setDialogType(2);
    }

    @Override
    public void approveSelection() {
        File file = this.getSelectedFile();
        logger.debug("getCurrentDirectory(): {}", (Object)this.getCurrentDirectory());
        logger.debug("selectedFile={}", (Object)file);
        if (file.exists() && file.isDirectory()) {
            super.approveSelection();
        } else {
            super.approveSelection();
        }
    }

    @Override
    public void cancelSelection() {
        logger.debug("Cancel selection.");
        super.cancelSelection();
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.resetChoosableFileFilters();
        }
    }

    public static File showSelectorDialog(Component component, String string, File file) {
        File file2;
        DirectoryFileChooser directoryFileChooser = new DirectoryFileChooser(string, file);
        if (directoryFileChooser.showDialog(component, null) == 0) {
            logger.debug("getCurrentDirectory(): {}", (Object)directoryFileChooser.getCurrentDirectory());
            logger.debug("getSelectedFile() : {}", (Object)directoryFileChooser.getSelectedFile());
            file2 = directoryFileChooser.getSelectedFile();
        } else {
            file2 = null;
        }
        return file2;
    }
}

