/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckinstaller.model;

import fr.devinsy.util.strings.StringList;
import fr.devinsy.util.strings.StringSet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.taskdefs.Expand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckinstaller.model.InstallCriteria;

public class PuckRepository {
    private static final Logger logger = LoggerFactory.getLogger(PuckRepository.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String GNULINUX_32_JRE_FILENAME = "jre-6u45-linux-i586.zip";
    public static final String GNULINUX_64_JRE_FILENAME = "jre-6u45-linux-x64.zip";
    public static final String MSWINDOWS_32_JRE_FILENAME = "jre-6u45-msw-i586.zip";
    public static final String MSWINDOWS_64_JRE_FILENAME = "jre-6u45-msw-x64.zip";
    public static final String MACOSX_32_JRE_FILENAME = "jre-6uxx-osx-i386.zip";
    public static final String MACOSX_64_JRE_FILENAME = "jre-6uxx-osx-amd64.zip";

    public static File dowloadJre(String string, InstallCriteria.OperatingSystem operatingSystem, File file) throws MalformedURLException, IOException {
        File file2;
        String string2;
        String string3 = PuckRepository.getJreFileName(operatingSystem);
        if (string.contains("kintip.net")) {
            string2 = PuckRepository.getKintipFileURL(string, string3);
            file2 = new File(file, string3);
        } else {
            string2 = string + string3;
            file2 = new File(file, string3);
        }
        file2 = PuckRepository.download(string2, file2);
        return file2;
    }

    public static File dowloadPuckPackage(String string, String string2, File file) throws MalformedURLException, IOException {
        File file2;
        String string3;
        if (string.contains("kintip.net")) {
            string3 = PuckRepository.getKintipFileURL(string, string2) + ".zip";
            file2 = new File(file, string2.toLowerCase().replace("_", "-") + ".zip");
        } else {
            string3 = string + string2 + ".zip";
            file2 = new File(file, string2 + ".zip");
        }
        logger.debug("[source={}]", (Object)string3);
        logger.debug("[target={}]", (Object)file2);
        file2 = PuckRepository.download(string3, file2);
        return file2;
    }

    public static File download(String string, File file) throws MalformedURLException, IOException {
        file.delete();
        if (string.startsWith("http")) {
            FileUtils.copyURLToFile((URL)new URL(string), (File)file);
        } else {
            FileUtils.copyFile((File)new File(string), (File)file);
        }
        File file2 = file;
        return file2;
    }

    public static String getJreFileName(InstallCriteria.OperatingSystem operatingSystem) {
        String string;
        switch (operatingSystem) {
            case GNULinux_32: {
                string = GNULINUX_32_JRE_FILENAME;
                break;
            }
            case GNULinux_64: {
                string = GNULINUX_64_JRE_FILENAME;
                break;
            }
            case MSWindows_32: {
                string = MSWINDOWS_32_JRE_FILENAME;
                break;
            }
            case MSWindows_64: {
                string = MSWINDOWS_64_JRE_FILENAME;
                break;
            }
            case OSX_32: {
                string = MACOSX_32_JRE_FILENAME;
                break;
            }
            case OSX_64: {
                string = MACOSX_64_JRE_FILENAME;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public static String getKintipFileURL(String string, String string2) throws IOException {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(15000);
        uRLConnection.setReadTimeout(15000);
        byte[] byArray = IOUtils.toByteArray((URLConnection)uRLConnection);
        logger.info("Kintip catalog size=" + byArray.length);
        StringList stringList = PuckRepository.toStringList(byArray, DEFAULT_CHARSET_NAME);
        String string3 = stringList.toString();
        Pattern pattern = Pattern.compile("<a\\s+href=\"([^\"]+)\"[^>]*>\\s*" + string2 + "\\s*<");
        Matcher matcher = pattern.matcher(string3);
        if (!matcher.find()) {
            logger.debug("File [" + string2 + "] not match.");
            throw new IOException("Filename not match.");
        }
        logger.debug(matcher.groupCount() + " " + matcher.group(1));
        String string4 = "http://kintip.net" + matcher.group(1);
        logger.debug("result=" + string4);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringList loadPackages(String string) {
        StringList stringList;
        logger.debug("repositoryPath=" + string);
        URLConnection uRLConnection = null;
        try {
            if (StringUtils.isBlank((CharSequence)string)) {
                stringList = new StringList();
            } else if (string.startsWith("/")) {
                stringList = new StringList();
                for (File file : new File(string).listFiles()) {
                    if (!file.isFile() || !file.getName().matches("puck-\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\w{0,9}\\.zip")) continue;
                    stringList.add((Object)FilenameUtils.removeExtension((String)file.getName()));
                }
            } else if (string.contains("kintip.net/")) {
                URL uRL = new URL(string);
                uRLConnection = uRL.openConnection();
                uRLConnection.setConnectTimeout(15000);
                uRLConnection.setReadTimeout(15000);
                byte[] byArray = IOUtils.toByteArray((URLConnection)uRLConnection);
                logger.info("Kintip catalog size=" + byArray.length);
                StringList stringList2 = PuckRepository.toStringList(byArray, DEFAULT_CHARSET_NAME);
                String string2 = stringList2.toString();
                Pattern pattern = Pattern.compile("<a\\s+href=[^>]+>([Pp]uck[-_]\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\w{0,9})<");
                Matcher matcher = pattern.matcher(string2);
                StringSet stringSet = new StringSet();
                while (matcher.find()) {
                    logger.debug(matcher.groupCount() + " " + matcher.group(1));
                    stringSet.add(matcher.group(1));
                }
                stringList = stringSet.toStringList();
                logger.debug("result=" + stringList.toStringWithCommas());
            } else {
                URL uRL = new URL(string);
                uRLConnection = uRL.openConnection();
                uRLConnection.setConnectTimeout(15000);
                uRLConnection.setReadTimeout(15000);
                byte[] byArray = IOUtils.toByteArray((URLConnection)uRLConnection);
                logger.info("Kinsources catalog size=" + byArray.length);
                StringList stringList3 = PuckRepository.toStringList(byArray, DEFAULT_CHARSET_NAME);
                String string3 = stringList3.toString();
                Pattern pattern = Pattern.compile("(puck-\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\w{0,9}\\.zip)");
                Matcher matcher = pattern.matcher(string3);
                StringSet stringSet = new StringSet();
                while (matcher.find()) {
                    logger.debug(matcher.group(0));
                    stringSet.add(FilenameUtils.removeExtension((String)matcher.group(0)));
                }
                stringList = stringSet.toStringList();
                logger.debug("result=" + stringList.toStringWithCommas());
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            stringList = new StringList();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            stringList = new StringList();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            stringList = new StringList();
        }
        finally {
            IOUtils.close(uRLConnection);
        }
        return stringList;
    }

    public static StringList toStringList(byte[] byArray, String string) throws IOException {
        StringList stringList = PuckRepository.toStringList(new ByteArrayInputStream(byArray), string);
        return stringList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringList toStringList(InputStream inputStream, String string) throws IOException {
        StringList stringList;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
            boolean bl = false;
            stringList = new StringList();
            while (!bl) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    bl = true;
                    continue;
                }
                stringList.append(string2);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        return stringList;
    }

    public static void unzip(File file, File file2) {
        Expand expand = new Expand();
        expand.setSrc(file);
        expand.setDest(file2);
        expand.execute();
    }
}

