/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckinstaller.model;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallCriteria {
    private static final Logger logger = LoggerFactory.getLogger(InstallCriteria.class);
    public static final String DEFAULT_REPOSITORY_PATH = "http://www.devinsy.fr/Puck/Repository/";
    public static final String DEFAULT_INSTALL_PATH_MSWINDOWS = "C:\\PROGRAM FILES\\PuckBin\\";
    public static final int DEFAULT_MEMORY_MB = 1024;
    private String jreRepository = "http://www.devinsy.fr/Puck/Repository/";
    private String puckRepository = "http://www.devinsy.fr/Puck/Repository/";
    private String puckPackage = null;
    private File installDirectory = InstallCriteria.getDefaultInstallDirectory();
    private OperatingSystem operatingSystem = null;
    private int memory = 1024;
    private File systemJreHome;

    public File buildJreBin() {
        File file = this.buildJreHome();
        File file2 = file == null ? null : new File(file, "bin");
        return file2;
    }

    public File buildJreHome() {
        File file;
        if (this.operatingSystem == OperatingSystem.OSX_32 || this.operatingSystem == OperatingSystem.OSX_64) {
            file = this.systemJreHome == null ? null : this.systemJreHome;
        } else if (StringUtils.isBlank((CharSequence)this.jreRepository)) {
            file = null;
        } else {
            switch (this.operatingSystem) {
                case GNULinux_32: {
                    file = new File(this.installDirectory, "jre-6u45-linux-i586.zip".replace(".zip", SystemUtils.FILE_SEPARATOR));
                    break;
                }
                case GNULinux_64: {
                    file = new File(this.installDirectory, "jre-6u45-linux-x64.zip".replace(".zip", SystemUtils.FILE_SEPARATOR));
                    break;
                }
                case MSWindows_32: {
                    file = new File(this.installDirectory, "jre-6u45-msw-i586.zip".replace(".zip", SystemUtils.FILE_SEPARATOR));
                    break;
                }
                case MSWindows_64: {
                    file = new File(this.installDirectory, "jre-6u45-msw-x64.zip".replace(".zip", SystemUtils.FILE_SEPARATOR));
                    break;
                }
                case OSX_32: 
                case OSX_64: {
                    file = this.systemJreHome;
                    break;
                }
                default: {
                    file = null;
                }
            }
        }
        return file;
    }

    public File buildPuckPackageHome() {
        File file = new File(this.installDirectory, StringUtils.lowerCase((String)this.puckPackage));
        return file;
    }

    public File getInstallDirectory() {
        return this.installDirectory;
    }

    public String getJreRepository() {
        return this.jreRepository;
    }

    public int getMemory() {
        return this.memory;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getPuckPackage() {
        return this.puckPackage;
    }

    public String getPuckRepository() {
        return this.puckRepository;
    }

    public File getSystemJreHome() {
        return this.systemJreHome;
    }

    public boolean isGNULinux() {
        boolean bl = this.operatingSystem == OperatingSystem.GNULinux_32 || this.operatingSystem == OperatingSystem.GNULinux_64;
        return bl;
    }

    public boolean isMSWindows() {
        boolean bl = this.operatingSystem == OperatingSystem.MSWindows_32 || this.operatingSystem == OperatingSystem.MSWindows_64;
        return bl;
    }

    public boolean isOSX() {
        boolean bl = this.operatingSystem == OperatingSystem.OSX_32 || this.operatingSystem == OperatingSystem.OSX_64;
        return bl;
    }

    public boolean isUnix() {
        boolean bl = this.isGNULinux() || this.isOSX();
        return bl;
    }

    public void setInstallDirectory(File file) {
        this.installDirectory = file;
    }

    public void setJreRepository(String string) {
        this.jreRepository = string;
        if (string != null) {
            if (string.startsWith("http")) {
                if (!string.endsWith("/")) {
                    this.jreRepository = string + "/";
                }
            } else if (!string.endsWith(SystemUtils.FILE_SEPARATOR)) {
                this.jreRepository = string + SystemUtils.FILE_SEPARATOR;
            }
        }
    }

    public void setMemory(int n) {
        this.memory = n;
    }

    public void setOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public void setPuckPackage(String string) {
        this.puckPackage = string;
    }

    public void setPuckRepository(String string) {
        this.puckRepository = string;
        if (string != null) {
            if (string.startsWith("http")) {
                if (!string.endsWith("/")) {
                    this.puckRepository = string + "/";
                }
            } else if (!string.endsWith(SystemUtils.FILE_SEPARATOR)) {
                this.puckRepository = string + SystemUtils.FILE_SEPARATOR;
            }
        }
    }

    public void setSystemJreHome(File file) {
        this.systemJreHome = file;
    }

    public static File getDefaultInstallDirectory() {
        File file = SystemUtils.IS_OS_UNIX ? new File(SystemUtils.getUserHome(), "PuckBin") : (SystemUtils.IS_OS_MAC_OSX ? new File(SystemUtils.getUserHome(), "PuckBin") : (SystemUtils.IS_OS_WINDOWS ? new File(SystemUtils.getUserHome(), "PuckBin") : new File(SystemUtils.getUserHome(), "PuckBin")));
        return file;
    }

    public static boolean isValid(InstallCriteria installCriteria) {
        boolean bl = true;
        return bl;
    }

    public static enum OperatingSystem {
        GNULinux_32,
        GNULinux_64,
        MSWindows_32,
        MSWindows_64,
        OSX_32,
        OSX_64;

    }
}

