/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckinstaller.views.settings;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.strings.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckinstaller.model.InstallCriteria;
import org.tip.puckinstaller.model.NormalizedPuckPackageComparator;
import org.tip.puckinstaller.model.PuckInstallerManager;
import org.tip.puckinstaller.model.PuckRepository;
import org.tip.puckinstaller.views.settings.DirectorySelector;

public class SettingsPanel
extends JPanel {
    private static final long serialVersionUID = 6813353627595391145L;
    private static final Logger logger = LoggerFactory.getLogger(SettingsPanel.class);
    private JTextField txtfldInstallDirectory;
    private JSpinner spnrFreeMemory;
    private JSpinner spnrMemory;
    private JComboBox cmbxOperationSystem;
    private JComboBox cmbxPuckPackage;
    private JButton btnDefaultPuckRepository;
    private JButton btnDefaultJreRepository;
    private JButton btnDefaultInstallDirectory;
    private JButton btnAutoOperatingSystem;
    private JButton btnDefaultMemory;
    private JSpinner spnrPhysicalMemory;
    private JComboBox cmbxPuckRepository;
    private JComboBox cmbxJreRepository;
    private JButton btnJRERepositorySelect;

    public SettingsPanel() {
        this.setLayout(new BorderLayout(0, 0));
        JLabel jLabel = new JLabel("Settings");
        jLabel.setFont(new Font("Dialog", 1, 32));
        this.add((Component)jLabel, "North");
        Component component = Box.createHorizontalStrut(20);
        this.add(component, "West");
        Component component2 = Box.createHorizontalStrut(20);
        this.add(component2, "East");
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder(null, "Source", 4, 2, null, null));
        jPanel.add(jPanel2);
        jPanel2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"min(100dlu;default):grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode((String)"4dlu:grow")}));
        JLabel jLabel2 = new JLabel("Puck repository:");
        jPanel2.add((Component)jLabel2, "2, 2, right, default");
        this.cmbxPuckRepository = new JComboBox(){
            private static final long serialVersionUID = 2954667544880878848L;

            @Override
            public void setSelectedItem(Object object) {
                super.setSelectedItem(object);
                ComboBoxEditor comboBoxEditor = this.getEditor();
                JTextField jTextField = (JTextField)comboBoxEditor.getEditorComponent();
                jTextField.setCaretPosition(0);
                logger.debug("selectedItem");
            }
        };
        this.cmbxPuckRepository.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    logger.debug("itemStateChanged");
                    SettingsPanel.this.updatePuckPackages();
                }
            }
        });
        jPanel2.add((Component)this.cmbxPuckRepository, "4, 2");
        this.cmbxPuckRepository.setModel(new DefaultComboBoxModel<String>(new String[]{"http://kintip.net/index.php?option=com_jdownloads&view=category&catid=3", "http://www.devinsy.fr/Puck/Repository/"}));
        this.cmbxPuckRepository.setEditable(true);
        JButton jButton = new JButton("\u2026");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = DirectorySelector.showSelectorDialog(SettingsPanel.this, "Puck Repository Selector", null);
                if (file != null && file.isDirectory()) {
                    SettingsPanel.this.cmbxPuckRepository.setSelectedItem(file.getAbsolutePath());
                }
            }
        });
        jPanel2.add((Component)jButton, "6, 2");
        this.btnDefaultPuckRepository = new JButton("Default");
        this.btnDefaultPuckRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.cmbxPuckRepository.setSelectedIndex(0);
            }
        });
        jPanel2.add((Component)this.btnDefaultPuckRepository, "8, 2");
        JLabel jLabel3 = new JLabel("Puck package:");
        jPanel2.add((Component)jLabel3, "2, 4, right, default");
        this.cmbxPuckPackage = new JComboBox();
        jPanel2.add((Component)this.cmbxPuckPackage, "4, 4, fill, default");
        JLabel jLabel4 = new JLabel("JRE repository:");
        jPanel2.add((Component)jLabel4, "2, 6, right, default");
        this.cmbxJreRepository = new JComboBox(){
            private static final long serialVersionUID = -8688011644070769286L;

            @Override
            public void setSelectedItem(Object object) {
                super.setSelectedItem(object);
                ComboBoxEditor comboBoxEditor = this.getEditor();
                JTextField jTextField = (JTextField)comboBoxEditor.getEditorComponent();
                jTextField.setCaretPosition(0);
                logger.debug("selectedItem");
            }
        };
        this.cmbxJreRepository.setModel(new DefaultComboBoxModel<String>(new String[]{"http://kintip.net/index.php?option=com_jdownloads&view=category&catid=3", "http://www.devinsy.fr/Puck/Repository/", "None (use the default system JVM)"}));
        this.cmbxJreRepository.setEditable(true);
        jPanel2.add((Component)this.cmbxJreRepository, "4, 6, fill, default");
        this.btnJRERepositorySelect = new JButton("\u2026");
        this.btnJRERepositorySelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = DirectorySelector.showSelectorDialog(SettingsPanel.this, "JRE Repository Selector", null);
                if (file != null && file.isDirectory()) {
                    SettingsPanel.this.cmbxJreRepository.setSelectedItem(file.getAbsolutePath());
                }
            }
        });
        jPanel2.add((Component)this.btnJRERepositorySelect, "6, 6");
        this.btnDefaultJreRepository = new JButton("Default");
        this.btnDefaultJreRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.cmbxJreRepository.setSelectedIndex(0);
            }
        });
        jPanel2.add((Component)this.btnDefaultJreRepository, "8, 6");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder(null, "Target", 4, 2, null, null));
        jPanel.add(jPanel3);
        jPanel3.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel jLabel5 = new JLabel("Install directory:");
        jPanel3.add((Component)jLabel5, "2, 2, right, default");
        this.txtfldInstallDirectory = new JTextField();
        jPanel3.add((Component)this.txtfldInstallDirectory, "4, 2, fill, default");
        this.txtfldInstallDirectory.setColumns(10);
        JButton jButton2 = new JButton("\u2026");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = DirectorySelector.showSelectorDialog(SettingsPanel.this, "Install Directory Selector", null);
                if (file != null && file.isDirectory()) {
                    SettingsPanel.this.txtfldInstallDirectory.setText(file.getAbsolutePath() + File.separatorChar);
                }
            }
        });
        jPanel3.add((Component)jButton2, "6, 2");
        this.btnDefaultInstallDirectory = new JButton("Default");
        this.btnDefaultInstallDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.txtfldInstallDirectory.setText(InstallCriteria.getDefaultInstallDirectory().getAbsolutePath() + File.separatorChar);
            }
        });
        jPanel3.add((Component)this.btnDefaultInstallDirectory, "8, 2");
        JLabel jLabel6 = new JLabel("Operating System:");
        jPanel3.add((Component)jLabel6, "2, 4, right, default");
        this.cmbxOperationSystem = new JComboBox();
        this.cmbxOperationSystem.setModel(new DefaultComboBoxModel<String>(new String[]{"GNU/Linux - 32bits (i586)", "GNU/Linux - 64bits (amd64)", "Microsoft Windows - 32 bits", "Microsoft Windows - 64 bits", "OS/X - 32bits (i586)", "OS/X - 64bits (amd64)"}));
        jPanel3.add((Component)this.cmbxOperationSystem, "4, 4, fill, default");
        this.btnAutoOperatingSystem = new JButton("Auto");
        this.btnAutoOperatingSystem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SystemUtils.IS_OS_LINUX) {
                    if (PuckInstallerManager.is32bits()) {
                        SettingsPanel.this.cmbxOperationSystem.setSelectedIndex(0);
                    } else {
                        SettingsPanel.this.cmbxOperationSystem.setSelectedIndex(1);
                    }
                } else if (SystemUtils.IS_OS_WINDOWS) {
                    if (PuckInstallerManager.is32bits()) {
                        SettingsPanel.this.cmbxOperationSystem.setSelectedIndex(2);
                    } else {
                        SettingsPanel.this.cmbxOperationSystem.setSelectedIndex(3);
                    }
                } else if (SystemUtils.IS_OS_MAC_OSX) {
                    if (PuckInstallerManager.is32bits()) {
                        SettingsPanel.this.cmbxOperationSystem.setSelectedIndex(4);
                    } else {
                        SettingsPanel.this.cmbxOperationSystem.setSelectedIndex(5);
                    }
                }
            }
        });
        jPanel3.add((Component)this.btnAutoOperatingSystem, "8, 4");
        JLabel jLabel7 = new JLabel("Physical memory:");
        jPanel3.add((Component)jLabel7, "2, 6, right, default");
        this.spnrPhysicalMemory = new JSpinner();
        this.spnrPhysicalMemory.setEnabled(false);
        ((JSpinner.DefaultEditor)this.spnrPhysicalMemory.getEditor()).getTextField().setHorizontalAlignment(4);
        jPanel3.add((Component)this.spnrPhysicalMemory, "4, 6");
        JLabel jLabel8 = new JLabel("MB");
        jPanel3.add((Component)jLabel8, "6, 6");
        JLabel jLabel9 = new JLabel("Free memory:");
        jPanel3.add((Component)jLabel9, "2, 8, right, default");
        this.spnrFreeMemory = new JSpinner();
        this.spnrFreeMemory.setEnabled(false);
        ((JSpinner.DefaultEditor)this.spnrFreeMemory.getEditor()).getTextField().setHorizontalAlignment(4);
        jPanel3.add((Component)this.spnrFreeMemory, "4, 8");
        JLabel jLabel10 = new JLabel("MB");
        jPanel3.add((Component)jLabel10, "6, 8");
        JLabel jLabel11 = new JLabel("Memory:");
        jPanel3.add((Component)jLabel11, "2, 11, right, default");
        this.spnrMemory = new JSpinner();
        this.spnrMemory.setModel(new SpinnerNumberModel(new Integer(1024), new Integer(480), null, new Integer(1)));
        ((JSpinner.DefaultEditor)this.spnrMemory.getEditor()).getTextField().setHorizontalAlignment(4);
        jPanel3.add((Component)this.spnrMemory, "4, 11");
        JLabel jLabel12 = new JLabel("MB");
        jPanel3.add((Component)jLabel12, "6, 11");
        this.btnDefaultMemory = new JButton("Auto");
        this.btnDefaultMemory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.spnrMemory.setValue(1024);
            }
        });
        jPanel3.add((Component)this.btnDefaultMemory, "8, 11");
        Component component3 = Box.createVerticalStrut(20);
        jPanel.add(component3);
        JPanel jPanel4 = new JPanel();
        this.add((Component)jPanel4, "South");
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        Component component4 = Box.createHorizontalStrut(20);
        jPanel4.add(component4);
        Component component5 = Box.createHorizontalStrut(20);
        jPanel4.add(component5);
        this.setDefaultSetting();
    }

    public InstallCriteria getCriteria() {
        InstallCriteria installCriteria = new InstallCriteria();
        installCriteria.setPuckRepository((String)this.cmbxPuckRepository.getSelectedItem());
        installCriteria.setPuckPackage((String)this.cmbxPuckPackage.getSelectedItem());
        String string = (String)this.cmbxJreRepository.getSelectedItem();
        if (StringUtils.isBlank((CharSequence)string) || string.startsWith("None")) {
            installCriteria.setJreRepository(null);
        } else {
            installCriteria.setJreRepository((String)this.cmbxJreRepository.getSelectedItem());
        }
        if (StringUtils.isBlank((CharSequence)this.txtfldInstallDirectory.getText())) {
            installCriteria.setInstallDirectory(null);
        } else {
            installCriteria.setInstallDirectory(new File(this.txtfldInstallDirectory.getText()));
        }
        installCriteria.setOperatingSystem(InstallCriteria.OperatingSystem.values()[this.cmbxOperationSystem.getSelectedIndex()]);
        installCriteria.setMemory((Integer)this.spnrMemory.getValue());
        return installCriteria;
    }

    private void setDefaultSetting() {
        this.updatePuckPackages();
        this.btnDefaultPuckRepository.doClick();
        this.btnDefaultJreRepository.doClick();
        this.btnDefaultInstallDirectory.doClick();
        this.spnrPhysicalMemory.setValue(PuckInstallerManager.getSystemPhysicalMemoryKB() / 1024);
        this.spnrFreeMemory.setValue(PuckInstallerManager.getAvailableSystemMemoryKB() / 1024);
        this.spnrMemory.setValue(1024);
        this.btnAutoOperatingSystem.doClick();
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.cmbxJreRepository.setSelectedIndex(2);
            this.cmbxJreRepository.setEnabled(false);
            this.btnJRERepositorySelect.setEnabled(false);
            this.btnDefaultJreRepository.setEnabled(false);
        }
    }

    private void updatePuckPackages() {
        String string = (String)this.cmbxPuckRepository.getSelectedItem();
        logger.debug("repos=" + string);
        StringList stringList = PuckRepository.loadPackages(string);
        Collections.sort(stringList, new NormalizedPuckPackageComparator());
        Collections.reverse(stringList);
        this.cmbxPuckPackage.setModel(new DefaultComboBoxModel<Object>(stringList.toArray()));
    }
}

