/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckinstaller.views;

import fr.devinsy.util.cmdexec.CmdExec;
import fr.devinsy.util.cmdexec.CmdExecException;
import fr.devinsy.util.strings.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckinstaller.PuckInstallerException;
import org.tip.puckinstaller.model.InstallCriteria;
import org.tip.puckinstaller.util.BuildInformation;
import org.tip.puckinstaller.views.InstalledPanel;
import org.tip.puckinstaller.views.InstallingPanel;
import org.tip.puckinstaller.views.WelcomePanel;
import org.tip.puckinstaller.views.settings.SettingsPanel;

public class PuckInstallerWindow
extends JFrame {
    private static final long serialVersionUID = 5526792729445990591L;
    private static final Logger logger = LoggerFactory.getLogger(PuckInstallerWindow.class);
    private Step step = Step.WELCOME;
    private InstallCriteria criteria;
    private JPanel contentPane;
    private JButton btnFinish;
    private JButton btnBack;
    private JButton btnNext;
    private Component centerPanel;

    public PuckInstallerWindow() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(PuckInstallerWindow.class.getResource("/org/tip/puckinstaller/favicon-16x16.jpg")));
        this.setTitle("PUCKInstaller");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 640, 475);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JPanel jPanel = new JPanel();
        this.contentPane.add((Component)jPanel, "South");
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        Component component = Box.createHorizontalStrut(20);
        jPanel.add(component);
        this.btnBack = new JButton("Back");
        this.btnBack.setDefaultCapable(false);
        this.btnBack.setEnabled(false);
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (PuckInstallerWindow.this.step) {
                    case SETTINGS: {
                        PuckInstallerWindow.this.step = Step.WELCOME;
                        PuckInstallerWindow.this.setPanel(new WelcomePanel());
                        PuckInstallerWindow.this.btnBack.setEnabled(false);
                        PuckInstallerWindow.this.btnNext.setEnabled(true);
                        PuckInstallerWindow.this.btnNext.setText("Next");
                        PuckInstallerWindow.this.btnFinish.setEnabled(false);
                        break;
                    }
                    case INSTALLING: {
                        PuckInstallerWindow.this.step = Step.SETTINGS;
                        PuckInstallerWindow.this.setPanel(new SettingsPanel());
                        PuckInstallerWindow.this.btnBack.setEnabled(true);
                        PuckInstallerWindow.this.btnNext.setEnabled(true);
                        PuckInstallerWindow.this.btnNext.setText("Install");
                        PuckInstallerWindow.this.btnFinish.setEnabled(false);
                        PuckInstallerWindow.this.pack();
                        break;
                    }
                    default: {
                        logger.debug("FOO ALERT");
                    }
                }
            }
        });
        jPanel.add(this.btnBack);
        Component component2 = Box.createHorizontalGlue();
        jPanel.add(component2);
        this.btnNext = new JButton("Next");
        this.btnNext.addActionListener(new ActionListener(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent var1_1) {
                switch (4.$SwitchMap$org$tip$puckinstaller$views$PuckInstallerWindow$Step[PuckInstallerWindow.access$000(PuckInstallerWindow.this).ordinal()]) {
                    case 3: {
                        PuckInstallerWindow.access$002(PuckInstallerWindow.this, Step.SETTINGS);
                        PuckInstallerWindow.this.setPanel(new SettingsPanel());
                        PuckInstallerWindow.access$100(PuckInstallerWindow.this).setEnabled(true);
                        PuckInstallerWindow.access$200(PuckInstallerWindow.this).setEnabled(true);
                        PuckInstallerWindow.access$200(PuckInstallerWindow.this).setText("Install");
                        PuckInstallerWindow.access$300(PuckInstallerWindow.this).setEnabled(false);
                        break;
                    }
                    case 1: {
                        PuckInstallerWindow.access$502(PuckInstallerWindow.this, ((SettingsPanel)PuckInstallerWindow.access$600(PuckInstallerWindow.this)).getCriteria());
                        if (StringUtils.isBlank((CharSequence)PuckInstallerWindow.access$500(PuckInstallerWindow.this).getPuckRepository())) {
                            var2_2 = "Error";
                            var3_6 = "Puck repository is required.";
                            JOptionPane.showMessageDialog(PuckInstallerWindow.this, var3_6, var2_2, 0);
                            break;
                        }
                        if (PuckInstallerWindow.access$500(PuckInstallerWindow.this).getInstallDirectory() == null) {
                            var2_3 = "Error";
                            var3_7 = "Install directory is required.";
                            JOptionPane.showMessageDialog(PuckInstallerWindow.this, var3_7, var2_3, 0);
                            break;
                        }
                        if (StringUtils.isBlank((CharSequence)PuckInstallerWindow.access$500(PuckInstallerWindow.this).getPuckPackage())) {
                            var2_4 = "Error";
                            var3_8 = "Install directory is required.";
                            JOptionPane.showMessageDialog(PuckInstallerWindow.this, var3_8, var2_4, 0);
                            break;
                        }
                        if (!SystemUtils.IS_OS_MAC_OSX) ** GOTO lbl80
                        var3_9 = new CmdExec("/usr/libexec/java_home -v 1.6");
                        if (var3_9.getExitValue() == 0) {
                            PuckInstallerWindow.access$400().debug("stdout={}", (Object)var3_9.getOutStream());
                            PuckInstallerWindow.access$500(PuckInstallerWindow.this).setSystemJreHome(new File(var3_9.getOutStream().trim()));
                        } else {
                            PuckInstallerWindow.access$500(PuckInstallerWindow.this).setSystemJreHome(null);
                        }
                        PuckInstallerWindow.access$400().debug("systemJreHome={}", (Object)PuckInstallerWindow.access$500(PuckInstallerWindow.this).getSystemJreHome());
                        if (PuckInstallerWindow.access$500(PuckInstallerWindow.this).getSystemJreHome() != null) ** GOTO lbl78
                        var4_10 = "Warning";
                        var5_11 = new StringList();
                        var5_11.appendln("PuckInstaller does not found Java 1.6 on your computer.");
                        var5_11.appendln("To ensure the best Puck functioning, you have to install Java 6.");
                        var5_11.appendln("Fortunately, it's easy, just install the following Apple update:");
                        var5_11.appendln("https://support.apple.com/kb/DL1572");
                        var5_11.appendln("(click on the middle button below to open it in your browser)");
                        var5_11.appendln("Then, come back to PuckInstaller.");
                        var6_12 = new String[]{"Use default Java", "Install Apple Java 6", "Cancel"};
                        var7_13 = JOptionPane.showOptionDialog(PuckInstallerWindow.this, var5_11.toString(), var4_10, 1, 2, null, var6_12, "Install Apple Java 6");
                        PuckInstallerWindow.access$400().debug("Choice={}", (Object)var7_13);
                        switch (var7_13) {
                            case 0: {
                                var2_5 = true;
                                break;
                            }
                            case 1: {
                                var2_5 = false;
                                PuckInstallerWindow.access$400().debug("browse desktop action supported={}", (Object)Desktop.getDesktop().isSupported(Desktop.Action.BROWSE));
                                if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                                    try {
                                        Desktop.getDesktop().browse(new URI("https://support.apple.com/kb/DL1572"));
                                    }
                                    catch (IOException var8_14) {
                                        PuckInstallerWindow.access$400().debug("IOException browsing Apple update", (Throwable)var8_14);
                                    }
                                    catch (URISyntaxException var8_15) {
                                        PuckInstallerWindow.access$400().debug("URISyntaxException browsing Apple update", (Throwable)var8_15);
                                    }
                                    PuckInstallerWindow.access$100(PuckInstallerWindow.this).doClick();
                                    break;
                                }
                                ** GOTO lbl81
                            }
                            default: {
                                var2_5 = false;
                                break;
                            }
                        }
                        ** GOTO lbl81
lbl78:
                        // 1 sources

                        var2_5 = true;
                        ** GOTO lbl81
lbl80:
                        // 1 sources

                        var2_5 = true;
lbl81:
                        // 4 sources

                        if (!var2_5) break;
                        PuckInstallerWindow.access$002(PuckInstallerWindow.this, Step.INSTALLING);
                        PuckInstallerWindow.this.setPanel(new InstallingPanel(PuckInstallerWindow.access$500(PuckInstallerWindow.this)));
                        PuckInstallerWindow.access$100(PuckInstallerWindow.this).setEnabled(false);
                        PuckInstallerWindow.access$200(PuckInstallerWindow.this).setEnabled(false);
                        PuckInstallerWindow.access$200(PuckInstallerWindow.this).setText("Next");
                        PuckInstallerWindow.access$300(PuckInstallerWindow.this).setEnabled(false);
                        var3_9 = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    ((InstallingPanel)PuckInstallerWindow.this.centerPanel).install();
                                    PuckInstallerWindow.this.btnNext.setEnabled(true);
                                }
                                catch (PuckInstallerException puckInstallerException) {
                                    PuckInstallerWindow.this.btnBack.setEnabled(true);
                                }
                            }
                        };
                        var3_9.start();
                        break;
                    }
                    case 2: {
                        PuckInstallerWindow.access$002(PuckInstallerWindow.this, Step.INSTALLED);
                        PuckInstallerWindow.this.setPanel(new InstalledPanel(PuckInstallerWindow.access$500(PuckInstallerWindow.this)));
                        PuckInstallerWindow.access$100(PuckInstallerWindow.this).setEnabled(false);
                        PuckInstallerWindow.access$200(PuckInstallerWindow.this).setEnabled(false);
                        PuckInstallerWindow.access$200(PuckInstallerWindow.this).setText("Next");
                        PuckInstallerWindow.access$300(PuckInstallerWindow.this).setEnabled(true);
                        break;
                    }
                    default: {
                        PuckInstallerWindow.access$400().debug("FOO ALERT");
                    }
                }
            }
        });
        JLabel jLabel = new JLabel("Version " + new BuildInformation().version());
        jLabel.setEnabled(false);
        jPanel.add(jLabel);
        Component component3 = Box.createHorizontalGlue();
        jPanel.add(component3);
        jPanel.add(this.btnNext);
        Component component4 = Box.createHorizontalStrut(20);
        jPanel.add(component4);
        this.btnFinish = new JButton("Finish");
        this.btnFinish.setEnabled(false);
        this.btnFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (PuckInstallerWindow.this.step) {
                    case INSTALLED: {
                        if (SystemUtils.IS_OS_WINDOWS) {
                            try {
                                Runtime.getRuntime().exec("explorer \"" + PuckInstallerWindow.this.criteria.getInstallDirectory() + "\"");
                            }
                            catch (IOException iOException) {
                                logger.error(iOException.getMessage(), (Throwable)iOException);
                            }
                        } else if (SystemUtils.IS_OS_MAC_OSX) {
                            try {
                                StringList stringList = new StringList();
                                stringList.append("/usr/bin/osascript");
                                stringList.append("-e");
                                stringList.append("tell application \"Finder\" to open (POSIX File \"" + PuckInstallerWindow.this.criteria.getInstallDirectory() + "\")");
                                CmdExec.run((String[])stringList.toStringArray());
                                stringList = new StringList();
                                stringList.append("/usr/bin/osascript");
                                stringList.append("-e");
                                stringList.append("tell application \"Finder\" to say \"Welcome to PUCK\"");
                                CmdExec.run((String[])stringList.toStringArray());
                            }
                            catch (CmdExecException cmdExecException) {
                                logger.error(cmdExecException.getMessage(), (Throwable)cmdExecException);
                            }
                        }
                        PuckInstallerWindow.this.quit();
                        break;
                    }
                    default: {
                        logger.debug("FOO ALERT");
                    }
                }
            }
        });
        jPanel.add(this.btnFinish);
        Component component5 = Box.createHorizontalStrut(20);
        jPanel.add(component5);
        this.centerPanel = new WelcomePanel();
        this.contentPane.add(this.centerPanel, "Center");
        if (BuildInformation.isDefined()) {
            this.setTitle("PUCKInstaller " + new BuildInformation().version());
        }
    }

    public void close() {
        String string = "Abort confirm request";
        String string2 = "Please, confirm you quit.";
        JOptionPane.showMessageDialog(null, string2, string, 0);
        this.quit();
    }

    public void quit() {
        System.exit(0);
    }

    public void setPanel(Component component) {
        this.contentPane.remove(this.centerPanel);
        this.centerPanel = component;
        this.contentPane.add(component, "Center");
        this.contentPane.validate();
    }

    static /* synthetic */ InstallCriteria access$502(PuckInstallerWindow puckInstallerWindow, InstallCriteria installCriteria) {
        puckInstallerWindow.criteria = installCriteria;
        return puckInstallerWindow.criteria;
    }

    public static enum Step {
        WELCOME,
        SETTINGS,
        INSTALLING,
        INSTALLED;

    }
}

