/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckinstaller.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckinstaller.PuckInstallerException;
import org.tip.puckinstaller.model.InstallCriteria;
import org.tip.puckinstaller.model.PuckInstallerManager;
import org.tip.puckinstaller.model.PuckRepository;

public class InstallingPanel
extends JPanel {
    private static final long serialVersionUID = -2596794252517096353L;
    private static final Logger logger = LoggerFactory.getLogger(InstallingPanel.class);
    private InstallCriteria criteria;
    private JTextArea txtrConsole;

    public InstallingPanel(InstallCriteria installCriteria) {
        this.criteria = installCriteria;
        this.setLayout(new BorderLayout(0, 0));
        JLabel jLabel = new JLabel("Installing");
        this.add((Component)jLabel, "North");
        jLabel.setFont(new Font("Dialog", 1, 32));
        Component component = Box.createHorizontalStrut(20);
        this.add(component, "West");
        this.txtrConsole = new JTextArea();
        this.txtrConsole.setFont(new Font("Monospaced", 0, 13));
        this.txtrConsole.setEditable(false);
        ((DefaultCaret)this.txtrConsole.getCaret()).setUpdatePolicy(2);
        JScrollPane jScrollPane = new JScrollPane(this.txtrConsole);
        this.add(jScrollPane);
        Component component2 = Box.createHorizontalStrut(20);
        this.add(component2, "East");
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        Component component3 = Box.createVerticalStrut(20);
        jPanel.add(component3);
    }

    private void appendPad(String string) {
        this.txtrConsole.append(StringUtils.rightPad((String)string, (int)40, (char)'.'));
    }

    public void install() throws PuckInstallerException {
        try {
            File file;
            this.txtrConsole.append("Install starting\u2026\n");
            this.txtrConsole.append("\n");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.appendPad("Creation of the install directory");
            if (this.criteria.getInstallDirectory().exists()) {
                this.txtrConsole.append("PASSED (already existing).\n");
            } else {
                this.criteria.getInstallDirectory().mkdirs();
                this.txtrConsole.append("DONE\n");
            }
            if (this.criteria.getJreRepository() != null) {
                this.appendPad("Downloading the JRE zip file");
                file = PuckRepository.dowloadJre(this.criteria.getJreRepository(), this.criteria.getOperatingSystem(), this.criteria.getInstallDirectory());
                this.txtrConsole.append("DONE\n");
                this.appendPad("Unziping the JRE zip file");
                PuckRepository.unzip(file, this.criteria.getInstallDirectory());
                this.txtrConsole.append("DONE\n");
                this.appendPad("Removing JRE zip file");
                file.delete();
                this.txtrConsole.append("DONE\n");
                if (!SystemUtils.IS_OS_WINDOWS) {
                    this.appendPad("Setting executable flag for JRE");
                    File file2 = new File(this.criteria.buildJreHome(), "bin/java");
                    file2.setExecutable(true, true);
                    this.txtrConsole.append("DONE\n");
                }
            }
            this.appendPad("Downloading the Puck zip file");
            file = PuckRepository.dowloadPuckPackage(this.criteria.getPuckRepository(), this.criteria.getPuckPackage(), this.criteria.getInstallDirectory());
            this.txtrConsole.append("DONE\n");
            this.appendPad("Unziping the Puck zip file");
            PuckRepository.unzip(file, this.criteria.getInstallDirectory());
            this.txtrConsole.append("DONE\n");
            this.appendPad("Removing Puck zip file");
            file.delete();
            this.txtrConsole.append("DONE\n");
            this.appendPad("Creating icon file");
            PuckInstallerManager.createIconFile(this.criteria.getInstallDirectory());
            this.txtrConsole.append("DONE\n");
            this.appendPad("Creating launcher file");
            PuckInstallerManager.createLauncherScript(this.criteria.getInstallDirectory(), this.criteria.buildJreBin(), this.criteria.buildPuckPackageHome(), this.criteria.getOperatingSystem(), file.getName(), this.criteria.getMemory());
            this.txtrConsole.append("DONE\n");
            this.appendPad("Creating desktop file");
            PuckInstallerManager.createDesktopFile(this.criteria.getInstallDirectory(), this.criteria.buildJreBin(), this.criteria.buildPuckPackageHome(), this.criteria.getOperatingSystem(), file.getName(), this.criteria.getMemory());
            this.txtrConsole.append("DONE\n");
            if (SystemUtils.IS_OS_LINUX) {
                this.appendPad("Copying local application file");
                PuckInstallerManager.copyLocalApplicationFile(this.criteria.getInstallDirectory());
                this.txtrConsole.append("DONE\n");
            }
            this.txtrConsole.append("\n");
            this.txtrConsole.append("Install done.\n");
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("Error during installation", (Throwable)malformedURLException);
            this.txtrConsole.append("Sorry, error detected, task stopped.\n");
            this.txtrConsole.append(malformedURLException.getMessage());
            throw new PuckInstallerException("Error during install.", malformedURLException);
        }
        catch (IOException iOException) {
            logger.error("Error during installation", (Throwable)iOException);
            this.txtrConsole.append("Sorry, error detected. Task stopped.\n");
            this.txtrConsole.append(iOException.getMessage());
            throw new PuckInstallerException("Error during install.", iOException);
        }
        catch (Exception exception) {
            logger.error("Error during installation", (Throwable)exception);
            this.txtrConsole.append("Sorry, error detected. Task stopped.\n");
            this.txtrConsole.append(exception.getMessage());
            throw new PuckInstallerException("Error during install.", exception);
        }
    }
}

