/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckinstaller.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIToolBox {
    private static final Logger logger = LoggerFactory.getLogger(GUIToolBox.class);

    public static List<String> availableLookAndFeels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            arrayList.add(lookAndFeelInfo.getName());
        }
        return arrayList;
    }

    public static BufferedImage crop(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2;
        if (bufferedImage == null) {
            bufferedImage2 = null;
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            for (n4 = 0; n4 < bufferedImage.getHeight() && GUIToolBox.isWhiteLine(bufferedImage, n4); ++n4) {
            }
            if (n4 == bufferedImage.getHeight()) {
                n4 = 0;
                n3 = 0;
                n2 = bufferedImage.getWidth() - 1;
                n = bufferedImage.getHeight() - 1;
            } else {
                n = bufferedImage.getHeight() - 1;
                while (n4 > 0 && GUIToolBox.isWhiteLine(bufferedImage, n)) {
                    --n;
                }
                for (n3 = 0; n3 < bufferedImage.getWidth() && GUIToolBox.isWhiteColumn(bufferedImage, n3); ++n3) {
                }
                for (n2 = bufferedImage.getWidth() - 1; n2 > 0 && GUIToolBox.isWhiteColumn(bufferedImage, n2); --n2) {
                }
            }
            bufferedImage2 = new BufferedImage(n2 - n3 + 1, n - n4 + 1, 2);
            bufferedImage2.getGraphics().drawImage(bufferedImage, -n3, -n4, null);
        }
        return bufferedImage2;
    }

    public static boolean isWhiteColumn(BufferedImage bufferedImage, int n) {
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            if (n2 < bufferedImage.getHeight()) {
                if (bufferedImage.getRGB(n, n2) == Color.white.getRGB()) {
                    ++n2;
                    continue;
                }
                bl = true;
                bl2 = false;
                continue;
            }
            bl = true;
            bl2 = true;
        }
        return bl2;
    }

    public static boolean isWhiteLine(BufferedImage bufferedImage, int n) {
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            if (n2 < bufferedImage.getWidth()) {
                if (bufferedImage.getRGB(n2, n) == Color.white.getRGB()) {
                    ++n2;
                    continue;
                }
                bl = true;
                bl2 = false;
                continue;
            }
            bl = true;
            bl2 = true;
        }
        return bl2;
    }

    public static void saveScreenshot(Component component, File file) throws IOException {
        BufferedImage bufferedImage = GUIToolBox.crop(GUIToolBox.takeScreenshot(component));
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
    }

    public static BufferedImage takeScreenshot(Component component) {
        BufferedImage bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        component.paint(graphics2D);
        return bufferedImage;
    }
}

