/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckinstaller.util;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInformation {
    private static final Logger logger = LoggerFactory.getLogger(BuildInformation.class);
    private static String BUILD_INFORMATION_FILE = "/build_information.properties";
    private String productName;
    private String majorRevision;
    private String minorRevision;
    private String buildNumber;
    private String buildDate;
    private String generator;
    private String author;

    public BuildInformation() {
        Properties properties = new Properties();
        try {
            URL uRL = BuildInformation.class.getResource(BUILD_INFORMATION_FILE);
            if (uRL != null) {
                properties.load(BuildInformation.class.getResource(BUILD_INFORMATION_FILE).openStream());
            }
            this.productName = properties.getProperty("product.name", "PuckInstaller");
            this.majorRevision = properties.getProperty("product.revision.major", "d");
            this.minorRevision = properties.getProperty("product.revision.minor", "e");
            this.buildNumber = properties.getProperty("product.revision.build", "v");
            this.buildDate = properties.getProperty("product.revision.date", "today");
            this.generator = properties.getProperty("product.revision.generator", "n/a");
            this.author = properties.getProperty("product.revision.author", "n/a");
        }
        catch (IOException iOException) {
            logger.error("Error loading the build.properties file: " + iOException.getMessage());
            logger.error(ExceptionUtils.getStackTrace((Throwable)iOException));
            this.productName = "n/a";
            this.majorRevision = "n/a";
            this.minorRevision = "n/a";
            this.buildNumber = "n/a";
            this.buildDate = "n/a";
            this.generator = "n/a";
            this.author = "n/a";
        }
    }

    public String author() {
        return this.author;
    }

    public String buildDate() {
        return this.buildDate;
    }

    public String buildNumber() {
        return this.buildNumber;
    }

    public String generator() {
        return this.generator;
    }

    public String majorRevision() {
        return this.majorRevision;
    }

    public String minorRevision() {
        return this.minorRevision;
    }

    public String productName() {
        return this.productName;
    }

    public String toString() {
        String string = String.format("%s %s.%s.%s built on %s by %s", this.productName, this.majorRevision, this.minorRevision, this.buildNumber, this.buildDate, this.author);
        return string;
    }

    public String version() {
        String string = String.format("%s.%s.%s", this.majorRevision, this.minorRevision, this.buildNumber);
        return string;
    }

    public static boolean isDefined() {
        boolean bl = BuildInformation.class.getResource(BUILD_INFORMATION_FILE) != null;
        return bl;
    }
}

