/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckinstaller.model;

import com.sun.management.OperatingSystemMXBean;
import fr.devinsy.util.cmdexec.CmdExec;
import fr.devinsy.util.cmdexec.CmdExecException;
import fr.devinsy.util.strings.StringList;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckinstaller.model.InstallCriteria;
import org.tip.puckinstaller.views.InstallingPanel;

public class PuckInstallerManager {
    private static final Logger logger = LoggerFactory.getLogger(PuckInstallerManager.class);

    private PuckInstallerManager() {
    }

    public static void copyLocalApplicationFile(File file) throws IOException {
        File file2 = new File(SystemUtils.getUserHome(), ".local/share/applications/");
        file2.mkdirs();
        File file3 = new File(file, "puck.desktop");
        File file4 = new File(SystemUtils.getUserHome(), ".local/share/applications/puck.desktop");
        FileUtils.copyFile((File)file3, (File)file4);
    }

    public static void createDesktopFile(File file, File file2, File file3, InstallCriteria.OperatingSystem operatingSystem, String string, int n) throws IOException, CmdExecException {
        logger.debug("jreBin=[{}]", (Object)file2);
        if (operatingSystem == InstallCriteria.OperatingSystem.GNULinux_32 || operatingSystem == InstallCriteria.OperatingSystem.GNULinux_64) {
            StringList stringList = new StringList();
            stringList.appendln("[Desktop Entry]");
            stringList.appendln("Name=Puck");
            stringList.appendln("GenericName=Puck");
            stringList.appendln("Comment=Program for the Use and Computation of Kinship data");
            stringList.appendln("Icon=" + file.getAbsolutePath() + File.separatorChar + "puck.jpg");
            stringList.appendln("Type=Application");
            stringList.appendln("Categories=Science");
            stringList.appendln("Exec=/bin/sh \"" + file.getAbsolutePath() + File.separatorChar + "puck.sh\" %F");
            stringList.appendln("StartupNotify=false");
            stringList.appendln("Terminal=false");
            stringList.appendln("MimeType=application/puc;");
            stringList.appendln("X-Desktop-File-Install-Version=0.21");
            File file4 = new File(file, "puck.desktop");
            FileUtils.write((File)file4, (CharSequence)stringList.toString());
            file4.setExecutable(true, true);
        } else if (operatingSystem == InstallCriteria.OperatingSystem.MSWindows_32 || operatingSystem == InstallCriteria.OperatingSystem.MSWindows_64) {
            File file5 = new File(file, "puck.lnk");
            String string2 = file2 == null ? "" : file2.getAbsolutePath() + File.separatorChar;
            String string3 = "-Xms368m -Xmx" + n + "m -jar \"\"" + file3 + File.separatorChar + "puck.jar\"\"";
            File file6 = new File(file, "puck.ico");
            String string4 = "Program for the Use and Computation of Kinship data";
            StringList stringList = new StringList();
            stringList.appendln("Set oWS = WScript.CreateObject(\"WScript.Shell\")");
            stringList.appendln("sLinkFile = \"" + file5.getAbsolutePath() + "\"");
            stringList.appendln("Set oLink = oWS.CreateShortcut(sLinkFile)");
            stringList.appendln("oLink.TargetPath = \"" + string2 + "javaw.exe\"");
            stringList.appendln("oLink.Arguments = \"" + string3 + "\"");
            stringList.appendln("oLink.Description = \"" + string4 + "\"");
            stringList.appendln("oLink.IconLocation = \"" + file6.getAbsolutePath() + "\"");
            stringList.appendln("oLink.WindowStyle = \"1\"");
            stringList.appendln("oLink.Save");
            File file7 = new File(file, "linkMaker.vbs");
            FileUtils.writeLines((File)file7, (Collection)stringList);
            CmdExec.run((String)("wscript \"" + file7.getAbsolutePath() + "\""));
            file7.delete();
        } else if (operatingSystem == InstallCriteria.OperatingSystem.OSX_32 || operatingSystem == InstallCriteria.OperatingSystem.OSX_64) {
            String string5 = "-Xms368m -Xmx" + n + "m -jar '" + file3 + File.separatorChar + "puck.jar'";
            StringList stringList = new StringList();
            stringList.append("do shell script \"'");
            if (file2 != null) {
                stringList.append(file2.getAbsolutePath());
                stringList.append(File.separatorChar);
            }
            stringList.append("java");
            stringList.append("' ");
            stringList.append(string5);
            stringList.appendln("\"");
            stringList.appendln("tell application \"X11\" to quit");
            File file8 = new File(file, "puck.script");
            FileUtils.write((File)file8, (CharSequence)stringList.toString());
            logger.debug("script={}", (Object)stringList);
            File file9 = new File(file, "puck.app");
            StringList stringList2 = new StringList();
            stringList2.append("osacompile");
            stringList2.append("-o");
            stringList2.append(file9.getAbsolutePath());
            stringList2.append(file8.getAbsolutePath());
            CmdExec.run((String[])stringList2.toStringArray());
            file8.delete();
            URL uRL = InstallingPanel.class.getResource("/org/tip/puckinstaller/logo-puck-128x.icns");
            File file10 = new File(file9, "Contents/Resources/applet.icns");
            FileUtils.copyURLToFile((URL)uRL, (File)file10);
        }
    }

    public static void createIconFile(File file) throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            URL uRL = InstallingPanel.class.getResource("/org/tip/puckinstaller/logo-puck-250x.ico");
            File file2 = new File(file, "puck.ico");
            FileUtils.copyURLToFile((URL)uRL, (File)file2);
        } else if (SystemUtils.IS_OS_LINUX) {
            URL uRL = InstallingPanel.class.getResource("/org/tip/puckinstaller/logo-puck-250x.jpg");
            File file3 = new File(file, "puck.jpg");
            FileUtils.copyURLToFile((URL)uRL, (File)file3);
        }
    }

    public static void createLauncherScript(File file, File file2, File file3, InstallCriteria.OperatingSystem operatingSystem, String string, int n) throws IOException {
        logger.debug("jreBin=[{}]", (Object)file2);
        if (operatingSystem == InstallCriteria.OperatingSystem.GNULinux_32 || operatingSystem == InstallCriteria.OperatingSystem.GNULinux_64) {
            StringList stringList = new StringList();
            stringList.appendln("#!/bin/sh");
            stringList.append("\"");
            if (file2 != null) {
                stringList.append(file2.getAbsolutePath());
                stringList.append(File.separatorChar);
            }
            stringList.append("java\" -Xms368m -Xmx");
            stringList.append(n);
            stringList.append("m -jar \"");
            stringList.append(file3.getAbsolutePath());
            stringList.append(File.separatorChar);
            stringList.appendln("puck.jar\" $@");
            File file4 = new File(file, "puck.sh");
            FileUtils.write((File)file4, (CharSequence)stringList.toString());
            file4.setExecutable(true, true);
        } else if (operatingSystem == InstallCriteria.OperatingSystem.OSX_32 || operatingSystem == InstallCriteria.OperatingSystem.OSX_64) {
            StringList stringList = new StringList();
            stringList.appendln("#!/bin/sh");
            stringList.append("\"");
            if (file2 != null) {
                stringList.append(file2.getAbsolutePath());
                stringList.append(File.separatorChar);
            }
            stringList.append("java\" -Xms368m -Xmx");
            stringList.append(n);
            stringList.append("m -jar \"");
            stringList.append(file3.getAbsolutePath());
            stringList.append(File.separatorChar);
            stringList.appendln("puck.jar\" $@");
            File file5 = new File(file, "puck.command");
            FileUtils.write((File)file5, (CharSequence)stringList.toString());
            file5.setExecutable(true, true);
        } else if (operatingSystem == InstallCriteria.OperatingSystem.MSWindows_32 || operatingSystem == InstallCriteria.OperatingSystem.MSWindows_64) {
            StringList stringList = new StringList();
            stringList.append("start /b \"\"");
            stringList.append(" \"");
            if (file2 != null) {
                stringList.append(file2.getAbsolutePath());
                stringList.append(File.separatorChar);
            }
            stringList.append("javaw.exe\"");
            stringList.append(" -Xms368m -Xmx");
            stringList.append(n);
            stringList.append("m -jar \"");
            stringList.append(file3.getAbsolutePath());
            stringList.append(File.separatorChar);
            stringList.appendln("puck.jar\" %1 %2 %3 %4 %5 %6 %7");
            File file6 = new File(file, "puck.bat");
            FileUtils.write((File)file6, (CharSequence)stringList.toString());
        } else {
            logger.warn("Undefined operatingSystem value [{}]", (Object)operatingSystem);
        }
    }

    public static int getAvailableSystemMemoryKB() {
        int n;
        try {
            if (SystemUtils.IS_OS_LINUX) {
                StringList stringList = new StringList((Collection)FileUtils.readLines((File)new File("/proc/meminfo")));
                String[] stringArray = ((String)stringList.get(2)).split(" ");
                n = Integer.parseInt(stringArray[stringArray.length - 2]);
            } else {
                OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
                long l = operatingSystemMXBean.getFreePhysicalMemorySize();
                n = (int)(l / 1024L);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            n = 0;
        }
        logger.debug("availableMemorySize=" + n);
        return n;
    }

    public static int getSystemPhysicalMemoryKB() {
        int n;
        try {
            if (SystemUtils.IS_OS_LINUX) {
                StringList stringList = new StringList((Collection)FileUtils.readLines((File)new File("/proc/meminfo")));
                String[] stringArray = ((String)stringList.get(0)).split(" ");
                n = Integer.parseInt(stringArray[stringArray.length - 2]);
            } else {
                OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
                long l = operatingSystemMXBean.getTotalPhysicalMemorySize();
                logger.debug("physicalMemorySize=" + l);
                n = (int)(l / 1024L);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            n = 0;
        }
        return n;
    }

    public static boolean is32bits() {
        String string = System.getProperty("sun.arch.data.model");
        boolean bl = string == null ? true : string.contains("32");
        return bl;
    }
}

