/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckinstaller;

import java.awt.EventQueue;
import java.io.File;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckinstaller.PuckInstallerException;
import org.tip.puckinstaller.util.GUIToolBox;
import org.tip.puckinstaller.views.PuckInstallerWindow;

public class PuckInstaller {
    private static final Logger logger = LoggerFactory.getLogger(PuckInstaller.class);
    private File puckInstallerHome = new File(System.getProperty("user.home") + File.separator + ".puck");

    private PuckInstaller() {
        if (!this.puckInstallerHome.exists()) {
            this.puckInstallerHome.mkdir();
            logger.info("Puck home directory created: " + this.puckInstallerHome.getAbsolutePath());
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        System.out.println("System lookAndFeel property:" + System.getProperty("swing.defaultlaf"));
        System.out.println("Available lookAndFeel: " + GUIToolBox.availableLookAndFeels().toString());
        System.out.println("System lookAndFeel: " + UIManager.getSystemLookAndFeelClassName());
        System.out.println("Current lookAndFeel: " + UIManager.getLookAndFeel().getName());
        if (!StringUtils.equals((CharSequence)UIManager.getSystemLookAndFeelClassName(), (CharSequence)"javax.swing.plaf.metal.MetalLookAndFeel")) {
            try {
                System.out.println("Metal LAF setted and system LAF detected, try to set system LAF.");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                System.out.println("Failed to set the system LookAndFeel.");
            }
        } else if (GUIToolBox.availableLookAndFeels().toString().contains("GTK+")) {
            try {
                System.out.println("Metal LAF setted and GTK+ LAF detected, try to set GTK+ LAF.");
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
            catch (Exception exception) {
                System.out.println("Failed to set the system LookAndFeel.");
            }
        }
        System.out.println("Activated lookAndFeel: " + UIManager.getLookAndFeel().getName());
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                String string = throwable instanceof PuckInstallerException ? "Application error occured: " + throwable.getMessage() : (throwable instanceof OutOfMemoryError ? "Java ran out of memory!" : "Unexpected error occured: " + throwable.getClass() + "(" + throwable.getMessage() + ")");
                JOptionPane.showMessageDialog(null, string, "Error", 0);
                logger.error(throwable.getMessage(), throwable);
            }
        });
    }

    public void run() {
        new PuckInstallerWindow().setVisible(true);
    }

    public static PuckInstaller instance() {
        PuckInstaller puckInstaller = SingletonLoader.instance;
        return puckInstaller;
    }

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)PuckInstaller.class.getResource("/org/tip/puckinstaller/log4j.properties"));
        if (stringArray.length > 0 && StringUtils.startsWithAny((CharSequence)stringArray[0], (CharSequence[])new CharSequence[]{"-h", "-help", "--help"})) {
            System.out.println("puckinstaller [-h|-help|--help]");
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        PuckInstaller.instance().run();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    }

    private static class SingletonLoader {
        private static final PuckInstaller instance = new PuckInstaller();

        private SingletonLoader() {
        }
    }
}

