/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.models;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puckgui.InputSettings;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.models.IndividualChildrenModel;
import org.tip.puckgui.util.ComboBoxIds;

public class FamilyChildrenModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7713941886363202385L;
    private static final Logger logger = LoggerFactory.getLogger(FamilyChildrenModel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages");
    private static ImageIcon smallFemaleIcon = new ImageIcon(IndividualChildrenModel.class.getResource("/org/tip/puckgui/images/female-16x16.png"));
    private static ImageIcon smallMaleIcon = new ImageIcon(IndividualChildrenModel.class.getResource("/org/tip/puckgui/images/male-16x16.png"));
    private static ImageIcon smallUnknowIcon = new ImageIcon(IndividualChildrenModel.class.getResource("/org/tip/puckgui/images/unknown-16x16.png"));
    private Family source;
    private List<Individual> children;
    private NetGUI netGUI;

    public FamilyChildrenModel(NetGUI netGUI, Family source) {
        this.netGUI = netGUI;
        this.source = source;
        this.children = source == null ? new ArrayList<Individual>() : this.source.getChildren().toListSortedByOrder();
    }

    public List<Individual> children() {
        List<Individual> result = this.children;
        return result;
    }

    public void escapeNewEdition() {
        if (this.isNewEditionOn()) {
            logger.debug("ESCAPE d");
            int index = this.children.size() - 1;
            this.children.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public Class getColumnClass(int columnIndex) {
        Class result;
        switch (columnIndex) {
            case 0: {
                result = Number.class;
                break;
            }
            case 1: {
                result = ImageIcon.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            case 3: {
                result = Number.class;
                break;
            }
            case 4: {
                result = String.class;
                break;
            }
            case 5: {
                result = String.class;
                break;
            }
            default: {
                result = String.class;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 6;
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        switch (columnIndex) {
            case 0: {
                result = BUNDLE.getString("MainWindow.individual.id");
                break;
            }
            case 1: {
                result = BUNDLE.getString("MainWindow.individual.gender");
                break;
            }
            case 2: {
                result = BUNDLE.getString("MainWindow.individual.name");
                break;
            }
            case 3: {
                result = BUNDLE.getString("MainWindow.individual.position");
                break;
            }
            case 4: {
                result = BUNDLE.getString("MainWindow.individual.birth");
                break;
            }
            case 5: {
                result = BUNDLE.getString("MainWindow.individual.death");
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = this.children.size();
        return result;
    }

    public Family getSource() {
        Family result = this.source;
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        if (this.source == null) {
            result = null;
        } else if (this.isNewEditionOn() && rowIndex == this.children.size() - 1) {
            result = "";
        } else {
            block0 : switch (columnIndex) {
                case 0: {
                    result = this.children.get(rowIndex).getId();
                    break;
                }
                case 1: {
                    switch (this.children.get(rowIndex).getGender()) {
                        case FEMALE: {
                            result = smallFemaleIcon;
                            break block0;
                        }
                        case MALE: {
                            result = smallMaleIcon;
                            break block0;
                        }
                        case UNKNOWN: {
                            result = smallUnknowIcon;
                            break block0;
                        }
                    }
                    result = smallUnknowIcon;
                    break;
                }
                case 2: {
                    result = this.children.get(rowIndex).getName();
                    break;
                }
                case 3: {
                    result = this.children.get(rowIndex).getBirthOrder();
                    break;
                }
                case 4: {
                    result = null;
                    break;
                }
                case 5: {
                    result = null;
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean result;
        switch (col) {
            case 0: 
            case 3: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isNewEditionOn() {
        boolean result = this.source == null ? false : this.children.size() == this.source.getChildren().size() + 1;
        return result;
    }

    public void setNewItem() {
        this.children.add(new Individual(0, "?", Gender.UNKNOWN));
        this.fireTableDataChanged();
    }

    public void setSource(Family source) {
        this.source = source;
        this.children = source == null ? new ArrayList<Individual>() : this.source.getChildren().toListSortedByOrder();
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        logger.debug("setValueAt(" + rowIndex + ", " + columnIndex + " " + value + ")");
        if (columnIndex == 0) {
            if (this.netGUI != null) {
                if (this.isNewEditionOn()) {
                    Individual newChild = ComboBoxIds.getOrCreateIndividualFromInput(this.netGUI.getNet(), value, Gender.UNKNOWN);
                    if (newChild == null) {
                        this.children.remove(rowIndex);
                        this.fireTableDataChanged();
                    } else {
                        String errorMessage = FamilyChildrenModel.controlChildKinError(this.source, newChild);
                        if (errorMessage != null) {
                            JOptionPane.showMessageDialog(null, errorMessage, "Error", 0);
                        } else if (FamilyChildrenModel.controlChildKinWarningOK(this.source, newChild)) {
                            this.netGUI.getNet().removeChild(newChild);
                            this.netGUI.getNet().addChild(this.source, newChild);
                            this.netGUI.setChanged(true);
                            this.netGUI.updateAll();
                        }
                    }
                } else {
                    Individual oldChild = this.children.get(rowIndex);
                    Individual newChild = ComboBoxIds.getOrCreateIndividualFromInput(this.netGUI.getNet(), value, Gender.UNKNOWN);
                    if (newChild == null) {
                        this.netGUI.getNet().removeChild(oldChild);
                        this.netGUI.setChanged(true);
                        this.netGUI.updateAll();
                    } else if (newChild != oldChild) {
                        String errorMessage = FamilyChildrenModel.controlChildKinError(this.source, newChild);
                        if (errorMessage != null) {
                            JOptionPane.showMessageDialog(null, errorMessage, "Error", 0);
                        } else if (FamilyChildrenModel.controlChildKinWarningOK(this.source, newChild)) {
                            Family currentFamily = oldChild.getOriginFamily();
                            this.netGUI.getNet().removeChild(oldChild);
                            this.netGUI.getNet().removeChild(newChild);
                            this.netGUI.getNet().addChild(currentFamily, newChild);
                            this.netGUI.setChanged(true);
                            this.netGUI.updateAll();
                        }
                    }
                }
            }
        } else if (columnIndex == 3) {
            Integer newBirthOrderValue = value instanceof String ? (NumberUtils.isDigits((String)((String)value)) ? Integer.valueOf(Integer.parseInt((String)value)) : null) : (value instanceof Integer ? (Integer)value : null);
            if (newBirthOrderValue == null || newBirthOrderValue > 0) {
                Individual currentIndividual = this.netGUI.selectedIndividual();
                Individual child = this.children.get(rowIndex);
                child.setBirthOrder(newBirthOrderValue);
                this.netGUI.setChanged(true);
                this.netGUI.updateAll();
            }
        }
    }

    public Family source() {
        Family result = this.source;
        return result;
    }

    public static String controlChildKinError(Family family, Individual newChild) {
        String result = family.getChildren().contains(newChild) ? "Already child detected." : (newChild == family.getFather() || newChild == family.getMother() ? "This new child already is parent in this family." : (PuckGUI.instance().getPreferences().getInputSettings().getParentChildMarriages() == InputSettings.CheckLevel.ERROR && NetUtils.isParentChildMarriage(family, newChild) ? "Parent-child marriages detected.\nThis new child already is married with a parent of this family." : null));
        return result;
    }

    public static boolean controlChildKinWarningOK(Family family, Individual newChild) {
        int response;
        Object[] buttons;
        boolean result = true;
        if (PuckGUI.instance().getPreferences().getInputSettings().getParentChildMarriages() == InputSettings.CheckLevel.WARNING && NetUtils.isParentChildMarriage(family, newChild)) {
            buttons = new String[]{"Continue", "Abort"};
            response = JOptionPane.showOptionDialog(null, "Parent-child marriages detected.\nThis new child already is married with a parent of this family.", "Warning", 1, 2, null, buttons, buttons[0]);
            result = response == 0;
        }
        if (result && newChild.getOriginFamily() != null) {
            buttons = new String[]{"Continue", "Abort"};
            response = JOptionPane.showOptionDialog(null, "This new child already has a family.\nThe action will remove him of this family.", "Warning", 1, 2, null, buttons, buttons[0]);
            result = response == 0;
        }
        return result;
    }
}

