/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.graphs.workers.NodeValuator;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.Value;
import org.tip.puck.util.Values;
import org.tip.puck.workers.NodeReferentValuator;

public class PuckUtils {
    private static final Logger logger = LoggerFactory.getLogger(PuckUtils.class);

    public static int compare(String alpha, String bravo) {
        int result = alpha == null && bravo == null ? 0 : (alpha == null ? -1 : (bravo == null ? 1 : Collator.getInstance().compare(alpha, bravo)));
        return result;
    }

    public static boolean containsStrings(List<String> list, String content) {
        boolean result = false;
        String[] contents = content.split("\\;");
        block0: for (String item : list) {
            String[] stringArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                String testitem = stringArray[n2];
                if (item.equals(testitem)) {
                    result = true;
                    continue block0;
                }
                ++n2;
            }
        }
        return result;
    }

    public static boolean containsSubstring(List<String> list, String content) {
        boolean result = false;
        for (String item : list) {
            if (!item.contains(content)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static List<String> cumulateList(List<String> source) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(source.get(0));
        int i = 1;
        while (i < source.size()) {
            result.add(String.valueOf((String)result.get(i - 1)) + "-" + source.get(i));
            ++i;
        }
        return result;
    }

    public static boolean equalsAny(CharSequence string, CharSequence ... searchStrings) {
        boolean result;
        if (StringUtils.isEmpty((CharSequence)string) || ArrayUtils.isEmpty((Object[])searchStrings)) {
            result = false;
        } else {
            boolean ended = false;
            result = false;
            int index = 0;
            while (!ended) {
                if (index < searchStrings.length) {
                    if (StringUtils.equals((CharSequence)string, (CharSequence)searchStrings[index])) {
                        ended = true;
                        result = true;
                        continue;
                    }
                    ++index;
                    continue;
                }
                ended = true;
                result = false;
            }
        }
        return result;
    }

    public static boolean equalsAnyIgnoreCase(CharSequence string, CharSequence ... searchStrings) {
        boolean result;
        if (StringUtils.isEmpty((CharSequence)string) || ArrayUtils.isEmpty((Object[])searchStrings)) {
            result = false;
        } else {
            boolean ended = false;
            result = false;
            int index = 0;
            while (!ended) {
                if (index < searchStrings.length) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)searchStrings[index])) {
                        ended = true;
                        result = true;
                        continue;
                    }
                    ++index;
                    continue;
                }
                ended = true;
                result = false;
            }
        }
        return result;
    }

    public static NumberedValues[] getGenderedNumberedValues(NumberedValues values, Individuals individuals) {
        NumberedValues[] result = new NumberedValues[3];
        int i = 0;
        while (i < 3) {
            result[i] = new NumberedValues();
            ++i;
        }
        for (Individual individual : individuals) {
            int id = individual.getId();
            int gender = individual.getGender().toInt();
            result[gender].put(id, (Value)values.get(id));
            result[2].put(id, (Value)values.get(id));
        }
        return result;
    }

    public static List<StringList> readLineBlocks(BufferedReader in) throws IOException {
        ArrayList<StringList> result = new ArrayList<StringList>();
        boolean ended = false;
        StringList currentBlock = null;
        while (!ended) {
            String line = in.readLine();
            if (line == null) {
                ended = true;
                continue;
            }
            if (StringUtils.isBlank((CharSequence)line)) {
                currentBlock = null;
                continue;
            }
            if (currentBlock == null) {
                currentBlock = new StringList();
                result.add(currentBlock);
            }
            currentBlock.add((Object)line);
        }
        return result;
    }

    public static StringList readLines(BufferedReader in) throws IOException {
        StringList result = new StringList();
        boolean ended = false;
        while (!ended) {
            String line = in.readLine();
            if (line == null) {
                ended = true;
                continue;
            }
            result.add((Object)line);
        }
        return result;
    }

    public static <E> StringList writeGISNetwork(Graph<E> source) throws PuckException {
        StringList result = null;
        return result;
    }

    public static StringList writeMatrix(double[][] matrix) {
        StringList result = new StringList();
        int i = 0;
        while (i < matrix.length) {
            String line = "";
            int j = 0;
            while (j < matrix[i].length) {
                line = String.valueOf(line) + matrix[i][j] + "\t";
                ++j;
            }
            result.appendln(line);
            ++i;
        }
        return result;
    }

    public static <E> StringList writePajekNetwork(Graph<E> source) throws PuckException {
        StringList result = PuckUtils.writePajekNetwork(source, null);
        return result;
    }

    public static <E> StringList writePajekNetwork(Graph<E> source, List<String> partitionLabels) throws PuckException {
        return PuckUtils.writePajekNetwork(source, partitionLabels, null);
    }

    public static <E> StringList writePajekNetwork(Graph<E> source, List<String> partitionLabels, Map<String, Map<Value, Integer>> partitionNumbersMaps) throws PuckException {
        StringList result = GraphUtils.writePajekNetwork(source, NodeValuator.getMatchingLabels(partitionLabels), partitionNumbersMaps);
        for (String label : NodeValuator.getNotMatchingLabels(partitionLabels)) {
            result.appendln();
            Values values = new NodeReferentValuator<Node<E>>().get(source.getNodes().toListSortedById(), label);
            if (values.isNull()) {
                values = NodeValuator.get(source, label);
            }
            if (label.contains("DATE")) {
                values.nullToZero();
            }
            if (values.isNumeric()) {
                if (label.equals("STEP")) {
                    result.appendln("*Partition " + label + " " + source.getLabel());
                } else {
                    result.appendln("*Vector " + label + " " + source.getLabel());
                }
                result.appendln("*vertices " + source.nodeCount());
                for (Value value : values) {
                    result.appendln(value.intValue());
                }
                continue;
            }
            Partition<Value> partition = PartitionMaker.create(label, values);
            Map<Value, Integer> partitionNumbersMap = null;
            if (partitionNumbersMaps != null) {
                partitionNumbersMap = partitionNumbersMaps.get(label);
            }
            partition = PartitionMaker.createNumerized(partition, partitionNumbersMap);
            result.appendln("*Partition " + partition.getLabel() + " " + source.getLabel());
            result.appendln("*vertices " + source.nodeCount());
            int valueIndex = 1;
            while (valueIndex <= values.size()) {
                Value value = (Value)values.get(valueIndex - 1);
                result.appendln(partition.getValue(value).intValue());
                ++valueIndex;
            }
        }
        return result;
    }

    public static <E> StringList writePajekPartition(Partition<E> partition, Comparator<E> comparator, Map<Value, Integer> partitionNumbersMap) throws PuckException {
        StringList result = new StringList();
        String label = partition.getLabel();
        if (partition.isNumeric()) {
            result.appendln("*Vector " + label);
            result.appendln("*vertices " + partition.itemsCount());
            for (E item : partition.getItemsAsSortedList(comparator)) {
                result.appendln(partition.getValue(item).intValue());
            }
        } else {
            partition = PartitionMaker.createNumerized(partition, partitionNumbersMap);
            result.appendln("*Partition " + label);
            result.appendln("*vertices " + partition.itemsCount());
            for (E item : partition.getItemsAsSortedList(comparator)) {
                result.appendln(partition.getValue(item).intValue());
            }
        }
        return result;
    }
}

