/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class NumberedObjects
extends HashMap<Integer, Object>
implements Iterable<Object> {
    private static final long serialVersionUID = 7423770237304696469L;

    public NumberedObjects() {
    }

    public NumberedObjects(int initialCapacity) {
        super(initialCapacity);
    }

    public void addValue(int number, double value) {
        this.put(number, new Double(value));
    }

    public void addValue(int number, int value) {
        this.put(number, new Integer(value));
    }

    public void addValue(int number, Object value) {
        if (value == null) {
            this.put(number, null);
        } else {
            this.put(number, value);
        }
    }

    public double average() {
        double sum = 0.0;
        int count = 0;
        for (Object value : this) {
            if (value == null || !NumberedObjects.isNumber(value)) continue;
            sum += NumberedObjects.doubleValue(value);
            ++count;
        }
        double result = count == 0 ? 0.0 : sum * 1.0 / (double)count;
        return result;
    }

    public double averagePositives() {
        double sum = 0.0;
        int count = 0;
        for (Object value : this) {
            double doubleValue;
            if (value == null || !NumberedObjects.isNumber(value) || !((doubleValue = NumberedObjects.doubleValue(value)) > 0.0)) continue;
            sum += doubleValue;
            ++count;
        }
        double result = count == 0 ? 0.0 : sum * 1.0 / (double)count;
        return result;
    }

    @Override
    public Iterator<Object> iterator() {
        Iterator<Object> result = super.values().iterator();
        return result;
    }

    public double max() {
        Double maxValue = null;
        for (Object value : this) {
            if (value == null || !NumberedObjects.isNumber(value)) continue;
            if (maxValue == null) {
                maxValue = NumberedObjects.doubleValue(value);
                continue;
            }
            if (!(NumberedObjects.doubleValue(value) > maxValue)) continue;
            maxValue = NumberedObjects.doubleValue(value);
        }
        double result = maxValue == null ? 0.0 : maxValue;
        return result;
    }

    public double min() {
        Double minValue = null;
        for (Object value : this) {
            if (value == null || !NumberedObjects.isNumber(value)) continue;
            if (minValue == null) {
                minValue = NumberedObjects.doubleValue(value);
                continue;
            }
            if (!(NumberedObjects.doubleValue(value) < minValue)) continue;
            minValue = NumberedObjects.doubleValue(value);
        }
        double result = minValue == null ? 0.0 : minValue;
        return result;
    }

    public List<Object> toList() {
        ArrayList<Object> result = new ArrayList<Object>(this.values());
        return result;
    }

    private static double doubleValue(Object value) {
        double result;
        if (value == null) {
            throw new ClassCastException("Null is not a number.");
        }
        if (value instanceof Integer) {
            result = ((Integer)value).doubleValue();
        } else if (value instanceof Double) {
            result = (Double)value;
        } else {
            throw new ClassCastException("Value is not a number.");
        }
        return result;
    }

    private static boolean isNumber(Object value) {
        boolean result = value == null ? false : value instanceof Integer || value instanceof Double;
        return result;
    }
}

