/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.workers.ExpansionMode;

public class SpaceTimeCriteria {
    private String relationModelName;
    private String dateLabel;
    private String startDateLabel;
    private String endDateLabel;
    private String placeLabel;
    private String startPlaceLabel;
    private String endPlaceLabel;
    private String localUnitLabel;
    private String groupAffiliationLabel;
    private String egoRoleName;
    private String defaultReferentRoleName;
    private StringList roleNames;
    private int maxAge;
    private int minAge;
    private Integer[] dates;
    private Geography geography;
    private GeoLevel level;
    private StringList minimalPlaceNames;
    private ExpansionMode expansionMode;
    private FiliationType filiationType;
    private CensusType censusType;
    private String pattern;
    private String chainClassification;
    private List<String> relationModelNames;
    private String individualClassificationType;
    private List<RelationClassificationType> relationClassificationTypes;
    private List<RelationClassificationType> mainRelationClassificationTypes;
    private List<RelationClassificationType> trajectoriesRelationClassificationTypes;
    private List<String> censusOperationLabels;
    private List<String> networkTitles;
    private Map<String, List<String>> partitionLabels;
    private List<String> nodeStatisticsLabels;
    private String alterFilterRoleName;
    private String alterFilterAttributeLabel;
    private String alterFilterAttributeValue;
    private List<SequenceReportType> sequenceReportTypes;
    private List<SliceReportType> sliceReportTypes;
    private List<SequenceGeneralStatistics> sequenceGeneralStatistics;
    private List<SliceGeneralStatistics> sliceGeneralStatistics;
    private List<EgoNetworksOperation> egoNetworksOperations;
    private List<TrajectoriesOperation> trajectoriesOperations;
    private List<ParcoursNetworksOperation> parcoursNetworkdsOperations;
    private List<ParcoursIntersectionNetworksOperation> parcoursIntersectionNetworksOperations;
    private List<ParcoursSimilarityNetworksOperation> parcoursSimilarityNetworksOperations;

    public SpaceTimeCriteria() {
        this.sequenceReportTypes = new ArrayList<SequenceReportType>();
        this.sliceReportTypes = new ArrayList<SliceReportType>();
        this.sequenceGeneralStatistics = new ArrayList<SequenceGeneralStatistics>();
        this.sliceGeneralStatistics = new ArrayList<SliceGeneralStatistics>();
        this.egoNetworksOperations = new ArrayList<EgoNetworksOperation>();
        this.trajectoriesRelationClassificationTypes = new ArrayList<RelationClassificationType>();
        this.trajectoriesOperations = new ArrayList<TrajectoriesOperation>();
        this.parcoursNetworkdsOperations = new ArrayList<ParcoursNetworksOperation>();
        this.parcoursIntersectionNetworksOperations = new ArrayList<ParcoursIntersectionNetworksOperation>();
        this.parcoursSimilarityNetworksOperations = new ArrayList<ParcoursSimilarityNetworksOperation>();
        this.setDefaultCriteria();
    }

    public void setCensusParameters() {
        this.censusOperationLabels = new ArrayList<String>();
        this.censusOperationLabels.add("NREVENTS");
        if (!this.getSequenceGeneralStatistics().isEmpty()) {
            if (!this.relationClassificationTypes.contains((Object)RelationClassificationType.PLACE)) {
                this.relationClassificationTypes.add(RelationClassificationType.PLACE);
            }
            if (!this.relationClassificationTypes.contains((Object)RelationClassificationType.DISTANCE)) {
                this.relationClassificationTypes.add(RelationClassificationType.DISTANCE);
            }
        }
        if (this.getSequenceGeneralStatistics().contains((Object)SequenceGeneralStatistics.EVENTS)) {
            this.censusOperationLabels.add("NREXTERNALMOVES");
            this.censusOperationLabels.add("MAX_DISTANCE");
            this.censusOperationLabels.add("MEAN_NR_MOVES");
            for (RelationClassificationType type : this.relationClassificationTypes) {
                this.censusOperationLabels.add("EVENTS_" + (Object)((Object)type));
            }
        }
        if (this.getSequenceGeneralStatistics().contains((Object)SequenceGeneralStatistics.AGE)) {
            this.censusOperationLabels.add("AGEFIRST");
            this.censusOperationLabels.add("AGEFIRST_CHILDMIGRATIONTYPE_NOPARENTS");
            this.censusOperationLabels.add("AGEFIRST_DISTANCE_TRANSNATIONAL");
        }
        if (this.getSequenceGeneralStatistics().contains((Object)SequenceGeneralStatistics.RELATIONS)) {
            this.censusOperationLabels.add("SAMESEXALTERS_ALL");
            this.censusOperationLabels.add("SAMEPLACEALTERS_ALL");
            for (String roleName : this.roleNames) {
                this.censusOperationLabels.add("NRALTERS_" + roleName);
                this.censusOperationLabels.add("NRALTERSPEREVENT_" + roleName);
            }
            this.censusOperationLabels.add("MEAN_COVERAGE");
            this.censusOperationLabels.add("MAX_COVERAGE");
            for (String roleName : this.roleNames) {
                this.censusOperationLabels.add("RELATIONS_" + roleName);
            }
            this.censusOperationLabels.add("MAIN_ALTERS");
            this.censusOperationLabels.add("MAIN_RELATIONS");
        }
        if (this.getEgoNetworksOperations().contains((Object)EgoNetworksOperation.GENERAL)) {
            this.censusOperationLabels.add("SIZE");
            this.censusOperationLabels.add("TIES");
            this.censusOperationLabels.add("DENSITY");
            this.censusOperationLabels.add("DENSITY_NOLOOPS");
            this.censusOperationLabels.add("MEANDEGREE");
            this.censusOperationLabels.add("MEANDEGREE_NOLOOPS");
            this.censusOperationLabels.add("MEANDEGREE_NOLOOPS_NORM");
        }
        if (this.getEgoNetworksOperations().contains((Object)EgoNetworksOperation.CENTRALITY)) {
            this.censusOperationLabels.add("EGO-BETWEENNESS");
            this.censusOperationLabels.add("MEAN_BETWEENNESS");
            this.censusOperationLabels.add("MAX_BETWEENNESS");
            this.censusOperationLabels.add("ECCENTRICITY");
        }
        if (this.getEgoNetworksOperations().contains((Object)EgoNetworksOperation.COHESION)) {
            this.censusOperationLabels.add("NRCOMPONENTS");
            this.censusOperationLabels.add("NRISOLATES");
            this.censusOperationLabels.add("MAXCOMPONENT");
            this.censusOperationLabels.add("NRCOMPONENTS_NORM");
            this.censusOperationLabels.add("NRISOLATES_NORM");
            this.censusOperationLabels.add("MAXCOMPONENT_NORM");
            this.censusOperationLabels.add("CONCENTRATION");
            this.censusOperationLabels.add("BROKERAGE");
            this.censusOperationLabels.add("EFFICIENT_SIZE");
            this.censusOperationLabels.add("EFFICIENCY");
        }
        if (this.getEgoNetworksOperations().contains((Object)EgoNetworksOperation.RELATIONS)) {
            this.censusOperationLabels.add("NETWORK_RELATIONS");
            this.censusOperationLabels.add("CONNECTED_NETWORK_RELATIONS");
            this.censusOperationLabels.add("CENTRAL_ALTERS");
            this.censusOperationLabels.add("CENTRAL_RELATIONS");
            this.censusOperationLabels.add("SDENSITY_PARENT-CHILD");
            this.censusOperationLabels.add("SDENSITY_SPOUSE");
            this.censusOperationLabels.add("SDENSITY_SIBLING");
            this.censusOperationLabels.add("SDENSITY_RELATIVE");
            this.censusOperationLabels.add("SDENSITY_AFFINE");
        }
        for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
            if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.GENERAL)) {
                this.censusOperationLabels.add("SIZE_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("TIES_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("DENSITY_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("DENSITY_NOLOOPS_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("MEANDEGREE_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("MEANDEGREE_NOLOOPS_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("MEANDEGREE_NOLOOPS_NORM_" + (Object)((Object)mainEventType));
            }
            if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.CENTRALITY)) {
                this.censusOperationLabels.add("MEAN_BETWEENNESS_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("MAX_BETWEENNESS_" + (Object)((Object)mainEventType));
            }
            if (!this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.RELATIONS)) continue;
            this.censusOperationLabels.add("CENTRAL_ALTERS_" + (Object)((Object)mainEventType));
        }
        for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
            if (this.getParcoursIntersectionNetworksOperations().contains((Object)ParcoursIntersectionNetworksOperation.GENERAL)) {
                this.censusOperationLabels.add("SIZE_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("TIES_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("DENSITY_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("DENSITY_NOLOOPS_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("MEANDEGREE_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("MEANDEGREE_NOLOOPS_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("MEANDEGREE_NOLOOPS_NORM_" + (Object)((Object)mainEventType));
            }
            if (this.getParcoursIntersectionNetworksOperations().contains((Object)ParcoursIntersectionNetworksOperation.CENTRALITY)) {
                this.censusOperationLabels.add("EGO-BETWEENNESS_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("MEAN_BETWEENNESS_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("MAX_BETWEENNESS_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("ECCENTRICITY_" + (Object)((Object)mainEventType));
            }
            if (this.getParcoursIntersectionNetworksOperations().contains((Object)ParcoursIntersectionNetworksOperation.COHESION)) {
                this.censusOperationLabels.add("NRCOMPONENTS_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("NRISOLATES_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("MAXCOMPONENT_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("NRCOMPONENTS_NORM_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("NRISOLATES_NORM_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("MAXCOMPONENT_NORM_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("CONCENTRATION_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("BROKERAGE_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("EFFICIENT_SIZE_" + (Object)((Object)mainEventType));
                this.censusOperationLabels.add("EFFICIENCY_" + (Object)((Object)mainEventType));
            }
            if (!this.getParcoursIntersectionNetworksOperations().contains((Object)ParcoursIntersectionNetworksOperation.GENERAL)) continue;
            this.censusOperationLabels.add("NETWORK_RELATIONS_" + (Object)((Object)mainEventType));
            this.censusOperationLabels.add("CONNECTED_NETWORK_RELATIONS_" + (Object)((Object)mainEventType));
            this.censusOperationLabels.add("SIMILARITY_" + (Object)((Object)mainEventType));
        }
        if (!this.getTrajectoriesOperations().isEmpty()) {
            if (!this.relationClassificationTypes.contains((Object)RelationClassificationType.PLACE)) {
                this.relationClassificationTypes.add(RelationClassificationType.PLACE);
            }
            if (!this.relationClassificationTypes.contains((Object)RelationClassificationType.DISTANCE)) {
                this.relationClassificationTypes.add(RelationClassificationType.DISTANCE);
            }
            if (this.getTrajectoriesOperations().contains((Object)TrajectoriesOperation.DRAW)) {
                this.trajectoriesRelationClassificationTypes.add(RelationClassificationType.PLACE);
            }
            this.censusOperationLabels.add("NREVENTS");
            this.censusOperationLabels.add("NREXTERNALMOVES");
            for (RelationClassificationType relationClassificationType : this.trajectoriesRelationClassificationTypes) {
                this.censusOperationLabels.add("PROFILE_" + (Object)((Object)relationClassificationType));
                this.censusOperationLabels.add("SUPPORT_" + (Object)((Object)relationClassificationType));
                this.censusOperationLabels.add("NRSTATIONS_" + (Object)((Object)relationClassificationType));
                if (relationClassificationType != RelationClassificationType.PLACE) continue;
                this.censusOperationLabels.add("CENTERS_" + (Object)((Object)relationClassificationType));
                this.censusOperationLabels.add("CENTERSNOSTART_" + (Object)((Object)relationClassificationType));
                this.censusOperationLabels.add("NRCENTERS_" + (Object)((Object)relationClassificationType));
                this.censusOperationLabels.add("NRCENTERSNOSTART_" + (Object)((Object)relationClassificationType));
                this.censusOperationLabels.add("NRINTERNALMOVES_" + (Object)((Object)relationClassificationType));
                this.censusOperationLabels.add("NRDIRECTRETURNS_" + (Object)((Object)relationClassificationType));
                this.censusOperationLabels.add("NRCYCLES_" + (Object)((Object)relationClassificationType));
                this.censusOperationLabels.add("NRDIRECTRETURNS_NORM_" + (Object)((Object)relationClassificationType));
                this.censusOperationLabels.add("NRCYCLES_NORM_" + (Object)((Object)relationClassificationType));
            }
        }
        for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
            if (this.relationClassificationTypes.contains((Object)mainEventType)) continue;
            this.relationClassificationTypes.add(mainEventType);
        }
        for (RelationClassificationType mainEventType : this.trajectoriesRelationClassificationTypes) {
            if (this.relationClassificationTypes.contains((Object)mainEventType)) continue;
            this.relationClassificationTypes.add(mainEventType);
        }
        this.networkTitles = new ArrayList<String>();
        if (!this.getEgoNetworksOperations().isEmpty()) {
            this.addNetworkTitle("Ego Network");
            this.addNetworkTitle("Nonmediated Ego Network");
            this.partitionLabels.get("Ego Network").add("EGO-RELATION");
            this.partitionLabels.get("Ego Network").add("DEGREE");
            this.partitionLabels.get("Nonmediated Ego Network").add("BETWEENNESS");
            this.partitionLabels.get("Nonmediated Ego Network").add("EGO-RELATION");
            this.partitionLabels.get("Nonmediated Ego Network").add("DEGREE");
            this.partitionLabels.get("Nonmediated Ego Network").add("COMPONENT");
            this.addNetworkTitle("Parcours Intersection Network");
            this.partitionLabels.get("Parcours Intersection Network").add("EGO-RELATION");
            this.partitionLabels.get("Parcours Intersection Network").add("NREVENTS");
            for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
                this.addNetworkTitle("Parcours Similarity Network_" + (Object)((Object)mainEventType));
                this.partitionLabels.get("Parcours Similarity Network_" + (Object)((Object)mainEventType)).add("EGO-RELATION");
                this.partitionLabels.get("Parcours Similarity Network_" + (Object)((Object)mainEventType)).add("NRTRANSITIONS");
            }
        }
        if (!this.getParcoursIntersectionNetworksOperations().isEmpty()) {
            this.addNetworkTitle("Parcours Intersection Network");
            this.partitionLabels.get("Parcours Intersection Network").add("EGO-RELATION");
            this.partitionLabels.get("Parcours Intersection Network").add("NREVENTS");
        }
        if (!this.getParcoursSimilarityNetworksOperations().isEmpty()) {
            this.addNetworkTitle("Parcours Similarity Network");
            this.partitionLabels.get("Parcours Similarity Network").add("EGO-RELATION");
            this.partitionLabels.get("Parcours Similarity Network").add("NREVENTS");
        }
        if (!this.getParcoursNetworksOperations().isEmpty()) {
            for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
                this.addNetworkTitle("Parcours Network_" + (Object)((Object)mainEventType));
                this.addNetworkTitle("Parcours Similarity Tree_" + (Object)((Object)mainEventType));
                this.addNetworkTitle("Parcours Network Fused_" + (Object)((Object)mainEventType));
                this.partitionLabels.get("Parcours Network_" + (Object)((Object)mainEventType)).add("DEGREE");
            }
        }
        if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.EXPORT_PARCOURS)) {
            this.addNetworkTitle("Parcours");
            this.partitionLabels.get("Parcours").add("DATE");
            this.partitionLabels.get("Parcours").add("DISTANCE");
        }
        if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.EXPORT_EXTENDED_PARCOURS)) {
            this.addNetworkTitle("Extended Parcours");
            this.partitionLabels.get("Extended Parcours").add("ORDER");
            this.partitionLabels.get("Extended Parcours").add("TYPE");
        }
        if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.EXPORT_MULTIPLE_PARCOURS)) {
            this.addNetworkTitle("Multiple Parcours");
            this.partitionLabels.get("Multiple Parcours").add("DATE");
            this.partitionLabels.get("Multiple Parcours").add("DISTANCE");
        }
        if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.EXPORT_SIMILARY_TREES)) {
            for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
                this.addNetworkTitle("Parcours Similarity Tree_" + (Object)((Object)mainEventType));
            }
        }
        if (!this.getTrajectoriesOperations().isEmpty()) {
            this.addNetworkTitle("Event Type Network");
            this.addNetworkTitle("Sequence Type Network");
        }
        if (this.getParcoursNetworksOperations().contains((Object)ParcoursNetworksOperation.EXPORT_PARCOURS_NETWORKS)) {
            this.nodeStatisticsLabels = new ArrayList<String>();
            this.nodeStatisticsLabels.add("NUMBER");
            this.nodeStatisticsLabels.add("INDEGREE");
            this.nodeStatisticsLabels.add("OUTDEGREE");
            this.nodeStatisticsLabels.add("INSTRENGTH");
            this.nodeStatisticsLabels.add("OUTSTRENGTH");
            this.nodeStatisticsLabels.add("ORIENTATION");
            this.nodeStatisticsLabels.add("BETWEENNESS");
            this.nodeStatisticsLabels.add("MAXINWEIGHT");
            this.nodeStatisticsLabels.add("MAXOUTWEIGHT");
            this.nodeStatisticsLabels.add("MAXPREDECESSOR");
            this.nodeStatisticsLabels.add("MAXSUCCESSOR");
        }
    }

    public SpaceTimeCriteria(CensusType censusType) {
        this.setDefaultCriteria();
        this.censusType = censusType;
        if (censusType == CensusType.PARCOURSNETWORKS) {
            this.alterFilterAttributeLabel = "INTERV";
            this.alterFilterAttributeValue = "Yes";
        }
        switch (censusType) {
            case GENERAL: {
                this.relationClassificationTypes.add(RelationClassificationType.PLACE);
                this.relationClassificationTypes.add(RelationClassificationType.MIGRATIONTYPE);
                this.relationClassificationTypes.add(RelationClassificationType.TREES);
                this.relationClassificationTypes.add(RelationClassificationType.CHILDMIGRATIONTYPE);
                this.relationClassificationTypes.add(RelationClassificationType.DISTANCE);
                this.relationClassificationTypes.add(RelationClassificationType.REGION);
                break;
            }
            case EGONETWORKS: {
                this.relationClassificationTypes.add(RelationClassificationType.PLACE);
                break;
            }
            case PARCOURSNETWORKS: {
                this.relationClassificationTypes.add(RelationClassificationType.PLACE);
                break;
            }
            case PARCOURS: {
                this.relationClassificationTypes.add(RelationClassificationType.PLACE);
            }
        }
        switch (censusType) {
            case GENERAL: {
                break;
            }
            case EGONETWORKS: {
                break;
            }
            case PARCOURSNETWORKS: {
                this.mainRelationClassificationTypes.add(RelationClassificationType.MIGRATIONTYPE);
                this.mainRelationClassificationTypes.add(RelationClassificationType.TYPEDID);
                break;
            }
            case PARCOURS: {
                this.mainRelationClassificationTypes.add(RelationClassificationType.PLACE);
                this.mainRelationClassificationTypes.add(RelationClassificationType.DISTANCE);
                this.mainRelationClassificationTypes.add(RelationClassificationType.TREES);
                this.mainRelationClassificationTypes.add(RelationClassificationType.MIGRATIONTYPE);
            }
        }
        for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
            if (this.relationClassificationTypes.contains((Object)mainEventType)) continue;
            this.relationClassificationTypes.add(mainEventType);
        }
        this.networkTitles = new ArrayList<String>();
        this.partitionLabels = new HashMap<String, List<String>>();
        switch (censusType) {
            case GENERAL: {
                break;
            }
            case EGONETWORKS: {
                this.addNetworkTitle("Ego Network");
                this.addNetworkTitle("Nonmediated Ego Network");
                break;
            }
            case PARCOURSNETWORKS: {
                this.addNetworkTitle("Parcours");
                this.addNetworkTitle("Extended Parcours");
                this.addNetworkTitle("Multiple Parcours");
                for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
                    this.addNetworkTitle("Parcours Network_" + (Object)((Object)mainEventType));
                    this.addNetworkTitle("Parcours Similarity Tree_" + (Object)((Object)mainEventType));
                }
                break;
            }
            case PARCOURS: {
                this.addNetworkTitle("Event Type Network");
                this.addNetworkTitle("Sequence Type Network");
            }
        }
        switch (censusType) {
            case GENERAL: {
                break;
            }
            case EGONETWORKS: {
                this.partitionLabels.get("Ego Network").add("EGO-RELATION");
                this.partitionLabels.get("Ego Network").add("DEGREE");
                this.partitionLabels.get("Nonmediated Ego Network").add("BETWEENNESS");
                this.partitionLabels.get("Nonmediated Ego Network").add("EGO-RELATION");
                this.partitionLabels.get("Nonmediated Ego Network").add("DEGREE");
                this.partitionLabels.get("Nonmediated Ego Network").add("COMPONENT");
                break;
            }
            case PARCOURSNETWORKS: {
                this.partitionLabels.get("Parcours").add("DATE");
                this.partitionLabels.get("Parcours").add("DISTANCE");
                this.partitionLabels.get("Multiple Parcours").add("DATE");
                this.partitionLabels.get("Multiple Parcours").add("DISTANCE");
                this.partitionLabels.get("Extended Parcours").add("ORDER");
                this.partitionLabels.get("Extended Parcours").add("TYPE");
                break;
            }
            case PARCOURSINTERSECTIONNETWORKS: {
                this.partitionLabels.get("Parcours Intersection Network").add("EGO-RELATION");
                break;
            }
            case PARCOURSSIMILARITYNETWORKS: {
                this.partitionLabels.get("Parcours Intersection Network").add("EGO-RELATION");
                break;
            }
        }
        if (censusType == CensusType.PARCOURSNETWORKS) {
            for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
                List<String> egoNetworkPartitionLabels = this.partitionLabels.get("Parcours Network_" + (Object)((Object)mainEventType));
                egoNetworkPartitionLabels.add("BETWEENNESS");
                egoNetworkPartitionLabels.add("EGO-RELATION");
                egoNetworkPartitionLabels.add("DEGREE");
                egoNetworkPartitionLabels.add("COMPONENT");
                List<String> treePartitionLabels = this.partitionLabels.get("Parcours Similarity Tree_" + (Object)((Object)mainEventType));
                treePartitionLabels.add("SIZE");
                treePartitionLabels.add("STEP");
                treePartitionLabels.add("EGO-RELATION");
            }
        }
        this.censusOperationLabels = new ArrayList<String>();
        switch (censusType) {
            case GENERAL: {
                this.censusOperationLabels.add("NREVENTS");
                this.censusOperationLabels.add("NREXTERNALMOVES");
                this.censusOperationLabels.add("AGEFIRST");
                this.censusOperationLabels.add("AGEFIRST_CHILDMIGRATIONTYPE_NOPARENTS");
                this.censusOperationLabels.add("AGEFIRST_DISTANCE_TRANSNATIONAL");
                this.censusOperationLabels.add("MAX_DISTANCE");
                this.censusOperationLabels.add("MEAN_NR_MOVES");
                this.censusOperationLabels.add("SAMESEXALTERS_ALL");
                this.censusOperationLabels.add("SAMEPLACEALTERS_ALL");
                for (String roleName : this.roleNames) {
                    this.censusOperationLabels.add("NRALTERS_" + roleName);
                    this.censusOperationLabels.add("NRALTERSPEREVENT_" + roleName);
                }
                for (RelationClassificationType type : this.relationClassificationTypes) {
                    this.censusOperationLabels.add("EVENTS_" + (Object)((Object)type));
                }
                this.censusOperationLabels.add("MEAN_COVERAGE");
                this.censusOperationLabels.add("MAX_COVERAGE");
                for (String roleName : this.roleNames) {
                    this.censusOperationLabels.add("RELATIONS_" + roleName);
                }
                this.censusOperationLabels.add("MAIN_ALTERS");
                this.censusOperationLabels.add("MAIN_RELATIONS");
                break;
            }
            case EGONETWORKS: {
                this.censusOperationLabels.add("NREVENTS");
                this.censusOperationLabels.add("NREXTERNALMOVES");
                this.censusOperationLabels.add("SIZE");
                this.censusOperationLabels.add("TIES");
                this.censusOperationLabels.add("EGO-BETWEENNESS");
                this.censusOperationLabels.add("MEAN_BETWEENNESS");
                this.censusOperationLabels.add("MAX_BETWEENNESS");
                this.censusOperationLabels.add("ECCENTRICITY");
                this.censusOperationLabels.add("DENSITY");
                this.censusOperationLabels.add("DENSITY_NOLOOPS");
                this.censusOperationLabels.add("MEANDEGREE");
                this.censusOperationLabels.add("MEANDEGREE_NOLOOPS");
                this.censusOperationLabels.add("MEANDEGREE_NOLOOPS_NORM");
                this.censusOperationLabels.add("NRCOMPONENTS");
                this.censusOperationLabels.add("NRISOLATES");
                this.censusOperationLabels.add("MAXCOMPONENT");
                this.censusOperationLabels.add("NRCOMPONENTS_NORM");
                this.censusOperationLabels.add("NRISOLATES_NORM");
                this.censusOperationLabels.add("MAXCOMPONENT_NORM");
                this.censusOperationLabels.add("CONCENTRATION");
                this.censusOperationLabels.add("BROKERAGE");
                this.censusOperationLabels.add("EFFICIENT_SIZE");
                this.censusOperationLabels.add("EFFICIENCY");
                this.censusOperationLabels.add("NETWORK_RELATIONS");
                this.censusOperationLabels.add("CONNECTED_NETWORK_RELATIONS");
                this.censusOperationLabels.add("CENTRAL_ALTERS");
                this.censusOperationLabels.add("CENTRAL_RELATIONS");
                this.censusOperationLabels.add("SDENSITY_PARENT-CHILD");
                this.censusOperationLabels.add("SDENSITY_SPOUSE");
                this.censusOperationLabels.add("SDENSITY_SIBLING");
                this.censusOperationLabels.add("SDENSITY_RELATIVE");
                this.censusOperationLabels.add("SDENSITY_AFFINE");
                this.censusOperationLabels.add("SDENSITY_EMPLOYMENT");
                this.censusOperationLabels.add("SDENSITY_RENT");
                break;
            }
            case PARCOURSNETWORKS: {
                this.censusOperationLabels.add("NREVENTS");
                this.censusOperationLabels.add("NREXTERNALMOVES");
                for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
                    this.censusOperationLabels.add("SIZE_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("TIES_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("EGO-BETWEENNESS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MEAN_BETWEENNESS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MAX_BETWEENNESS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("ECCENTRICITY_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("DENSITY_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("DENSITY_NOLOOPS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MEANDEGREE_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MEANDEGREE_NOLOOPS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MEANDEGREE_NOLOOPS_NORM_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("NRCOMPONENTS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("NRISOLATES_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MAXCOMPONENT_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("NRCOMPONENTS_NORM_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("NRISOLATES_NORM_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MAXCOMPONENT_NORM_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("CONCENTRATION_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("BROKERAGE_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("EFFICIENT_SIZE_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("EFFICIENCY_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("NETWORK_RELATIONS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("CONNECTED_NETWORK_RELATIONS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("SIMILARITY_" + (Object)((Object)mainEventType));
                }
                break;
            }
            case PARCOURS: {
                this.censusOperationLabels.add("NREVENTS");
                this.censusOperationLabels.add("NREXTERNALMOVES");
                for (RelationClassificationType relationClassificationType : this.mainRelationClassificationTypes) {
                    this.censusOperationLabels.add("PROFILE_" + (Object)((Object)relationClassificationType));
                    this.censusOperationLabels.add("SUPPORT_" + (Object)((Object)relationClassificationType));
                    if (relationClassificationType != RelationClassificationType.PLACE) continue;
                    this.censusOperationLabels.add("CENTERS_" + (Object)((Object)relationClassificationType));
                    this.censusOperationLabels.add("NRINTERNALMOVES_" + (Object)((Object)relationClassificationType));
                    this.censusOperationLabels.add("NRDIRECTRETURNS_" + (Object)((Object)relationClassificationType));
                    this.censusOperationLabels.add("NRCYCLES_" + (Object)((Object)relationClassificationType));
                    this.censusOperationLabels.add("NRDIRECTRETURNS_NORM_" + (Object)((Object)relationClassificationType));
                    this.censusOperationLabels.add("NRCYCLES_NORM_" + (Object)((Object)relationClassificationType));
                }
                break;
            }
        }
    }

    public void addNetworkTitle(String networkTitle) {
        this.networkTitles.add(networkTitle);
        this.partitionLabels.put(networkTitle, new ArrayList());
    }

    public String getAlterFilterAttributeLabel() {
        return this.alterFilterAttributeLabel;
    }

    public String getAlterFilterAttributeValue() {
        return this.alterFilterAttributeValue;
    }

    public String getAlterFilterRoleName() {
        return this.alterFilterRoleName;
    }

    public List<String> getCensusOperationLabels() {
        return this.censusOperationLabels;
    }

    public CensusType getCensusType() {
        return this.censusType;
    }

    public String getChainClassification() {
        return this.chainClassification;
    }

    public String getDateLabel() {
        return this.dateLabel;
    }

    public Integer[] getDates() {
        return this.dates;
    }

    public String getDefaultReferentRoleName() {
        return this.defaultReferentRoleName;
    }

    public List<EgoNetworksOperation> getEgoNetworksOperations() {
        return this.egoNetworksOperations;
    }

    public String getEgoRoleName() {
        return this.egoRoleName;
    }

    public String getEndDateLabel() {
        return this.endDateLabel;
    }

    public String getEndPlaceLabel() {
        return this.endPlaceLabel;
    }

    public List<RelationClassificationType> getEventTypes() {
        return this.relationClassificationTypes;
    }

    public ExpansionMode getExpansionMode() {
        return this.expansionMode;
    }

    public FiliationType getFiliationType() {
        return this.filiationType;
    }

    public Geography getGeography() {
        return this.geography;
    }

    public GeoLevel getLevel() {
        return this.level;
    }

    public String getLocalUnitLabel() {
        return this.localUnitLabel;
    }

    public List<RelationClassificationType> getMainRelationClassificationTypes() {
        return this.mainRelationClassificationTypes;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public int getMinAge() {
        return this.minAge;
    }

    public StringList getMinimalPlaceNames() {
        return this.minimalPlaceNames;
    }

    public List<String> getNetworkTitles() {
        return this.networkTitles;
    }

    public List<ParcoursNetworksOperation> getParcoursNetworksOperations() {
        return this.parcoursNetworkdsOperations;
    }

    public List<ParcoursIntersectionNetworksOperation> getParcoursIntersectionNetworksOperations() {
        return this.parcoursIntersectionNetworksOperations;
    }

    public List<ParcoursSimilarityNetworksOperation> getParcoursSimilarityNetworksOperations() {
        return this.parcoursSimilarityNetworksOperations;
    }

    public String getPartitionLabel() {
        return this.individualClassificationType;
    }

    public Map<String, List<String>> getPartitionLabels() {
        return this.partitionLabels;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getPlaceLabel() {
        return this.placeLabel;
    }

    public List<RelationClassificationType> getRelationClassificationTypes() {
        return this.relationClassificationTypes;
    }

    public String getRelationModelName() {
        return this.relationModelName;
    }

    public List<String> getRelationModelNames() {
        return this.relationModelNames;
    }

    public StringList getRoleNames() {
        return this.roleNames;
    }

    public List<SequenceGeneralStatistics> getSequenceGeneralStatistics() {
        return this.sequenceGeneralStatistics;
    }

    public List<SequenceReportType> getSequenceReportTypes() {
        return this.sequenceReportTypes;
    }

    public List<SliceGeneralStatistics> getSliceGeneralStatistics() {
        return this.sliceGeneralStatistics;
    }

    public List<SliceReportType> getSliceReportTypes() {
        return this.sliceReportTypes;
    }

    public String getStartDateLabel() {
        return this.startDateLabel;
    }

    public String getStartPlaceLabel() {
        return this.startPlaceLabel;
    }

    public List<TrajectoriesOperation> getTrajectoriesOperations() {
        return this.trajectoriesOperations;
    }

    public List<RelationClassificationType> getTrajectoriesRelationClassificationTypes() {
        return this.trajectoriesRelationClassificationTypes;
    }

    public List<RelationClassificationType> getTypes() {
        return this.relationClassificationTypes;
    }

    public boolean isSequenceAnalysis() {
        boolean result = this.dates.length == 0 && StringUtils.isBlank((CharSequence)this.localUnitLabel);
        return result;
    }

    public void setAlterAttributeLabel(String alterAttributeLabel) {
        this.alterFilterAttributeLabel = alterAttributeLabel;
    }

    public void setAlterAttributeValue(String alterAttributeValue) {
        this.alterFilterAttributeValue = alterAttributeValue;
    }

    public void setAlterFilterRoleName(String alterFilterRoleName) {
        this.alterFilterRoleName = alterFilterRoleName;
    }

    public void setCensusType(CensusType censusType) {
        this.censusType = censusType;
    }

    public void setChainClassification(String chainClassification) {
        this.chainClassification = chainClassification;
    }

    public void setDateLabel(String dateLabel) {
        this.dateLabel = dateLabel;
    }

    public void setDates(Integer[] dates) {
        this.dates = dates;
    }

    private void setDefaultCriteria() {
        this.dateLabel = "DATE";
        this.startDateLabel = "START_DATE";
        this.endDateLabel = "END_DATE";
        this.placeLabel = "PLACE";
        this.startPlaceLabel = "START_PLACE";
        this.endPlaceLabel = "END_PLACE";
        this.alterFilterRoleName = "ALL";
        this.roleNames = new StringList();
        this.roleNames.add((Object)"ALL");
        this.defaultReferentRoleName = "HOST";
        this.minAge = 0;
        this.maxAge = 1000;
        this.relationModelNames = new ArrayList<String>();
        this.relationClassificationTypes = new ArrayList<RelationClassificationType>();
        this.mainRelationClassificationTypes = new ArrayList<RelationClassificationType>();
        for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
            if (this.relationClassificationTypes.contains((Object)mainEventType)) continue;
            this.relationClassificationTypes.add(mainEventType);
        }
        this.geography = Geography.getInstance();
        this.level = GeoLevel.TOWN;
        this.minimalPlaceNames = this.censusType == CensusType.GENERAL ? new StringList(Arrays.asList("Afagnan", "Lom\ufffd", "Bas-Mono", "Togo", "B\ufffdnin", "Ghana", "Nig\ufffdria", "C\ufffdte d'Ivoire", "Afrique")) : new StringList();
        this.pattern = "4 1";
        this.chainClassification = "LINE";
        this.individualClassificationType = "GENDER";
        this.networkTitles = new ArrayList<String>();
        this.partitionLabels = new HashMap<String, List<String>>();
        for (String networkTitle : this.networkTitles) {
            this.partitionLabels.put(networkTitle, new ArrayList());
        }
        this.censusOperationLabels = new ArrayList<String>();
        this.expansionMode = ExpansionMode.RELATED;
        this.filiationType = FiliationType.COGNATIC;
    }

    public void setDefaultReferentRoleName(String defaultReferentRoleName) {
        this.defaultReferentRoleName = defaultReferentRoleName;
    }

    public void setEgoRoleName(String egoRoleName) {
        this.egoRoleName = egoRoleName;
    }

    public void setEndDateLabel(String endDateLabel) {
        this.endDateLabel = endDateLabel;
    }

    public void setEndPlaceLabel(String endPlaceLabel) {
        this.endPlaceLabel = endPlaceLabel;
    }

    public void setEventTypes(List<RelationClassificationType> relationClassificationTypes) {
        this.relationClassificationTypes = relationClassificationTypes;
    }

    public void setExpansionMode(ExpansionMode expansionMode) {
        this.expansionMode = expansionMode;
    }

    public void setFiliationType(FiliationType filiationType) {
        this.filiationType = filiationType;
    }

    public void setGeography(Geography geography) {
        this.geography = geography;
    }

    public void setLabels(List<String> labels) {
        this.censusOperationLabels = labels;
    }

    public void setLevel(GeoLevel level) {
        this.level = level;
    }

    public void setLocalUnitLabel(String constantAttributeFilterLabel) {
        this.localUnitLabel = constantAttributeFilterLabel;
    }

    public void setMainEventType(List<RelationClassificationType> mainEventTypes) {
        this.mainRelationClassificationTypes = mainEventTypes;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setMinAge(int minAge) {
        this.minAge = minAge;
    }

    public void setPartitionLabel(String partitionLabel) {
        this.individualClassificationType = partitionLabel;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setPlaceLabel(String placeLabel) {
        this.placeLabel = placeLabel;
    }

    public void setRelationClassificationTypes(List<RelationClassificationType> relationClassificationTypes) {
        this.relationClassificationTypes = relationClassificationTypes;
    }

    public void setRelationModelName(String relationModelName) {
        this.relationModelName = relationModelName;
    }

    public void setRelationModelNames(List<String> relationModelNames) {
        this.relationModelNames = relationModelNames;
    }

    public void setRoleNames(List<String> alterRoleNames) {
        this.roleNames = new StringList(alterRoleNames);
    }

    public void setStartDateLabel(String startDateLabel) {
        this.startDateLabel = startDateLabel;
    }

    public void setStartPlaceLabel(String startPlaceLabel) {
        this.startPlaceLabel = startPlaceLabel;
    }

    public void setTypes(List<RelationClassificationType> types) {
        this.relationClassificationTypes = types;
    }

    public List<String> getNodeStatisticsLabels() {
        return this.nodeStatisticsLabels;
    }

    public String getGroupAffiliationLabel() {
        return this.groupAffiliationLabel;
    }

    public void setGroupAffiliationLabel(String groupAffiliationLabel) {
        this.groupAffiliationLabel = groupAffiliationLabel;
    }

    public static enum CensusType {
        GENERAL,
        EGONETWORKS,
        PARCOURSNETWORKS,
        PARCOURSSIMILARITYNETWORKS,
        PARCOURSINTERSECTIONNETWORKS,
        PARCOURS;


        public String toString() {
            String result;
            switch (this) {
                case GENERAL: {
                    result = "General";
                    break;
                }
                case EGONETWORKS: {
                    result = "Ego Networks";
                    break;
                }
                case PARCOURSNETWORKS: {
                    result = "Parcours Networks";
                    break;
                }
                case PARCOURSINTERSECTIONNETWORKS: {
                    result = "Parcours Intersection Networks";
                    break;
                }
                case PARCOURSSIMILARITYNETWORKS: {
                    result = "Parcours Similarity Networks";
                    break;
                }
                case PARCOURS: {
                    result = "Parcours";
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }
    }

    public static enum EgoNetworksOperation {
        GENERAL,
        CENTRALITY,
        COHESION,
        RELATIONS,
        EXPORT_EGO_NETWORKS;

    }

    public static enum ParcoursIntersectionNetworksOperation {
        GENERAL,
        CENTRALITY,
        COHESION,
        RELATIONS,
        EXPORT_PARCOURS_INTERSECTION_NETWORKS,
        EXPORT_SIMILARY_TREES;

    }

    public static enum ParcoursNetworksOperation {
        GENERAL,
        CENTRALITY,
        COHESION,
        RELATIONS,
        EXPORT_PARCOURS,
        EXPORT_EXTENDED_PARCOURS,
        EXPORT_MULTIPLE_PARCOURS,
        EXPORT_PARCOURS_NETWORKS,
        EXPORT_SIMILARY_TREES;

    }

    public static enum ParcoursSimilarityNetworksOperation {
        GENERAL,
        CENTRALITY,
        COHESION,
        RELATIONS,
        EXPORT_PARCOURS_SIMILARITY_NETWORKS,
        EXPORT_SIMILARY_TREES;

    }

    public static enum RelationClassificationType {
        TYPEDID,
        HOST,
        MIG,
        HOSTMIG,
        MIGRATIONTYPE,
        CHILDMIGRATIONTYPE,
        TREES,
        DISTANCE,
        PLACE,
        REGION,
        MOVEMENT,
        TURNOVER,
        COMPONENTS,
        DATE,
        AGE;

    }

    public static enum SequenceGeneralStatistics {
        EVENTS,
        AGE,
        RELATIONS;

    }

    public static enum SequenceReportType {
        ITINERARIES_SURVEY,
        ITINERARIES_DETAILS,
        BIOGRAPHIES,
        EXTENDED_BIOGRAPHIES,
        ACTOR_EVENT_TABLES,
        INTERACTION_TABLES,
        EXPORT_RELATION_GRAPH;

    }

    public static enum SliceGeneralStatistics {
        STATICS,
        DYNAMICS;

    }

    public static enum SliceReportType {
        MEMBERSHIP;

    }

    public static enum TrajectoriesOperation {
        GENERAL,
        LIST_TREES,
        EXPORT_EVENT_TYPE_NETWORK,
        EXPORT_SEQUENCE_TYPE_NETWORK,
        DRAW;

    }
}

