/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.workers.RelationWorker;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Partition;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.House;
import org.tip.puck.spacetime.Houses;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class HouseStatistics {
    Houses houses;
    Integer[] dates;
    Map<House, Map<Ordinal, Map<String, Object>>> valuesByHouses;
    Map<Individual, Map<Ordinal, Map<String, Object>>> valuesByIndividuals;
    Map<Individual, Map<Ordinal, Relation>> relationsByIndividuals;
    String pattern;
    String affiliationLabel;
    String localUnitLabel;
    List<String> indicators;
    String dateLabel;
    String placeLabel;
    String relationModelName;
    String startDateLabel;
    String endDateLabel;
    String egoRoleName;

    public HouseStatistics(Houses houses, SpaceTimeCriteria criteria, List<String> indicators) {
        this.houses = houses;
        this.dates = criteria.getDates();
        this.pattern = criteria.getPattern();
        this.affiliationLabel = criteria.getGroupAffiliationLabel();
        this.localUnitLabel = criteria.getLocalUnitLabel();
        this.valuesByHouses = new TreeMap<House, Map<Ordinal, Map<String, Object>>>();
        this.valuesByIndividuals = new TreeMap<Individual, Map<Ordinal, Map<String, Object>>>();
        this.relationsByIndividuals = new TreeMap<Individual, Map<Ordinal, Relation>>();
        this.indicators = indicators;
        this.dateLabel = criteria.getDateLabel();
        this.placeLabel = criteria.getPlaceLabel();
        this.relationModelName = criteria.getRelationModelName();
        this.startDateLabel = criteria.getStartDateLabel();
        this.endDateLabel = criteria.getEndDateLabel();
        this.egoRoleName = criteria.getEgoRoleName();
        for (House house : houses.toSortedList()) {
            TreeMap houseValues = new TreeMap();
            this.valuesByHouses.put(house, houseValues);
            Integer[] integerArray = this.dates;
            int n = this.dates.length;
            int n2 = 0;
            while (n2 < n) {
                Integer year = integerArray[n2];
                Ordinal time = new Ordinal(year);
                houseValues.put(time, new HashMap());
                ++n2;
            }
        }
    }

    public void getStatistics() {
        for (House house : this.houses.toSortedList()) {
            Map<Ordinal, Map<String, Object>> houseValues = this.valuesByHouses.get(house);
            Integer[] integerArray = this.dates;
            int n = this.dates.length;
            int n2 = 0;
            while (n2 < n) {
                Integer year = integerArray[n2];
                Ordinal time = new Ordinal(year);
                Relation relation = house.getByOrdinal(time);
                houseValues.get(time).putAll(RelationWorker.getStatistics(relation, this.indicators, this.pattern));
                ++n2;
            }
        }
    }

    public void getMemberValues() {
        int n;
        Map<Object, Object> memberRelations;
        Map<Object, Object> memberValues;
        for (Individual member : this.houses.getMembers().toSortedList()) {
            memberValues = new TreeMap();
            memberRelations = new TreeMap();
            this.relationsByIndividuals.put(member, memberRelations);
            this.valuesByIndividuals.put(member, memberValues);
            Ordinal previousTime = null;
            Integer[] integerArray = this.dates;
            int n2 = this.dates.length;
            n = 0;
            while (n < n2) {
                Relation previousRelation;
                Integer year = integerArray[n];
                Ordinal time = new Ordinal(year);
                memberValues.put(time, new HashMap());
                Relation relation = (Relation)member.relations().getByModelName(this.relationModelName).getByTime(this.dateLabel, year).getFirst();
                memberRelations.put(time, relation);
                if (relation != null && previousTime != null && memberRelations.get(previousTime) == null && (previousRelation = (Relation)member.relations().getByModelName(this.relationModelName).getPredecessors(relation, member, this.egoRoleName, this.dateLabel, this.startDateLabel, this.endDateLabel, previousTime.getYear()).getFirst()) != null) {
                    memberRelations.put(previousTime, previousRelation);
                }
                previousTime = time;
                ++n;
            }
        }
        for (Individual member : this.houses.getMembers().toSortedList()) {
            memberValues = this.valuesByIndividuals.get(member);
            memberRelations = this.relationsByIndividuals.get(member);
            Integer[] integerArray = this.dates;
            n = this.dates.length;
            int n3 = 0;
            while (n3 < n) {
                Integer year = integerArray[n3];
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                String lifeStatus = IndividualValuator.lifeStatusAtYear(member, year);
                Ordinal time = new Ordinal(year);
                Relation relation = (Relation)memberRelations.get(time);
                if (relation == null) {
                    if (year.toString().equals(member.getAttributeValue("BIRT_DATE"))) {
                        lifeStatus = "UNBORN";
                    } else if (year.toString().equals(member.getAttributeValue("DEAT_DATE"))) {
                        lifeStatus = "DEAD";
                    }
                }
                for (String indicator : this.indicators) {
                    if (lifeStatus.equals("DEAD") || lifeStatus.equals("UNBORN")) {
                        valueMap.put(indicator, lifeStatus);
                        continue;
                    }
                    if (relation == null) continue;
                    if (indicator.equals("PLACE")) {
                        String placeValue = relation.getAttributeValue(this.localUnitLabel);
                        if (placeValue == null) {
                            placeValue = relation.getAttributeValue(this.placeLabel);
                        }
                        valueMap.put(indicator, placeValue);
                        continue;
                    }
                    Actor actor = relation.getActor(member, this.egoRoleName);
                    if (indicator.equals("REFERENT")) {
                        valueMap.put(indicator, actor.getReferent());
                        continue;
                    }
                    if (indicator.equals("REFERENT_KIN")) {
                        valueMap.put(indicator, RelationWorker.getReferentRole(actor, this.pattern, this.affiliationLabel, relation));
                        continue;
                    }
                    if (!indicator.equals("REFERENT_CHAIN")) continue;
                    valueMap.put(indicator, RelationWorker.getReferentChain(actor, this.affiliationLabel, relation));
                }
                memberValues.put(time, valueMap);
                ++n3;
            }
        }
    }

    public void getReferentKinCensus() {
        for (House house : this.houses.toSortedList()) {
            Map<Ordinal, Map<String, Object>> houseValues = this.valuesByHouses.get(house);
            Integer[] integerArray = this.dates;
            int n = this.dates.length;
            int n2 = 0;
            while (n2 < n) {
                Integer year = integerArray[n2];
                Ordinal time = new Ordinal(year);
                Relation relation = house.getByOrdinal(time);
                houseValues.get(time).putAll(RelationWorker.getReferentKinCensus(relation, this.pattern, this.affiliationLabel));
                for (String indicator : this.indicators) {
                    if (houseValues.get(time).containsKey(indicator)) continue;
                    houseValues.get(time).put(indicator, 0.0);
                }
                ++n2;
            }
        }
    }

    public void getReferentChainCensus() {
        for (House house : this.houses.toSortedList()) {
            Map<Ordinal, Map<String, Object>> houseValues = this.valuesByHouses.get(house);
            Integer[] integerArray = this.dates;
            int n = this.dates.length;
            int n2 = 0;
            while (n2 < n) {
                Integer year = integerArray[n2];
                Ordinal time = new Ordinal(year);
                Relation relation = house.getByOrdinal(time);
                houseValues.get(time).putAll(RelationWorker.getReferentChainCensus(relation, this.affiliationLabel));
                for (String indicator : houseValues.get(time).keySet()) {
                    if (this.indicators.contains(indicator)) continue;
                    this.indicators.add(indicator);
                }
                ++n2;
            }
        }
    }

    public void getAllKinCensus(Segmentation segmentation, CensusCriteria censusCriteria) {
        for (House house : this.houses.toSortedList()) {
            Map<Ordinal, Map<String, Object>> houseValues = this.valuesByHouses.get(house);
            Integer[] integerArray = this.dates;
            int n = this.dates.length;
            int n2 = 0;
            while (n2 < n) {
                Integer year = integerArray[n2];
                Ordinal time = new Ordinal(year);
                Relation relation = house.getByOrdinal(time);
                houseValues.get(time).putAll(RelationWorker.getAllKinCensus(segmentation, relation, this.pattern, censusCriteria));
                for (String indicator : houseValues.get(time).keySet()) {
                    if (this.indicators.contains(indicator)) continue;
                    this.indicators.add(indicator);
                }
                ++n2;
            }
        }
    }

    public void put(House house, Ordinal time, String indicator, Object value) {
        Map<String, Object> relationValues;
        Map<Ordinal, Map<String, Object>> houseValues = this.valuesByHouses.get(house);
        if (houseValues != null && (relationValues = houseValues.get(time)) != null) {
            relationValues.put(indicator, value);
        }
    }

    private Actors getNewActors(Relation alpha, Relation beta) {
        Actors result = new Actors();
        if (alpha != null) {
            if (beta == null) {
                result.addAll(alpha.actors());
            } else {
                for (Actor actor : alpha.actors()) {
                    if (beta.actors().contains(actor)) continue;
                    result.add(actor);
                }
            }
        }
        return result;
    }

    public Partition<String> getFlows(String direction) {
        Partition<String> result = new Partition<String>();
        int[] maxDegrees = ToolBox.stringsToInts(this.pattern);
        Ordinal former = null;
        Integer[] integerArray = this.dates;
        int n = this.dates.length;
        int n2 = 0;
        while (n2 < n) {
            Integer year = integerArray[n2];
            Ordinal later = new Ordinal(year);
            if (former != null) {
                Ordinal current = null;
                if (direction.equals("OUT")) {
                    current = former;
                } else if (direction.equals("IN")) {
                    current = later;
                }
                for (House house : this.houses) {
                    Relation formerRelation = house.getByOrdinal(former);
                    Relation laterRelation = house.getByOrdinal(later);
                    Relation currentRelation = house.getByOrdinal(current);
                    Actors migrants = null;
                    if (direction.equals("OUT")) {
                        migrants = this.getNewActors(currentRelation, laterRelation);
                    } else if (direction.equals("IN")) {
                        migrants = this.getNewActors(currentRelation, formerRelation);
                    }
                    for (Actor actor : migrants) {
                        Individual referent = actor.getReferent();
                        String link = "UNKNOWN";
                        if (referent != null) {
                            link = NetUtils.getAlterRole(actor.getIndividual(), referent, maxDegrees, null);
                        }
                        Individual otherReferent = null;
                        Actor otherActor = RelationWorker.getClosestHomologue(currentRelation, actor, current.getYear(), this.dateLabel, direction);
                        if (otherActor != null) {
                            otherReferent = otherActor.getReferent();
                        } else {
                            System.err.println("Missing homologue " + actor + " " + direction + " " + year);
                        }
                        String otherLink = "UNKNOWN";
                        if (otherReferent != null) {
                            otherLink = NetUtils.getAlterRole(actor.getIndividual(), otherReferent, maxDegrees, null);
                        }
                        String change = null;
                        if (referent != null && referent.equals(otherReferent)) {
                            change = "IDENTICAL";
                        } else if (direction.equals("OUT")) {
                            change = String.valueOf(link) + ">" + otherLink;
                        } else if (direction.equals("IN")) {
                            change = String.valueOf(otherLink) + ">" + link;
                        }
                        result.put(house + "\t" + former + "-" + later + "\t" + direction + "\t" + actor.getIndividual() + "\t" + referent + "\t" + otherReferent, new Value(change));
                    }
                }
            }
            former = later;
            ++n2;
        }
        return result;
    }

    public Object get(House house, Ordinal time, String indicator) {
        Map<String, Object> relationValues;
        Object result = null;
        Map<Ordinal, Map<String, Object>> houseValues = this.valuesByHouses.get(house);
        if (houseValues != null && (relationValues = houseValues.get(time)) != null) {
            result = relationValues.get(indicator);
        }
        return result;
    }

    public Object getByMember(Individual member, Ordinal time, String indicator) {
        Map<String, Object> relationValues;
        Object result = null;
        Map<Ordinal, Map<String, Object>> memberValues = this.valuesByIndividuals.get(member);
        if (memberValues != null && (relationValues = memberValues.get(time)) != null) {
            result = relationValues.get(indicator);
        }
        return result;
    }

    public String getTrend(House house, String indicator) {
        String result = null;
        Object lastValue = null;
        Integer[] integerArray = this.dates;
        int n = this.dates.length;
        int n2 = 0;
        while (n2 < n) {
            Integer year = integerArray[n2];
            Object value = this.get(house, new Ordinal(year), indicator);
            if (lastValue != null) {
                if (!(lastValue instanceof Number)) break;
                int comp = ((Comparable)value).compareTo(lastValue);
                String trend = null;
                if (comp < 0) {
                    trend = "DECLINING";
                } else if (comp > 0) {
                    trend = "AUGMENTING";
                } else if (comp == 0) {
                    trend = "CONSTANT";
                }
                if (result == null || result.equals("CONSTANT")) {
                    result = trend;
                } else if (!trend.equals("CONSTANT") && !trend.equals(result)) {
                    result = "VARIABLE";
                    break;
                }
            }
            lastValue = value;
            ++n2;
        }
        return result;
    }

    public Double getMean(Ordinal time, String indicator) {
        Double result = null;
        Double sum = 0.0;
        for (House house : this.houses) {
            Object value = this.get(house, time, indicator);
            if (value instanceof Number) {
                sum = sum + ((Number)value).doubleValue();
                continue;
            }
            result = null;
            break;
        }
        result = sum / new Double(this.houses.size());
        return result;
    }

    public String getMeanTrend(String indicator) {
        String result = "";
        HashMap<String, Double> trendCounts = new HashMap<String, Double>();
        for (House house : this.houses) {
            String trend = this.getTrend(house, indicator);
            Double count = (Double)trendCounts.get(trend);
            if (count == null) {
                trendCounts.put(trend, 1.0);
                continue;
            }
            trendCounts.put(trend, count + 1.0);
        }
        for (String trend : trendCounts.keySet()) {
            trendCounts.put(trend, MathUtils.percent((Double)trendCounts.get(trend), new Double(this.houses.size())));
        }
        ArrayList sortedEntries = new ArrayList(trendCounts.entrySet());
        Collections.sort(sortedEntries, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> e1, Map.Entry<String, Double> e2) {
                return e2.getValue().compareTo(e1.getValue());
            }
        });
        for (Map.Entry entry : sortedEntries) {
            result = String.valueOf(result) + (String)entry.getKey() + " " + entry.getValue() + " ";
        }
        return result;
    }

    public List<String> indicators() {
        return this.indicators;
    }
}

