/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.report;

import fr.devinsy.util.StringList;
import org.tip.puck.report.DataLines;
import org.tip.puck.report.HeaderLine;
import org.tip.puck.report.ReportTable;
import org.tip.puck.util.MathUtils;

public class ReportChart {
    private String title;
    private GraphType type;
    private HeaderLine headerLine;
    private DataLines dataLines;
    private LogarithmType logarithmType;
    private Double verticalMax;
    private boolean integerHorizontalUnit;

    public ReportChart(GraphType type) {
        this.title = null;
        this.type = type;
        this.headerLine = new HeaderLine();
        this.dataLines = new DataLines();
        this.logarithmType = LogarithmType.NONE;
        this.integerHorizontalUnit = false;
    }

    public ReportChart(String title, GraphType type) {
        this.title = title;
        this.type = type;
        this.headerLine = new HeaderLine();
        this.dataLines = new DataLines();
        this.logarithmType = LogarithmType.NONE;
        this.integerHorizontalUnit = false;
    }

    public void addValue(double x, double y, int rowIndex) {
        this.dataLines.getLine(rowIndex).addValue(x, y);
    }

    public void addValue(double value, int rowIndex) {
        this.dataLines.getLine(rowIndex).addValue(value);
    }

    public void addValue(Double x, Double y, int rowIndex) {
        this.dataLines.getLine(rowIndex).addValue(x, y);
    }

    public ReportTable createReportTable() {
        int columnIndex;
        ReportTable result = new ReportTable(this.getRowCount() + 1, this.getColumnCount() + 1);
        result.setTitle(this.title);
        if (this.headerLine.getHeaders().isEmpty()) {
            if (this.getRowCount() > 0) {
                columnIndex = 0;
                while (columnIndex < this.getColumnCount()) {
                    Double headerValue = this.getXValue(0, columnIndex);
                    if (headerValue == null) {
                        headerValue = columnIndex + 1;
                    }
                    result.set(0, columnIndex + 1, MathUtils.toString(headerValue));
                    ++columnIndex;
                }
            }
        } else {
            columnIndex = 0;
            while (columnIndex < this.headerLine.getHeaders().size()) {
                result.set(0, columnIndex + 1, this.headerLine.getHeader(columnIndex));
                ++columnIndex;
            }
        }
        int rowIndex = 0;
        while (rowIndex < this.getRowCount()) {
            result.set(rowIndex + 1, 0, this.getLineTitle(rowIndex));
            int columnIndex2 = 0;
            while (columnIndex2 < this.getColumnCount(rowIndex)) {
                result.set(rowIndex + 1, columnIndex2 + 1, MathUtils.toString(this.getYValue(rowIndex, columnIndex2)));
                ++columnIndex2;
            }
            ++rowIndex;
        }
        return result;
    }

    public ReportTable createReportTableWithSum() {
        int columnIndex;
        boolean rowSumEnable = this.getRowCount() > 1;
        boolean columnSumEnable = this.getColumnCount() > 1;
        int rowCount = this.getRowCount() + 1;
        if (rowSumEnable) {
            ++rowCount;
        }
        int columnCount = this.getColumnCount() + 1;
        if (columnSumEnable) {
            ++columnCount;
        }
        ReportTable result = new ReportTable(rowCount, columnCount);
        result.setTitle(this.title);
        if (this.headerLine.getHeaders().isEmpty()) {
            if (this.getRowCount() > 0) {
                columnIndex = 0;
                while (columnIndex < this.getColumnCount()) {
                    Double headerValue = this.getXValue(0, columnIndex);
                    if (headerValue == null) {
                        headerValue = columnIndex + 1;
                    }
                    result.set(0, columnIndex + 1, MathUtils.toString(headerValue));
                    ++columnIndex;
                }
            }
        } else {
            columnIndex = 0;
            while (columnIndex < this.headerLine.getHeaders().size()) {
                result.set(0, columnIndex + 1, this.headerLine.getHeader(columnIndex));
                ++columnIndex;
            }
        }
        double[] rowsSum = new double[result.getColumnCount()];
        int rowIndex = 0;
        while (rowIndex < this.getRowCount()) {
            result.set(rowIndex + 1, 0, this.getLineTitle(rowIndex));
            double columnSum = 0.0;
            int columnIndex2 = 0;
            while (columnIndex2 < this.getColumnCount(rowIndex)) {
                double value = this.getYValue(rowIndex, columnIndex2);
                result.set(rowIndex + 1, columnIndex2 + 1, MathUtils.toString(value));
                columnSum += value;
                int n = columnIndex2++;
                rowsSum[n] = rowsSum[n] + value;
            }
            if (columnSumEnable) {
                result.set(0, this.getColumnCount() + 1, "Total");
                result.set(rowIndex + 1, result.getColumnCount() - 1, MathUtils.toString(columnSum));
            }
            ++rowIndex;
        }
        if (rowSumEnable) {
            double totalSum = 0.0;
            int columnIndex3 = 0;
            while (columnIndex3 < this.getColumnCount()) {
                result.set(result.getRowCount() - 1, columnIndex3 + 1, MathUtils.toString(rowsSum[columnIndex3]));
                totalSum += rowsSum[columnIndex3];
                ++columnIndex3;
            }
            result.set(result.getRowCount() - 1, 0, "Total");
            if (columnSumEnable) {
                result.set(result.getRowCount() - 1, this.getColumnCount() + 1, MathUtils.toString(totalSum));
            }
        }
        return result;
    }

    public int getColumnCount() {
        int result = this.dataLines.getMaxSize();
        return result;
    }

    public int getColumnCount(int rowIndex) {
        int result = this.dataLines.getLine(rowIndex).size();
        return result;
    }

    public String getHeader(int columnIndex) {
        String result = this.headerLine.getHeader(columnIndex);
        return result;
    }

    public String getHeadersLegend() {
        String result = this.headerLine.getLegend();
        return result;
    }

    public String getLinesLegend() {
        String result = this.dataLines.getLegend();
        return result;
    }

    public String getLineTitle(int rowIndex) {
        String result = this.dataLines.getLine(rowIndex).getTitle();
        return result;
    }

    public LogarithmType getLogarithmType() {
        return this.logarithmType;
    }

    public int getRowCount() {
        int result = this.dataLines.getLineCount();
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public GraphType getType() {
        return this.type;
    }

    public Double getVerticalMax() {
        return this.verticalMax;
    }

    public Double getXValue(int rowIndex, int columnIndex) {
        Double result = this.dataLines.getLine(rowIndex).getXValue(columnIndex);
        return result;
    }

    public Double getYValue(int rowIndex, int columnIndex) {
        Double result = this.dataLines.getLine(rowIndex).getYValue(columnIndex);
        return result;
    }

    public boolean isIntegerHorizontalUnit() {
        return this.integerHorizontalUnit;
    }

    public void setHeader(String label, int columnIndex) {
        this.headerLine.setHeader(label, columnIndex);
    }

    public void setHeadersLegend(String label) {
        this.headerLine.setLegend(label);
    }

    public void setIntegerHorizontalUnit(boolean value) {
        this.integerHorizontalUnit = value;
    }

    public void setLinesLegend(String label) {
        this.dataLines.setLegend(label);
    }

    public void setLineTitle(String label, int rowIndex) {
        this.dataLines.getLine(rowIndex).setTitle(label);
    }

    public void setLogarithmType(LogarithmType logarithmType) {
        this.logarithmType = logarithmType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(GraphType type) {
        this.type = type;
    }

    public void setValue(double value, int rowIndex, int columnIndex) {
        this.dataLines.getLine(rowIndex).setYValue(value, columnIndex);
    }

    public void setValue(Double x, Double y, int rowIndex, int columnIndex) {
        this.dataLines.getLine(rowIndex).setXYValue(x, y, columnIndex);
    }

    public void setVerticalMax(Double verticalMax) {
        this.verticalMax = verticalMax;
    }

    public String toString() {
        StringList buffer = new StringList();
        buffer.appendln("Title=" + this.title);
        int rowIndex = 0;
        while (rowIndex < this.dataLines.getLineCount()) {
            buffer.append("  Line (");
            buffer.append(rowIndex);
            buffer.append(") ");
            buffer.append(this.dataLines.getLine(rowIndex).getTitle());
            buffer.append(" ");
            buffer.append(this.dataLines.getLine(rowIndex).size());
            buffer.appendln();
            ++rowIndex;
        }
        String result = buffer.toString();
        return result;
    }

    public static enum GraphType {
        STACKED_BARS,
        LINES,
        SCATTER,
        BAR_BOARD,
        SURFACE;

    }

    public static enum LogarithmType {
        NONE,
        VERTICAL,
        HORIZONTAL;

    }
}

