/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tip.puck.PuckException;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.workers.AddChildRolesCriteria;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.workers.SequenceCensus;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.ToolBox;

public class RelationWorker {
    public static void addChildRoles(Net net, AddChildRolesCriteria criteria) {
        if (net != null && criteria != null) {
            RelationModel model = net.relationModels().getByName(criteria.getRelationModelName());
            String egoRoleName = criteria.getEgoRoleName();
            StringList roleNames = criteria.getAlterRoleNames();
            int maxAge = criteria.getMaxAge();
            String dateLabel = criteria.getDateLabel();
            if (model != null) {
                model.roles().add(new Role(String.valueOf(egoRoleName) + "_CHILD", 0));
                Relations relations = net.relations().getByModel(model);
                for (Relation event : relations) {
                    Integer eventYear;
                    if (SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event) || (eventYear = IndividualValuator.extractYearAsInt(event.getAttributeValue(dateLabel))) == null) continue;
                    for (Actor actor : event.actors().toList()) {
                        Individual ego;
                        int age;
                        if (!actor.getRole().getName().equals(egoRoleName) || (age = IndividualValuator.ageAtYear(ego = actor.getIndividual(), eventYear).intValue()) <= -1 || age >= maxAge || !event.getRoleNames(ego).contains(egoRoleName) || SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event)) continue;
                        for (String alterRoleName : roleNames) {
                            if (event.getIndividuals(alterRoleName).contains(ego.getFather()) || event.getIndividuals(alterRoleName).contains(ego.getMother())) continue;
                            event.actors().add(new Actor(ego, new Role(String.valueOf(egoRoleName) + "_CHILD")));
                        }
                    }
                }
            }
        }
    }

    private static Set<List<String>> getLinkChains(List<String> ancestorList, Actor referent, Actors ascendants, Relation relation, String treeType, int[] maxDegrees) {
        HashSet<List<String>> result = new HashSet<List<String>>();
        Actors dependants = relation.getDependants(referent);
        ascendants.add(referent);
        if (dependants.size() > 0) {
            for (Actor descendant : dependants) {
                if (ascendants.contains(descendant)) {
                    System.err.println("Cyclic referent structure : " + referent + " for " + descendant + " " + referent + " in " + relation);
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(ancestorList);
                Individual individual = descendant.getIndividual();
                if (treeType.equals("GENDER")) {
                    list.add(String.valueOf(individual.getGender().toChar()));
                } else if (treeType.equals("ID")) {
                    list.add(String.valueOf(individual.getId()));
                } else if (treeType.equals("KIN")) {
                    list.add(String.valueOf(individual.getGender().toChar()));
                }
                for (List<String> chain : RelationWorker.getLinkChains(list, descendant, ascendants, relation, treeType, maxDegrees)) {
                    result.add(chain);
                }
            }
        } else {
            result.add(ancestorList);
        }
        return result;
    }

    public static Set<List<String>> getLinkChains(Relation relation, String treeType, String pattern) {
        HashSet<List<String>> result = new HashSet<List<String>>();
        int[] maxDegrees = ToolBox.stringsToInts(pattern);
        for (Actor actor : relation.actors()) {
            Individual referent = actor.getReferent();
            if (referent != null) continue;
            ArrayList<String> ancestorList = new ArrayList<String>();
            Individual individual = actor.getIndividual();
            if (treeType.equals("GENDER")) {
                ancestorList.add(String.valueOf(individual.getGender().toChar()));
            } else if (treeType.equals("ID")) {
                ancestorList.add(String.valueOf(individual.getId()));
            } else if (treeType.equals("KIN")) {
                ancestorList.add(String.valueOf(individual.getGender().toChar()));
            }
            for (List<String> chain : RelationWorker.getLinkChains(ancestorList, actor, new Actors(), relation, treeType, maxDegrees)) {
                result.add(chain);
            }
        }
        return result;
    }

    public static String getLinkChainsAsString(Relation relation, String treeType, String pattern) {
        String result = "";
        Set<List<String>> chains = RelationWorker.getLinkChains(relation, treeType, pattern);
        ArrayList<String> chainsAsStrings = new ArrayList<String>();
        for (List<String> chain : chains) {
            chainsAsStrings.add(chain.toString());
        }
        Collections.sort(chainsAsStrings);
        result = ((Object)chainsAsStrings).toString();
        return result;
    }

    private static String getLinkTree(Actor referent, Individuals ascendants, Relation relation, boolean reduced, String treeType, int[] maxDegrees) {
        String result = "";
        Actors dependants = relation.getDependants(referent);
        ascendants.add(referent.getIndividual());
        if (dependants.size() > 0) {
            result = "[";
            ArrayList<String> list = new ArrayList<String>();
            for (Actor descendant : dependants.toSortedList()) {
                if (ascendants.contains(descendant.getIndividual())) {
                    System.err.println("Cyclic referent structure : " + referent + " for " + descendant + " " + referent + " in " + relation);
                    continue;
                }
                String item = RelationWorker.getLinkTree(descendant, ascendants, relation, reduced, treeType, maxDegrees);
                if (treeType.equals("GENDER")) {
                    item = String.valueOf(descendant.getIndividual().getGender().toChar()) + item;
                } else if (treeType.equals("ID")) {
                    item = String.valueOf(descendant.getIndividual().getId()) + " " + item;
                } else if (treeType.equals("KIN")) {
                    item = String.valueOf(NetUtils.getAlterRole(descendant.getIndividual(), referent.getIndividual(), maxDegrees, null)) + " " + item;
                }
                if (reduced && list.contains(item)) continue;
                list.add(item);
            }
            for (String item : list) {
                result = String.valueOf(result) + item;
            }
            result = String.valueOf(result) + "]";
        }
        return result;
    }

    public static String getLinkTrees(Relation relation, boolean reduced, String treeType, String pattern) {
        String result = "";
        int[] maxDegrees = ToolBox.stringsToInts(pattern);
        ArrayList<String> list = new ArrayList<String>();
        if (relation != null) {
            for (Actor actor : relation.actors().toSortedList()) {
                Individual individual = actor.getIndividual();
                Individual referent = actor.getReferent();
                if (referent != null) continue;
                String item = RelationWorker.getLinkTree(actor, new Individuals(), relation, reduced, treeType, maxDegrees);
                if (treeType.equals("GENDER")) {
                    item = String.valueOf(individual.getGender().toChar()) + item;
                } else if (treeType.equals("ID")) {
                    item = String.valueOf(individual.getId()) + " " + item;
                } else if (treeType.equals("KIN")) {
                    item = String.valueOf(individual.getGender().toChar()) + " " + item;
                }
                if (reduced && list.contains(item)) continue;
                list.add(item);
            }
        }
        for (String item : list) {
            result = String.valueOf(result) + item + " ";
        }
        return result;
    }

    public static Graph<Individual> getReferentGraph(Relation relation) {
        Graph<Individual> result = new Graph<Individual>();
        if (relation != null) {
            for (Actor actor : relation.actors()) {
                Individual ego = actor.getIndividual();
                Individual alter = actor.getReferent();
                if (ego != null && alter != null) {
                    result.addArc(ego, alter, 1.0);
                    continue;
                }
                if (ego == null) continue;
                result.addNode(ego);
            }
            result.setLabel(relation.getName());
        }
        return result;
    }

    public static Map<String, Object> getAllKinCensus(Segmentation segmentation, Relation relation, String pattern, CensusCriteria censusCriteria) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (relation != null) {
            Segmentation domain = new Segmentation(relation.getIndividuals(), segmentation.getAllFamilies(), segmentation.getAllRelations());
            try {
                CircuitFinder finder = new CircuitFinder(domain, censusCriteria);
                finder.findCircuits();
                for (Cluster<Chain> cluster : finder.getCircuits().getClusters()) {
                    result.put("" + cluster.getValue(), new Integer(cluster.size()));
                }
            }
            catch (PuckException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static Actor getClosestHomologue(Relation relation, Actor actor, Integer date, String dateLabel, String direction) {
        Actor result = null;
        if (relation != null && actor != null && date != null) {
            Relation closestRelation = null;
            Integer closestDate = null;
            for (Relation otherRelation : actor.getIndividual().relations().getByModel(relation.getModel())) {
                Integer otherDate;
                String dateString;
                if (otherRelation.equals(relation) || (dateString = otherRelation.getAttributeValue(dateLabel)) == null || (otherDate = Integer.valueOf(Integer.parseInt(dateString))) == null || (!direction.equals("OUT") || otherDate <= date || closestDate != null && otherDate >= closestDate) && (!direction.equals("IN") || otherDate >= date || closestDate != null && otherDate <= closestDate)) continue;
                closestRelation = otherRelation;
                closestDate = otherDate;
            }
            if (closestRelation != null) {
                result = closestRelation.actors().get(actor.getIndividual().getId(), actor.getRole());
            }
        }
        return result;
    }

    public static Map<String, Object> getReferentChainCensus(Relation relation, String affiliationLabel) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (relation != null) {
            for (Actor actor : relation.actors().toSortedList()) {
                String chain = RelationWorker.getReferentChain(actor, affiliationLabel, relation);
                Object count = result.get(chain);
                if (count == null) {
                    result.put(chain, 1.0);
                    continue;
                }
                result.put(chain, (Double)result.get(chain) + 1.0);
            }
        }
        return result;
    }

    public static String getReferentChain(Actor actor, String affiliationLabel, Relation relation) {
        Individual ego = actor.getIndividual();
        Individual alter = actor.getReferent();
        Individuals previous = new Individuals();
        previous.add(ego);
        String chain = "";
        if (alter == null) {
            String status = RelationWorker.getHouseStatus(ego, affiliationLabel, relation);
            if (status == null) {
                chain = "[]";
            } else if (status.equals("OWNER")) {
                chain = "-";
            } else if (status.equals("OWNER_SPOUSE")) {
                chain = "[H]";
            }
        }
        while (alter != null) {
            if (previous.contains(alter)) {
                System.err.println("Cyclic referent chain: " + previous);
                break;
            }
            chain = String.valueOf(chain) + alter.getGender().toChar();
            Actor alterActor = relation.actors().get(alter.getId(), actor.getRole());
            if (alterActor != null) {
                previous.add(alter);
                ego = alter;
                alter = alterActor.getReferent();
                if (alter != null) continue;
                String status = RelationWorker.getHouseStatus(ego, affiliationLabel, relation);
                if (status == null) {
                    chain = String.valueOf(chain) + "[]";
                    continue;
                }
                if (!status.equals("OWNER_SPOUSE")) continue;
                chain = String.valueOf(chain) + "[H]";
                continue;
            }
            System.err.println("Nonresident referent for " + relation + "\t" + alter);
            alter = null;
        }
        return chain;
    }

    private static String getHouseStatus(Individual ego, String affiliationLabel, Relation relation) {
        String egoAttributeValue = ego.getAttributeValue(affiliationLabel);
        String relationAttributeValue = relation.getAttributeValue(affiliationLabel);
        String result = null;
        if (egoAttributeValue != null && egoAttributeValue.equals(relationAttributeValue)) {
            result = "OWNER";
        } else {
            for (Individual spouse : ego.spouses()) {
                String spouseAttributeValue = spouse.getAttributeValue(affiliationLabel);
                if (spouseAttributeValue == null || !spouseAttributeValue.equals(relationAttributeValue)) continue;
                result = "OWNER_SPOUSE";
                break;
            }
        }
        return result;
    }

    public static String getReferentRole(Actor actor, String pattern, String affiliationLabel, Relation relation) {
        int[] maxDegrees = ToolBox.stringsToInts(pattern);
        Individual ego = actor.getIndividual();
        Individual alter = actor.getReferent();
        String result = "NONE";
        result = alter == null ? RelationWorker.getHouseStatus(ego, affiliationLabel, relation) : NetUtils.getAlterRole(ego, alter, maxDegrees, null);
        return result;
    }

    public static Map<String, Object> getReferentKinCensus(Relation relation, String pattern, String affiliationLabel) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (relation != null) {
            for (Actor actor : relation.actors().toSortedList()) {
                String alterRole = RelationWorker.getReferentRole(actor, pattern, affiliationLabel, relation);
                Object count = result.get(alterRole);
                if (count == null) {
                    result.put(alterRole, 1.0);
                    continue;
                }
                result.put(alterRole, (Double)count + 1.0);
            }
            for (String key : result.keySet()) {
                result.put(key, MathUtils.percent((Double)result.get(key), (double)relation.actors().size()));
            }
        }
        return result;
    }

    public static Map<String, Object> getStatistics(Relation relation, List<String> indicators, String pattern) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Graph<Individual> graph = RelationWorker.getReferentGraph(relation);
        for (String indicator : indicators) {
            if (indicator.equals("GRAPH")) {
                result.put(indicator, graph);
                continue;
            }
            if (indicator.equals("SIZE")) {
                result.put(indicator, graph.nodeCount());
                continue;
            }
            if (indicator.equals("MAXDEPTH")) {
                result.put(indicator, GraphUtils.getMaxDepth(graph));
                continue;
            }
            if (indicator.equals("MEANDEPTH")) {
                result.put(indicator, MathUtils.round(GraphUtils.getMeanDepth(graph), 2));
                continue;
            }
            if (indicator.equals("MEANINDEGREE")) {
                result.put(indicator, MathUtils.round(GraphUtils.meanInDegree(graph), 2));
                continue;
            }
            if (indicator.equals("DIAMETER")) {
                result.put(indicator, GraphUtils.getTreeDiameter(graph));
                continue;
            }
            if (indicator.contains("COMPONENT") || indicator.equals("CONCENTRATION")) {
                Partition<Node<Individual>> components = GraphUtils.components(graph);
                if (indicator.equals("NRCOMPONENTS")) {
                    result.put(indicator, components.size());
                    continue;
                }
                if (indicator.equals("MAXCOMPONENT")) {
                    result.put(indicator, components.maxClusterSize());
                    continue;
                }
                if (!indicator.equals("CONCENTRATION")) continue;
                result.put(indicator, components.concentration());
                continue;
            }
            if (indicator.equals("TREES_BY_ID")) {
                result.put(indicator, RelationWorker.getLinkTrees(relation, false, "ID", null));
                continue;
            }
            if (indicator.equals("TREES_BY_GENDER")) {
                result.put(indicator, RelationWorker.getLinkTrees(relation, false, "GENDER", null));
                continue;
            }
            if (!indicator.equals("TREES_BY_KIN")) continue;
            result.put(indicator, RelationWorker.getLinkTrees(relation, false, "KIN", pattern));
        }
        return result;
    }
}

