/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import fr.devinsy.util.StringList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.xls.XLSBufferedReader;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.workers.RelationModelTXTFile;

public class RelationModelXLSFile {
    public static final int MAX_LINE_SIZE = 1024;
    private static final Logger logger = LoggerFactory.getLogger(RelationModelXLSFile.class);

    public static StringList load(File file) throws PuckException {
        StringList result;
        XLSBufferedReader in = null;
        try {
            try {
                in = new XLSBufferedReader(file);
                result = RelationModelTXTFile.read(in);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
            catch (IOException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static void save(File file, RelationModel source) throws PuckException {
        RelationModelTXTFile.save(file, source);
    }

    public static void save(File file, Net source, ResourceBundle bundle) throws PuckException {
    }

    protected static enum Status {
        MANDATORY,
        OPTIONAL;

    }
}

