/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.bar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckManager;
import org.tip.puck.io.bar.BARTXTFile;
import org.tip.puck.io.ods.ODSBufferedReader;
import org.tip.puck.io.xls.XLSBufferedReader;

public class BARDetector {
    private static final Logger logger = LoggerFactory.getLogger(BARDetector.class);

    public static boolean assertIsBlankOrID(String source) {
        boolean result = StringUtils.isBlank((CharSequence)source) || NumberUtils.isNumber((String)source);
        return result;
    }

    public static boolean assertIsIndividualLine(String source) {
        boolean result;
        if (StringUtils.isBlank((CharSequence)source)) {
            result = false;
        } else {
            String[] tokens = source.split("\\t");
            if (tokens.length == 0) {
                result = false;
            } else if (tokens.length > 0 && !NumberUtils.isNumber((String)tokens[0])) {
                result = false;
            } else {
                boolean ended = false;
                result = true;
                int index = 3;
                while (!ended) {
                    if (index < tokens.length) {
                        String token = tokens[index];
                        if (!BARDetector.assertIsBlankOrID(token)) {
                            ended = true;
                            result = false;
                            continue;
                        }
                        ++index;
                        continue;
                    }
                    ended = true;
                    result = true;
                }
            }
        }
        return result;
    }

    public static boolean isBAR(BufferedReader in) throws Exception {
        boolean result;
        if (in == null) {
            result = false;
        } else {
            BARTXTFile.Format format = BARTXTFile.readLabelsLine(in, BARTXTFile.Status.OPTIONAL).getFormat();
            if (format == BARTXTFile.Format.TWOMODE) {
                logger.debug("TWOMODE detected => NOT BAR");
                result = true;
            } else {
                boolean ended = false;
                int individualLineCount = 0;
                result = false;
                while (!ended) {
                    in.mark(2048);
                    String line = in.readLine();
                    if (StringUtils.isBlank((CharSequence)line)) {
                        ended = true;
                        result = true;
                        continue;
                    }
                    if (line.matches("^\\D.*$")) {
                        ended = true;
                        in.reset();
                        result = true;
                        continue;
                    }
                    if (BARDetector.assertIsIndividualLine(line)) {
                        ++individualLineCount;
                        continue;
                    }
                    ended = true;
                    logger.debug("Detected not individual line => NOT BAR");
                    logger.debug("line=" + line);
                    result = false;
                }
                if (result) {
                    if (individualLineCount < 2) {
                        logger.debug("Individual line count < 2 => NOT BAR");
                        result = false;
                    } else {
                        result = true;
                    }
                }
            }
        }
        logger.debug("Done.");
        return result;
    }

    public static boolean isBAR(File source) {
        boolean result = BARDetector.isBAR(source, PuckManager.DEFAULT_CHARSET_NAME);
        return result;
    }

    public static boolean isBAR(File source, String charsetName) {
        boolean result;
        block11: {
            if (source == null) {
                result = false;
            } else if (source.getName().matches("^.*\\.[Bb][Aa][Rr]\\.(ods|ODS|txt|TXT|xls|XLS)$")) {
                result = true;
            } else if (source.getName().matches("^.*\\.[Ii][Uu][Rr]\\.(ods|ODS|txt|TXT|xls|XLS)$")) {
                result = false;
            } else {
                BufferedReader in = null;
                try {
                    try {
                        String fileName = source.getName().toLowerCase();
                        in = fileName.endsWith(".ods") ? new ODSBufferedReader(source) : (fileName.endsWith(".txt") ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), charsetName)) : (fileName.endsWith(".xls") ? new XLSBufferedReader(source) : null));
                        result = BARDetector.isBAR(in);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        result = false;
                        IOUtils.closeQuietly(in);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)in);
            }
        }
        return result;
    }
}

