/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo2;

import fr.devinsy.util.StringList;
import fr.devinsy.util.StringSet;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.geo2.Coordinate2;
import org.tip.puck.geo2.GeoLevel2;
import org.tip.puck.geo2.Homonyms;

public class Place2 {
    private String toponym;
    private Homonyms homonyms;
    private GeoLevel2 geoLevel;
    private Coordinate2 coordinate;
    private String externalId;
    private String comment;
    private String abovePlace;

    public Place2(String toponym) {
        this.toponym = toponym;
        this.externalId = null;
        this.homonyms = new Homonyms();
        this.geoLevel = GeoLevel2.LOCAL;
    }

    public String getAbovePlace() {
        return this.abovePlace;
    }

    public String getComment() {
        return this.comment;
    }

    public Coordinate2 getCoordinate() {
        return this.coordinate;
    }

    public Double getElevation() {
        Double result = this.coordinate == null ? null : Double.valueOf(this.coordinate.getElevation());
        return result;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public GeoLevel2 getGeoLevel() {
        return this.geoLevel;
    }

    public Homonyms getHomonyms() {
        return this.homonyms;
    }

    public Double getLatitude() {
        Double result = this.coordinate == null ? null : Double.valueOf(this.coordinate.getLatitude());
        return result;
    }

    public Double getLongitude() {
        Double result = this.coordinate == null ? null : Double.valueOf(this.coordinate.getLongitude());
        return result;
    }

    public String getToponym() {
        return this.toponym;
    }

    public StringList getToponyms() {
        StringList result = new StringList();
        result.add((Object)this.toponym);
        result.addAll((Collection)((Object)this.getHomonyms()));
        return result;
    }

    public boolean isGeocoded() {
        boolean result = this.coordinate != null;
        return result;
    }

    public void setAbovePlace(String abovePlace) {
        this.abovePlace = abovePlace;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCoordinate(Coordinate2 coordinate) {
        this.coordinate = coordinate;
    }

    public Place2 setElevation(Double value) {
        if (value == null) {
            this.coordinate = null;
        } else {
            if (this.coordinate == null) {
                this.coordinate = new Coordinate2();
            }
            this.coordinate.setElevation(value);
        }
        return this;
    }

    public Place2 setElevation(Integer value) {
        Place2 result = value == null ? this.setElevation((Double)null) : this.setElevation((double)value);
        return result;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setGeoLevel(GeoLevel2 geoLevel) {
        this.geoLevel = geoLevel;
    }

    public void setHomonyms(String homonyms) {
        if (StringUtils.isBlank((CharSequence)homonyms)) {
            this.homonyms.clear();
        } else {
            this.homonyms.clear();
            String[] stringArray = homonyms.split("[,;]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String homonym = stringArray[n2];
                this.homonyms.add(homonym);
                ++n2;
            }
        }
    }

    public void setHomonyms(StringSet source) {
        if (source == null) {
            this.homonyms.clear();
        } else {
            this.homonyms.clear();
            for (String homonym : source) {
                if (StringUtils.equals((CharSequence)this.toponym, (CharSequence)homonym)) continue;
                this.homonyms.add(homonym);
            }
        }
    }

    public Place2 setLatitude(Double value) {
        if (value == null) {
            this.coordinate = null;
        } else {
            if (this.coordinate == null) {
                this.coordinate = new Coordinate2();
            }
            this.coordinate.setLatitude(value);
        }
        return this;
    }

    public Place2 setLongitude(Double value) {
        if (value == null) {
            this.coordinate = null;
        } else {
            if (this.coordinate == null) {
                this.coordinate = new Coordinate2();
            }
            this.coordinate.setLongitude(value);
        }
        return this;
    }

    public void setToponym(String toponym) {
        this.toponym = toponym;
    }

    public String toString() {
        String result = this.toponym;
        return result;
    }
}

