/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.alliancenets;

import java.util.Arrays;

public class DistMatrix {
    private static DistMatrix _instance = null;
    int[] _umatrix;
    int[] _dmatrix;
    int _nodes = 0;

    public static DistMatrix instance() {
        if (_instance == null) {
            _instance = new DistMatrix();
        }
        return _instance;
    }

    public void setNodes(int nodes) {
        if (nodes != this._nodes) {
            if (this._nodes > 0) {
                this._umatrix = null;
                this._dmatrix = null;
            }
            this._nodes = nodes;
            if (this._nodes > 0) {
                this._umatrix = new int[this._nodes * this._nodes];
                this._dmatrix = new int[this._nodes * this._nodes];
            }
        }
        if (this._nodes > 0) {
            Arrays.fill(this._umatrix, 999999999);
            Arrays.fill(this._dmatrix, 999999999);
        }
    }

    public int getUDist(int x, int y) {
        if (x == y) {
            return 0;
        }
        return this._umatrix[y * this._nodes + x];
    }

    public int getDDist(int x, int y) {
        if (x == y) {
            return 0;
        }
        return this._dmatrix[y * this._nodes + x];
    }

    public void setUDist(int x, int y, int d) {
        this._umatrix[y * this._nodes + x] = d;
    }

    public void setDDist(int x, int y, int d) {
        this._dmatrix[y * this._nodes + x] = d;
    }

    public void updateDistances(int new_orig, int new_targ) {
        this.setUDist(new_orig, new_targ, 1);
        this.setUDist(new_targ, new_orig, 1);
        this.setDDist(new_orig, new_targ, 1);
        int i = 0;
        while (i < this._nodes) {
            if (this.getUDist(i, new_orig) != 0 || this.getUDist(i, new_targ) != 0) {
                int j = 0;
                while (j < this._nodes) {
                    int d0 = this.getUDist(i, new_orig);
                    int d1 = this.getUDist(new_targ, j);
                    int d = d0 + d1;
                    if (d0 > 0 && d1 > 0 && (d < this.getUDist(i, j) || this.getUDist(i, j) == 0)) {
                        this.setUDist(i, j, d);
                    }
                    d0 = this.getUDist(j, new_orig);
                    d1 = this.getUDist(new_targ, i);
                    d = d0 + d1;
                    if (d0 > 0 && d1 > 0 && (d < this.getUDist(i, j) || this.getUDist(i, j) == 0)) {
                        this.setUDist(i, j, d);
                    }
                    d0 = this.getDDist(i, new_orig);
                    d1 = this.getDDist(new_targ, j);
                    d = d0 + d1;
                    if (d0 > 0 && d1 > 0 && (d < this.getDDist(i, j) || this.getDDist(i, j) == 0)) {
                        this.setDDist(i, j, d);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

