/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.kinoath;

import javax.swing.AbstractListModel;
import org.tip.puck.kinoath.IndividualGroup;
import org.tip.puck.kinoath.IndividualGroupList;
import org.tip.puck.kinoath.IndividualGroups;

public class IndividualGroupsModel
extends AbstractListModel {
    private static final long serialVersionUID = 3976006165441114496L;
    private IndividualGroups source;
    private IndividualGroupList delegate;
    private Sorting sorting;

    public IndividualGroupsModel(IndividualGroups source) {
        this.source = source;
        this.delegate = source == null ? new IndividualGroupList() : this.source.toList().sortById();
        this.sorting = Sorting.ID;
    }

    @Override
    public Object getElementAt(int index) {
        IndividualGroup result = (IndividualGroup)this.delegate.get(index);
        return result;
    }

    @Override
    public int getSize() {
        int result = this.delegate.size();
        return result;
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public IndividualGroups getSource() {
        return this.source;
    }

    public int indexOf(IndividualGroup group) {
        int result;
        if (this.source == null) {
            result = -1;
        } else {
            boolean ended = false;
            result = -1;
            int index = 0;
            while (!ended) {
                if (index < this.delegate.size()) {
                    if (this.delegate.get(index) == group) {
                        ended = true;
                        result = index;
                        continue;
                    }
                    ++index;
                    continue;
                }
                ended = true;
                result = -1;
            }
        }
        return result;
    }

    public void setSorting(Sorting sorting) {
        if (sorting != null) {
            this.sorting = sorting;
            this.setSource(this.source);
        }
    }

    public void setSource(IndividualGroups source) {
        this.fireIntervalRemoved(this, 0, this.delegate.size());
        switch (this.sorting) {
            case ID: {
                this.delegate = this.source.toList().sortById();
                break;
            }
            case SIZE: {
                this.delegate = this.source.toList().sortBySize();
                break;
            }
            case REVERSED_SIZE: {
                this.delegate = this.source.toList().sortByReversedSize();
            }
        }
        this.fireIntervalAdded(this, 0, this.delegate.size());
    }

    public void touchSorting() {
        switch (this.sorting) {
            case ID: {
                this.setSorting(Sorting.REVERSED_SIZE);
                break;
            }
            case SIZE: {
                this.setSorting(Sorting.ID);
                break;
            }
            case REVERSED_SIZE: {
                this.setSorting(Sorting.SIZE);
            }
        }
    }

    public static enum Sorting {
        ID,
        SIZE,
        REVERSED_SIZE;

    }
}

