/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.geo;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.geotools.feature.DefaultFeatureCollection;
import org.tip.puck.PuckException;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.io.GeoNamesWebService;
import org.tip.puck.geo.tools.GeotoolsUtils;
import org.tip.puck.graphs.Graph;
import org.tip.puck.io.csv.CSVFile;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.geo.ConfigGeocodingDialog;
import org.tip.puckgui.views.geo.MapPanel_old;

public class Geocode
extends SwingWorker<ArrayList<DefaultFeatureCollection>, String> {
    ArrayList<DefaultFeatureCollection> collectionfeaturesReadyToBeDisplayed;
    ConfigGeocodingDialog mainDialog;
    JProgressBar progressBar;
    String typeOfGeocodingSource;
    GroupNetGUI parentGUI = null;
    NetGUI netGUI = null;
    File csvFile = null;
    Graph<?> graphFromFlowReport = null;
    Graph<?> genericGraphPlaces = null;

    public Geocode(ConfigGeocodingDialog mainDialog, JProgressBar progressBar, String typeOfGeocodingSource) {
        this.mainDialog = mainDialog;
        this.progressBar = progressBar;
        this.typeOfGeocodingSource = typeOfGeocodingSource;
    }

    public Geocode(ConfigGeocodingDialog mainDialog, JProgressBar progressBar, String typeOfGeocodingSource, NetGUI netGUI, Graph<?> graph) {
        this(mainDialog, progressBar, typeOfGeocodingSource);
        this.netGUI = netGUI;
        this.graphFromFlowReport = graph;
    }

    public Geocode(ConfigGeocodingDialog mainDialog, JProgressBar progressBar, String typeOfGeocodingSource, GroupNetGUI parentGUI) {
        this(mainDialog, progressBar, typeOfGeocodingSource);
        this.parentGUI = parentGUI;
    }

    public Geocode(ConfigGeocodingDialog mainDialog, JProgressBar progressBar, String typeOfGeocodingSource, NetGUI netGUI, File csvFile, Graph<?> graph) {
        this(mainDialog, progressBar, typeOfGeocodingSource);
        this.netGUI = netGUI;
        this.csvFile = csvFile;
        this.genericGraphPlaces = graph;
    }

    @Override
    protected ArrayList<DefaultFeatureCollection> doInBackground() throws Exception {
        GeotoolsUtils gtu;
        Graph<Place> geoPlaces;
        if (this.typeOfGeocodingSource.compareTo("geonames") == 0) {
            GeoNamesWebService ws = new GeoNamesWebService(this.progressBar);
            if (this.parentGUI != null) {
                this.collectionfeaturesReadyToBeDisplayed = ws.getCoordForNodesPlaces(this.parentGUI.getGroupNet());
            }
            if (this.graphFromFlowReport != null) {
                this.collectionfeaturesReadyToBeDisplayed = ws.getCoordForNodesPlaces(this.graphFromFlowReport);
            }
        }
        if (this.typeOfGeocodingSource.compareTo("personnalSources") == 0) {
            try {
                geoPlaces = CSVFile.load(this.csvFile, this.genericGraphPlaces, 1);
                gtu = new GeotoolsUtils();
                this.collectionfeaturesReadyToBeDisplayed = gtu.getFeaturesForNodesPlaces(geoPlaces, this.graphFromFlowReport);
            }
            catch (PuckException e) {
                e.printStackTrace();
            }
        }
        if (this.typeOfGeocodingSource.compareTo("geonamesFile") == 0) {
            try {
                geoPlaces = CSVFile.load(this.csvFile, this.genericGraphPlaces, 0);
                gtu = new GeotoolsUtils();
                this.collectionfeaturesReadyToBeDisplayed = gtu.getFeaturesForNodesPlaces(geoPlaces, this.graphFromFlowReport);
            }
            catch (PuckException e) {
                e.printStackTrace();
            }
        }
        if (this.typeOfGeocodingSource.compareTo("integrated") == 0) {
            geoPlaces = this.netGUI.getNet().getGeography().graph(GeoLevel.TOWN);
            gtu = new GeotoolsUtils();
            this.collectionfeaturesReadyToBeDisplayed = gtu.getFeaturesForNodesPlaces(geoPlaces, this.graphFromFlowReport);
        }
        return this.collectionfeaturesReadyToBeDisplayed;
    }

    @Override
    protected void done() {
        try {
            this.mainDialog.dispose();
            MapPanel_old geographyMap = new MapPanel_old();
            geographyMap.diplayCollectionsPointsAndLines(this.collectionfeaturesReadyToBeDisplayed);
            if (this.parentGUI != null) {
                this.parentGUI.addTab("Geography", geographyMap);
            }
            if (this.netGUI != null) {
                this.netGUI.addTab("Geography", geographyMap);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

