/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.filebatchconverter;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.tip.puck.net.workers.FileBatchConverterCriteria;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.views.OpenEncodingWindow;
import org.tip.puckgui.views.filebatchconverter.FileBatchConverterSourceDirectorySelector;
import org.tip.puckgui.views.filebatchconverter.FileBatchConverterTargetDirectorySelector;

public class FileBatchConverterDialog
extends JDialog {
    private static final long serialVersionUID = 7208254679850378876L;
    private final JPanel contentPanel = new JPanel();
    private final ButtonGroup btngrpMode = new ButtonGroup();
    private JTextField txtfldTargetDirectory;
    private JTextField txtfldSourceDirectory;
    private JRadioButton rdbtnSkip;
    private JRadioButton rdbtnPUC;
    private JRadioButton rdbtnIURODS;
    private final ButtonGroup btngrpTargetFormat = new ButtonGroup();
    private JRadioButton rdbtnIURTXT;
    private JRadioButton rdbtnIURXLS;
    private JRadioButton rdbtnIURTXTS;
    private JRadioButton rdbtnBARODS;
    private JRadioButton rdbtnBARTXT;
    private JRadioButton rdbtnBARXLS;
    private JRadioButton rdbtnGED;
    private JRadioButton rdbtnOverwrite;
    private FileBatchConverterCriteria dialogCriteria;
    private JComboBox cmbxCharset;

    public FileBatchConverterDialog() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("File Batch Converter");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(FileBatchConverterDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                FileBatchConverterDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 549, 443);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "About File Batch Converter", 4, 2, null, new Color(51, 51, 51)));
        this.getContentPane().add((Component)panel, "North");
        panel.setLayout(new BoxLayout(panel, 1));
        JTextPane txtpnIntroduction = new JTextPane();
        txtpnIntroduction.setEditable(false);
        txtpnIntroduction.setText("File Batch Converter allows to convert several files to one target format.");
        panel.add(txtpnIntroduction);
        JPanel panel_1 = new JPanel();
        panel.add(panel_1);
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_1.add(panel_2);
        panel_2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"350px:grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblSource = new JLabel("Source:");
        panel_2.add((Component)lblSource, "2, 2, left, center");
        this.txtfldSourceDirectory = new JTextField();
        this.txtfldSourceDirectory.setEditable(false);
        panel_2.add((Component)this.txtfldSourceDirectory, "4, 2, fill, center");
        this.txtfldSourceDirectory.setColumns(10);
        JButton button = new JButton("\u2026");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File source = FileBatchConverterSourceDirectorySelector.showSelectorDialog(FileBatchConverterDialog.this, new File(FileBatchConverterDialog.this.txtfldSourceDirectory.getText()));
                FileBatchConverterDialog.this.txtfldSourceDirectory.setText(source.getAbsolutePath());
            }
        });
        panel_2.add((Component)button, "6, 2, left, top");
        JLabel lblCharset = new JLabel("Charset:");
        panel_2.add((Component)lblCharset, "2, 4, right, default");
        this.cmbxCharset = new JComboBox<Object>(FileBatchConverterDialog.buildCharsetLabels().toArray());
        this.cmbxCharset.setSelectedItem("Standard UTF-8 (UTF8)");
        panel_2.add((Component)this.cmbxCharset, "4, 4, fill, default");
        JLabel lblTarget = new JLabel("Target:");
        panel_2.add((Component)lblTarget, "2, 6, right, center");
        this.txtfldTargetDirectory = new JTextField();
        this.txtfldTargetDirectory.setEditable(false);
        this.txtfldTargetDirectory.setColumns(10);
        panel_2.add((Component)this.txtfldTargetDirectory, "4, 6, fill, center");
        button = new JButton("\u2026");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File target = FileBatchConverterTargetDirectorySelector.showSelectorDialog(FileBatchConverterDialog.this, new File(FileBatchConverterDialog.this.txtfldTargetDirectory.getText()));
                FileBatchConverterDialog.this.txtfldTargetDirectory.setText(target.getAbsolutePath());
            }
        });
        panel_2.add((Component)button, "6, 6, left, top");
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 0));
        panel = new JPanel();
        this.contentPanel.add(panel);
        panel.setLayout(new BoxLayout(panel, 0));
        panel_1 = new JPanel();
        panel.add(panel_1);
        panel_1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblTargetFormat = new JLabel("Target format:");
        panel_1.add((Component)lblTargetFormat, "2, 2");
        this.rdbtnPUC = new JRadioButton("PUC ( .puc)");
        this.btngrpTargetFormat.add(this.rdbtnPUC);
        panel_1.add((Component)this.rdbtnPUC, "2, 4");
        this.rdbtnIURODS = new JRadioButton("IUR ODS ( .iur.ods)");
        this.btngrpTargetFormat.add(this.rdbtnIURODS);
        panel_1.add((Component)this.rdbtnIURODS, "2, 6");
        this.rdbtnBARODS = new JRadioButton("BAR ODS ( .bar.ods)");
        this.btngrpTargetFormat.add(this.rdbtnBARODS);
        panel_1.add((Component)this.rdbtnBARODS, "4, 6");
        this.rdbtnIURTXT = new JRadioButton("IUR TXT ( .iur.txt)");
        this.btngrpTargetFormat.add(this.rdbtnIURTXT);
        panel_1.add((Component)this.rdbtnIURTXT, "2, 8");
        this.rdbtnBARTXT = new JRadioButton("BAR TXT ( .bar.txt)");
        this.btngrpTargetFormat.add(this.rdbtnBARTXT);
        panel_1.add((Component)this.rdbtnBARTXT, "4, 8");
        this.rdbtnIURXLS = new JRadioButton("IUR XLS ( .iur.xls)");
        this.btngrpTargetFormat.add(this.rdbtnIURXLS);
        panel_1.add((Component)this.rdbtnIURXLS, "2, 10");
        this.rdbtnBARXLS = new JRadioButton("BAR XLS ( .bar.xls)");
        this.btngrpTargetFormat.add(this.rdbtnBARXLS);
        panel_1.add((Component)this.rdbtnBARXLS, "4, 10");
        this.rdbtnIURTXTS = new JRadioButton("IUR TXT Splitted ( .iurs.txt)");
        this.btngrpTargetFormat.add(this.rdbtnIURTXTS);
        panel_1.add((Component)this.rdbtnIURTXTS, "2, 12");
        this.rdbtnGED = new JRadioButton("Gedcom ( .ged)");
        this.btngrpTargetFormat.add(this.rdbtnGED);
        panel_1.add((Component)this.rdbtnGED, "4, 12");
        JSeparator separator = new JSeparator();
        separator.setOrientation(1);
        panel.add(separator);
        panel_1 = new JPanel();
        panel.add(panel_1);
        panel_1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblMode = new JLabel("Mode:");
        panel_1.add((Component)lblMode, "2, 2");
        this.rdbtnSkip = new JRadioButton("Skip");
        panel_1.add((Component)this.rdbtnSkip, "2, 4");
        this.btngrpMode.add(this.rdbtnSkip);
        this.rdbtnOverwrite = new JRadioButton("Overwrite");
        this.btngrpMode.add(this.rdbtnOverwrite);
        panel_1.add((Component)this.rdbtnOverwrite, "2, 6");
        JPanel panel_3 = new JPanel();
        panel_1.add((Component)panel_3, "2, 7");
        panel_3.setLayout(new BoxLayout(panel_3, 1));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBatchConverterDialog.this.dialogCriteria = null;
                FileBatchConverterDialog.this.setVisible(false);
            }
        });
        btnCancel.setActionCommand("Cancel");
        buttonPane.add(btnCancel);
        JButton btnConvert = new JButton("Convert");
        btnConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileBatchConverterDialog.this.dialogCriteria = FileBatchConverterDialog.this.getCriteria();
                if (FileBatchConverterDialog.this.dialogCriteria != null) {
                    PuckGUI.instance().getPreferences().setFileBatchConverterCriteria(FileBatchConverterDialog.this.dialogCriteria);
                    FileBatchConverterDialog.this.setVisible(false);
                }
            }
        });
        Component horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        JButton btnReset = new JButton("Reset");
        btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileBatchConverterDialog.this.setCriteria(new FileBatchConverterCriteria());
            }
        });
        btnReset.setActionCommand("OK");
        buttonPane.add(btnReset);
        horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        btnConvert.setActionCommand("OK");
        buttonPane.add(btnConvert);
        this.getRootPane().setDefaultButton(btnConvert);
        this.dialogCriteria = null;
        FileBatchConverterCriteria criteria = PuckGUI.instance().getPreferences().getFileBatchConverterCriteria();
        if (criteria == null) {
            this.setCriteria(new FileBatchConverterCriteria());
        } else {
            this.setCriteria(criteria);
        }
    }

    public FileBatchConverterCriteria getCriteria() {
        FileBatchConverterCriteria result = new FileBatchConverterCriteria();
        result.setSourceDirectory(new File(this.txtfldSourceDirectory.getText()));
        result.setTargetDirectory(new File(this.txtfldTargetDirectory.getText()));
        if (this.rdbtnOverwrite.isSelected()) {
            result.setMode(FileBatchConverterCriteria.Mode.OVERWRITE);
        } else {
            result.setMode(FileBatchConverterCriteria.Mode.SKIP);
        }
        if (this.rdbtnBARODS.isSelected()) {
            result.setTargetFormat(FileBatchConverterCriteria.TargetFormat.BARODS);
        } else if (this.rdbtnBARTXT.isSelected()) {
            result.setTargetFormat(FileBatchConverterCriteria.TargetFormat.BARTXT);
        } else if (this.rdbtnBARXLS.isSelected()) {
            result.setTargetFormat(FileBatchConverterCriteria.TargetFormat.BARXLS);
        } else if (this.rdbtnIURODS.isSelected()) {
            result.setTargetFormat(FileBatchConverterCriteria.TargetFormat.IURODS);
        } else if (this.rdbtnIURTXT.isSelected()) {
            result.setTargetFormat(FileBatchConverterCriteria.TargetFormat.IURTXT);
        } else if (this.rdbtnIURXLS.isSelected()) {
            result.setTargetFormat(FileBatchConverterCriteria.TargetFormat.IURXLS);
        } else if (this.rdbtnIURTXTS.isSelected()) {
            result.setTargetFormat(FileBatchConverterCriteria.TargetFormat.IURTXTS);
        } else if (this.rdbtnGED.isSelected()) {
            result.setTargetFormat(FileBatchConverterCriteria.TargetFormat.GEDCOM);
        } else if (this.rdbtnPUC.isSelected()) {
            result.setTargetFormat(FileBatchConverterCriteria.TargetFormat.PUC);
        }
        String charsetName = OpenEncodingWindow.charsets()[this.cmbxCharset.getSelectedIndex()][0];
        result.setCharsetName(charsetName);
        return result;
    }

    public FileBatchConverterCriteria getDialogCriteria() {
        FileBatchConverterCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(FileBatchConverterCriteria source) {
        if (source != null) {
            if (source.getSourceDirectory() != null) {
                this.txtfldSourceDirectory.setText(source.getSourceDirectory().getAbsolutePath());
            }
            if (source.getTargetDirectory() != null) {
                this.txtfldTargetDirectory.setText(source.getTargetDirectory().getAbsolutePath());
            }
            switch (source.getMode()) {
                case OVERWRITE: {
                    this.rdbtnOverwrite.setSelected(true);
                    break;
                }
                case SKIP: {
                    this.rdbtnSkip.setSelected(true);
                }
            }
            switch (source.getTargetFormat()) {
                case BARODS: {
                    this.rdbtnBARODS.setSelected(true);
                    break;
                }
                case BARTXT: {
                    this.rdbtnBARTXT.setSelected(true);
                    break;
                }
                case BARXLS: {
                    this.rdbtnBARXLS.setSelected(true);
                    break;
                }
                case GEDCOM: {
                    this.rdbtnGED.setSelected(true);
                    break;
                }
                case IURODS: {
                    this.rdbtnIURODS.setSelected(true);
                    break;
                }
                case IURTXT: {
                    this.rdbtnIURTXT.setSelected(true);
                    break;
                }
                case IURTXTS: {
                    this.rdbtnIURTXTS.setSelected(true);
                    break;
                }
                case IURXLS: {
                    this.rdbtnIURXLS.setSelected(true);
                    break;
                }
                case PUC: {
                    this.rdbtnPUC.setSelected(true);
                }
            }
        }
    }

    public static StringList buildCharsetLabels() {
        String[][] charsets = OpenEncodingWindow.charsets();
        StringList result = new StringList(charsets.length);
        String[][] stringArray = charsets;
        int n = charsets.length;
        int n2 = 0;
        while (n2 < n) {
            String[] charset = stringArray[n2];
            String label = String.format("%s (%s)", charset[1], charset[0]);
            result.add((Object)label);
            ++n2;
        }
        result.sort();
        return result;
    }

    public static void main(String[] args) {
        FileBatchConverterDialog.showDialog();
    }

    public static FileBatchConverterCriteria showDialog() {
        FileBatchConverterDialog dialog = new FileBatchConverterDialog();
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        FileBatchConverterCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

