/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportChartMaker;
import org.tip.puckgui.views.ChartWindow;

public class ReportChartPanelMaker {
    private static final Logger logger = LoggerFactory.getLogger(ReportChartPanelMaker.class);

    public static JPanel createPanel(ReportChart reportChart) {
        JPanel result;
        switch (reportChart.getType()) {
            case BAR_BOARD: 
            case SURFACE: {
                result = new JPanel();
                result.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229), 1, true), reportChart.getTitle(), 4, 2, null, new Color(51, 51, 51)));
                result.setLayout(new BoxLayout(result, 0));
                JLabel jlabel = new JLabel(new ImageIcon(ReportChartMaker.createBufferedImage(reportChart, 800, 600)));
                jlabel.setBorder(null);
                result.add(jlabel);
                break;
            }
            default: {
                JFreeChart chart = ReportChartMaker.createJFreeChart(reportChart);
                result = new ChartPanel(chart);
            }
        }
        result.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229), 1, true), reportChart.getTitle(), 4, 2, null, new Color(51, 51, 51)));
        return result;
    }

    public static JPanel createPanel(ReportChart reportChart, int width, int height) {
        JPanel result = ReportChartPanelMaker.createPanel(reportChart);
        result.setPreferredSize(new Dimension(width, height));
        result.setMaximumSize(new Dimension(width, height));
        return result;
    }

    public static JPanel createSimplePanel(final ReportChart reportChart, int width, int height) {
        JPanel result = new JPanel();
        result.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229), 1, true), reportChart.getTitle(), 4, 2, null, new Color(51, 51, 51)));
        result.setLayout(new BoxLayout(result, 0));
        JLabel jlabel = new JLabel(new ImageIcon(ReportChartMaker.createBufferedImage(reportChart, width, height)));
        jlabel.setBorder(null);
        result.add(jlabel);
        jlabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                JPanel chartPanel = ReportChartPanelMaker.createPanel(reportChart);
                ChartWindow window = new ChartWindow(chartPanel);
                window.setDefaultCloseOperation(2);
                window.setVisible(true);
            }
        });
        result.setBounds(0, 0, width, height);
        return result;
    }
}

