/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.net.workers.RelationToAttributeCriteria;

public class RelationToAttributeInputDialog
extends JDialog {
    private static final long serialVersionUID = 7208254679850378876L;
    private final JPanel contentPanel = new JPanel();
    private RelationToAttributeCriteria dialogCriteria;
    private static RelationToAttributeCriteria lastCriteria = new RelationToAttributeCriteria();
    private JComboBox cmbbxTarget;
    private JComboBox cmbbxAttributeLabel;
    private JComboBox cmbbxDateLabel;
    private JCheckBox chckbxIgnoreCase;

    public RelationToAttributeInputDialog(List<String> relationModelNames, final AttributeDescriptors attributeDescriptors) {
        ArrayList<String> targetLabels = new ArrayList<String>();
        if (relationModelNames != null) {
            for (String name : relationModelNames) {
                targetLabels.add(name);
            }
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Relation To Attribute Input");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(RelationToAttributeInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RelationToAttributeInputDialog.this.dialogCriteria = null;
                RelationToAttributeInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 420, 235);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblTarget = new JLabel("Target:");
        this.contentPanel.add((Component)lblTarget, "2, 2, right, default");
        this.cmbbxTarget = new JComboBox<Object>(targetLabels.toArray());
        this.cmbbxTarget.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    StringList labels = attributeDescriptors.findByRelationModelName((String)RelationToAttributeInputDialog.this.cmbbxTarget.getSelectedItem()).labels();
                    Collections.sort(labels);
                    RelationToAttributeInputDialog.this.cmbbxAttributeLabel.setModel(new DefaultComboBoxModel<Object>(labels.toArray()));
                    RelationToAttributeInputDialog.this.cmbbxAttributeLabel.setSelectedIndex(-1);
                    RelationToAttributeInputDialog.this.cmbbxDateLabel.setModel(new DefaultComboBoxModel<Object>(labels.toArray()));
                    RelationToAttributeInputDialog.this.cmbbxDateLabel.setSelectedIndex(-1);
                }
            }
        });
        this.contentPanel.add((Component)this.cmbbxTarget, "4, 2, fill, default");
        JLabel lblLabel = new JLabel("Attribute Label:");
        this.contentPanel.add((Component)lblLabel, "2, 4, right, default");
        this.cmbbxAttributeLabel = new JComboBox<Object>(attributeDescriptors.labelsSorted().toArray());
        this.cmbbxAttributeLabel.setEditable(true);
        this.contentPanel.add((Component)this.cmbbxAttributeLabel, "4, 4, fill, default");
        JLabel lblNewLabel = new JLabel("Date Label:");
        this.contentPanel.add((Component)lblNewLabel, "2, 6, right, default");
        this.cmbbxDateLabel = new JComboBox<Object>(attributeDescriptors.labelsSorted().toArray());
        this.cmbbxDateLabel.setEditable(true);
        this.contentPanel.add((Component)this.cmbbxDateLabel, "4, 6, fill, default");
        JPanel panel = new JPanel();
        panel.setBorder(null);
        this.contentPanel.add((Component)panel, "4, 8, fill, center");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"21px"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"83px:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"21px"), FormFactory.DEFAULT_ROWSPEC}));
        this.chckbxIgnoreCase = new JCheckBox("");
        panel.add((Component)this.chckbxIgnoreCase, "2, 2, left, top");
        JLabel lblIgnoreCase = new JLabel("ignore case");
        panel.add((Component)lblIgnoreCase, "4, 2, left, center");
        JCheckBox chckbxTrim = new JCheckBox("");
        panel.add((Component)chckbxTrim, "2, 3");
        chckbxTrim.setEnabled(false);
        chckbxTrim.setSelected(true);
        JLabel lblTrimLabelAnd = new JLabel("trim label and new label");
        panel.add((Component)lblTrimLabelAnd, "4, 3");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelationToAttributeInputDialog.this.dialogCriteria = null;
                RelationToAttributeInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("Convert");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelationToAttributeCriteria criteria = RelationToAttributeInputDialog.this.getCriteria();
                if (StringUtils.isBlank((CharSequence)criteria.getRelationAttributeLabel())) {
                    String title = "Invalid input";
                    String message = "Please, enter a label not empty.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    RelationToAttributeInputDialog.this.dialogCriteria = criteria;
                    RelationToAttributeInputDialog.this.setVisible(false);
                }
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.setCriteria(lastCriteria);
    }

    public RelationToAttributeCriteria getCriteria() {
        RelationToAttributeCriteria result = new RelationToAttributeCriteria();
        result.setOptionalRelationName((String)this.cmbbxTarget.getSelectedItem());
        result.setRelationAttributeLabel((String)this.cmbbxAttributeLabel.getSelectedItem());
        result.setDateLabel((String)this.cmbbxDateLabel.getSelectedItem());
        if (this.chckbxIgnoreCase.isSelected()) {
            result.setCaseOption(AttributeWorker.CaseOption.IGNORE_CASE);
        } else {
            result.setCaseOption(AttributeWorker.CaseOption.CASE_SENSITIVE);
        }
        return result;
    }

    public RelationToAttributeCriteria getDialogCriteria() {
        RelationToAttributeCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(RelationToAttributeCriteria source) {
        if (source != null) {
            this.cmbbxTarget.setSelectedItem(source.getOptionalRelationName());
            this.cmbbxAttributeLabel.setSelectedItem(source.getRelationAttributeLabel());
            this.cmbbxDateLabel.setSelectedItem(source.getDateLabel());
            if (source.isCaseSensitive()) {
                this.chckbxIgnoreCase.setSelected(false);
            } else {
                this.chckbxIgnoreCase.setSelected(true);
            }
        }
    }

    public static void main(String[] args) {
        RelationToAttributeInputDialog.showDialog(null, null);
    }

    public static RelationToAttributeCriteria showDialog(List<String> relationModelNames, AttributeDescriptors attributeDescriptors) {
        RelationToAttributeInputDialog dialog = new RelationToAttributeInputDialog(relationModelNames, attributeDescriptors);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        RelationToAttributeCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

