/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.relations.Role;
import org.tip.puck.sequences.workers.MissingTestimoniesCriteria;

public class MissingTestimoniesInputDialog
extends JDialog {
    private static final long serialVersionUID = -6081828976427430274L;
    private static final Logger logger = LoggerFactory.getLogger(MissingTestimoniesInputDialog.class);
    private RelationModels relationModels;
    private final JPanel contentPanel = new JPanel();
    private MissingTestimoniesCriteria dialogCriteria;
    private static MissingTestimoniesCriteria lastCriteria = new MissingTestimoniesCriteria();
    private JComboBox cmbbxRelationModel;
    private JComboBox cmbbxEgoRole;
    private JButton okButton;

    public MissingTestimoniesInputDialog(RelationModels relationModels) {
        this.relationModels = relationModels;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Missing Testimonies Input Dialog");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(MissingTestimoniesInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MissingTestimoniesInputDialog.this.dialogCriteria = null;
                MissingTestimoniesInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 420, 157);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(100dlu;default):grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblRelationModel = new JLabel("Relation Model:");
        this.contentPanel.add((Component)lblRelationModel, "2, 2, right, default");
        this.cmbbxRelationModel = new JComboBox<Object>(relationModels.nameList().toArray());
        this.cmbbxRelationModel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    MissingTestimoniesInputDialog.this.setRelationModel(MissingTestimoniesInputDialog.this.cmbbxRelationModel.getSelectedIndex(), null);
                }
            }
        });
        this.contentPanel.add((Component)this.cmbbxRelationModel, "4, 2, fill, default");
        JLabel lblEgoRole = new JLabel("Ego Role:");
        this.contentPanel.add((Component)lblEgoRole, "2, 4, right, default");
        this.cmbbxEgoRole = new JComboBox();
        this.contentPanel.add((Component)this.cmbbxEgoRole, "4, 4, fill, default");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MissingTestimoniesInputDialog.this.dialogCriteria = null;
                MissingTestimoniesInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.okButton = new JButton("Launch");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MissingTestimoniesCriteria criteria = MissingTestimoniesInputDialog.this.getCriteria();
                if (criteria.getRelationModelName() == null) {
                    String title = "Invalid input";
                    String message = "A relation model is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else if (criteria.getEgoRoleName() == null) {
                    String title = "Invalid input";
                    String message = "An ego role is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    MissingTestimoniesInputDialog.this.dialogCriteria = criteria;
                    MissingTestimoniesInputDialog.this.setVisible(false);
                }
            }
        });
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setCriteria(lastCriteria);
    }

    public MissingTestimoniesCriteria getCriteria() {
        MissingTestimoniesCriteria result = new MissingTestimoniesCriteria();
        if (this.cmbbxRelationModel.getSelectedIndex() == -1) {
            result.setRelationModelName(null);
        } else {
            result.setRelationModelName((String)this.cmbbxRelationModel.getSelectedItem());
        }
        if (this.cmbbxEgoRole.getSelectedIndex() == -1) {
            result.setEgoRoleName(null);
        } else {
            result.setEgoRoleName((String)this.cmbbxEgoRole.getSelectedItem());
        }
        logger.debug("criteria=" + result.toString());
        return result;
    }

    public MissingTestimoniesCriteria getDialogCriteria() {
        MissingTestimoniesCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(MissingTestimoniesCriteria source) {
        if (source != null) {
            if (this.relationModels.isEmpty()) {
                this.cmbbxRelationModel.setEnabled(false);
                this.cmbbxEgoRole.setEnabled(false);
            } else {
                this.cmbbxRelationModel.setEnabled(true);
                this.cmbbxEgoRole.setEnabled(true);
                RelationModel currentRelationModel = this.relationModels.getByName(source.getRelationModelName());
                if (currentRelationModel == null) {
                    currentRelationModel = (RelationModel)this.relationModels.get(0);
                }
                this.setRelationModel(this.relationModels.indexOf(currentRelationModel), source.getEgoRoleName());
            }
        }
    }

    private void setRelationModel(int currentRelationModelIndex, String egoRoleName) {
        RelationModel currentRelationModel = (RelationModel)this.relationModels.get(currentRelationModelIndex);
        if (currentRelationModel.roles().isEmpty()) {
            this.cmbbxEgoRole.setEnabled(false);
        } else {
            this.cmbbxEgoRole.setModel(new DefaultComboBoxModel<Object>(currentRelationModel.roles().toNameList().toArray()));
            Role currentEgoRole = currentRelationModel.roles().getByName(egoRoleName);
            if (currentEgoRole == null) {
                currentEgoRole = (Role)currentRelationModel.roles().get(0);
            }
            this.cmbbxEgoRole.setSelectedIndex(currentRelationModel.roles().indexOf(currentEgoRole));
        }
    }

    public static void main(String[] args) {
        MissingTestimoniesInputDialog.showDialog(null);
    }

    public static MissingTestimoniesCriteria showDialog(RelationModels relationModels) {
        MissingTestimoniesInputDialog dialog = new MissingTestimoniesInputDialog(relationModels);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        MissingTestimoniesCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

