/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.workers.GeocodingWorker;
import org.tip.puck.graphs.ClusterPair;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.net.Attributable;
import org.tip.puck.net.relations.workers.RelationValuator;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.graphs.ClusterNetworkReporter;
import org.tip.puck.partitions.graphs.ClusterNetworkUtils;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.FooReporterInputWindow;
import org.tip.puckgui.views.geo.MapPanel;

public class FlowNetworkInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(FlowNetworkInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private NetGUI netGUI;
    private JPanel contentPane;
    private static String lastSourceLabel;
    private static String lastTargetLabel;
    private static String lastRelationLabel;
    private static String lastLevel;
    private static int lastMinimalValue;
    private JComboBox comboBoxSourceLabel;
    private JComboBox comboBoxTargetLabel;
    private JComboBox comboBoxRelation;
    private JComboBox comboBoxLevel;
    private JSpinner spinnerMinimalNumberOfLinks;
    private JCheckBox chckbxBuildCartogrpahy;

    static {
        lastMinimalValue = 2;
    }

    public FlowNetworkInputWindow(final NetGUI netGUI) {
        StringList availableSourceLabels = IndividualValuator.getAttributeLabelSample(netGUI.getNet().individuals());
        availableSourceLabels.addAll(RelationValuator.getAttributeLabelSample(netGUI.getNet().relations()));
        ArrayList<String> availableTargetLabels = new ArrayList<String>((Collection<String>)availableSourceLabels);
        List<String> availableRelations = netGUI.getNet().getRelationModelLabels();
        StringList availableLevels = GeoLevel.toStringList();
        if (lastSourceLabel == null) {
            availableSourceLabels.add(0, "");
        } else {
            availableSourceLabels.add(0, lastSourceLabel);
        }
        if (lastTargetLabel == null) {
            availableTargetLabels.add(0, "");
        } else {
            availableTargetLabels.add(0, lastTargetLabel);
        }
        if (lastRelationLabel == null) {
            availableRelations.add(0, "");
        } else {
            availableRelations.add(0, lastRelationLabel);
        }
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(FooReporterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.netGUI = netGUI;
        this.setTitle("Flow Network Inputs");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 340, 315);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblSourceLabel = new JLabel("Source Label:");
        panel.add((Component)lblSourceLabel, "2, 4, right, default");
        this.comboBoxSourceLabel = new JComboBox<Object>(availableSourceLabels.toArray());
        this.comboBoxSourceLabel.setSelectedIndex(0);
        this.comboBoxSourceLabel.setMaximumRowCount(12);
        this.comboBoxSourceLabel.setEditable(true);
        panel.add((Component)this.comboBoxSourceLabel, "4, 4, fill, default");
        JLabel lblTargetLabel = new JLabel("Target Label:");
        panel.add((Component)lblTargetLabel, "2, 6, right, default");
        this.comboBoxTargetLabel = new JComboBox<Object>(availableTargetLabels.toArray());
        this.comboBoxTargetLabel.setSelectedIndex(0);
        this.comboBoxTargetLabel.setMaximumRowCount(12);
        this.comboBoxTargetLabel.setEditable(true);
        panel.add((Component)this.comboBoxTargetLabel, "4, 6, fill, default");
        JLabel lblRelationLabel = new JLabel("Relation Label:");
        panel.add((Component)lblRelationLabel, "2, 8, right, default");
        this.comboBoxRelation = new JComboBox<Object>(availableRelations.toArray());
        this.comboBoxRelation.setSelectedIndex(0);
        this.comboBoxRelation.setMaximumRowCount(12);
        this.comboBoxRelation.setEditable(true);
        panel.add((Component)this.comboBoxRelation, "4, 8, fill, default");
        JLabel lblLevel = new JLabel("Level:");
        panel.add((Component)lblLevel, "2, 10, right, default");
        this.comboBoxLevel = new JComboBox<Object>(availableLevels.toArray());
        if (lastLevel == null) {
            this.comboBoxLevel.setSelectedIndex(availableLevels.size() - 1);
        } else {
            this.comboBoxLevel.setSelectedIndex(availableLevels.indexOf(lastLevel));
        }
        this.comboBoxLevel.setMaximumRowCount(12);
        panel.add((Component)this.comboBoxLevel, "4, 10, fill, default");
        JLabel label = new JLabel("<html><div style=\"text-align:right\">Minimal number:<br/>of links</div></html>");
        panel.add((Component)label, "2, 12");
        this.spinnerMinimalNumberOfLinks = new JSpinner();
        this.spinnerMinimalNumberOfLinks.setModel(new SpinnerNumberModel(new Integer(2), new Integer(0), null, new Integer(1)));
        panel.add((Component)this.spinnerMinimalNumberOfLinks, "4, 12");
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowNetworkInputWindow.this.dispose();
            }
        });
        buttonPanel.add(btnCancel);
        JLabel lblBuildCartography = new JLabel("Build Cartography");
        panel.add((Component)lblBuildCartography, "2, 14");
        this.chckbxBuildCartogrpahy = new JCheckBox("");
        panel.add((Component)this.chckbxBuildCartogrpahy, "4, 14");
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String sourceLabel = (String)FlowNetworkInputWindow.this.comboBoxSourceLabel.getSelectedItem();
                    String targetLabel = (String)FlowNetworkInputWindow.this.comboBoxTargetLabel.getSelectedItem();
                    String relationLabel = (String)FlowNetworkInputWindow.this.comboBoxRelation.getSelectedItem();
                    String level = (String)FlowNetworkInputWindow.this.comboBoxLevel.getSelectedItem();
                    int minimalNumberOfLinks = (Integer)FlowNetworkInputWindow.this.spinnerMinimalNumberOfLinks.getValue();
                    lastSourceLabel = sourceLabel;
                    lastTargetLabel = targetLabel;
                    lastRelationLabel = relationLabel;
                    lastLevel = level;
                    lastMinimalValue = minimalNumberOfLinks;
                    if (sourceLabel == null || targetLabel == null) {
                        String title = "Bad input";
                        String message = "Please, enter none empty input.";
                        JOptionPane.showMessageDialog(FlowNetworkInputWindow.this.thisJFrame, message, title, 0);
                    } else {
                        Report report = ClusterNetworkReporter.reportFlowNetwork(netGUI.getSegmentation(), netGUI.getFile(), relationLabel, sourceLabel, targetLabel, level, minimalNumberOfLinks);
                        netGUI.addReportTab(report);
                        if (FlowNetworkInputWindow.this.chckbxBuildCartogrpahy.isSelected()) {
                            Graph<ClusterPair<Attributable>> graph = StringUtils.isBlank((CharSequence)relationLabel) ? ClusterNetworkUtils.createFlowNetwork(netGUI.getSegmentation(), sourceLabel, targetLabel, ClusterNetworkUtils.LineType.WEIGHTED_ARC) : ClusterNetworkUtils.createFlowNetwork(netGUI.getSegmentation(), relationLabel, sourceLabel, targetLabel, level, ClusterNetworkUtils.LineType.WEIGHTED_ARC);
                            logger.debug("Graph node count={}", (Object)graph.nodeCount());
                            graph = GraphUtils.reduce(graph, minimalNumberOfLinks, 0.0, 0.0);
                            logger.debug("Graph reduced node count={}", (Object)graph.nodeCount());
                            Graph<Place> geocodedGraph = GeocodingWorker.geocodeGraph(netGUI.getNet().getGeography(), graph);
                            logger.debug("Graph geocoded node count={}", (Object)geocodedGraph.nodeCount());
                            String label = String.format("%s-%s", netGUI.getNet().getLabel(), "Flow Cartography");
                            logger.debug("geocoded graph label=[{}]", (Object)label);
                            geocodedGraph.setLabel(label);
                            MapPanel cartographyMap = new MapPanel(geocodedGraph);
                            netGUI.addTab("Flow Cartography", cartographyMap);
                        }
                        FlowNetworkInputWindow.this.dispose();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(FlowNetworkInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
        this.spinnerMinimalNumberOfLinks.setValue(lastMinimalValue);
    }
}

