/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.report.Report;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puckgui.NetGUI;

public class AttributeValueStatisticsByClusterInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(AttributeValueStatisticsByClusterInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private NetGUI netGUI;
    private JPanel contentPane;
    private static String lastFirstParameter;
    private static String lastSecondParameter;
    private JComboBox comboBoxParameter;
    private JComboBox comboBoxParameter2;

    public AttributeValueStatisticsByClusterInputWindow(final NetGUI netGUI) {
        StringList availableLabels = IndividualValuator.getAttributeLabelSample(netGUI.getNet().individuals());
        if (lastFirstParameter == null) {
            availableLabels.add(0, "");
        } else {
            availableLabels.add(0, lastFirstParameter);
        }
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(AttributeValueStatisticsByClusterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.netGUI = netGUI;
        this.setTitle("List by Cluster Inputs");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 365, 200);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblPartition = new JLabel("Partition:");
        panel.add((Component)lblPartition, "2, 4, right, default");
        this.comboBoxParameter = new JComboBox<Object>(availableLabels.toArray());
        this.comboBoxParameter.setSelectedIndex(0);
        this.comboBoxParameter.setMaximumRowCount(12);
        this.comboBoxParameter.setEditable(true);
        panel.add((Component)this.comboBoxParameter, "4, 4, fill, default");
        this.comboBoxParameter2 = new JComboBox<Object>(availableLabels.toArray());
        this.comboBoxParameter.setSelectedIndex(0);
        this.comboBoxParameter.setMaximumRowCount(12);
        this.comboBoxParameter.setEditable(true);
        JLabel lblAttribute = new JLabel("Attribute:");
        panel.add((Component)lblAttribute, "2, 6, right, default");
        panel.add((Component)this.comboBoxParameter2, "4, 6, fill, default");
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeValueStatisticsByClusterInputWindow.this.dispose();
            }
        });
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String firstParameter = (String)AttributeValueStatisticsByClusterInputWindow.this.comboBoxParameter.getSelectedItem();
                    String secondParameter = (String)AttributeValueStatisticsByClusterInputWindow.this.comboBoxParameter2.getSelectedItem();
                    lastFirstParameter = firstParameter;
                    lastSecondParameter = secondParameter;
                    if (firstParameter == null) {
                        String title = "Bad input";
                        String message = "Please, enter none empty input.";
                        JOptionPane.showMessageDialog(AttributeValueStatisticsByClusterInputWindow.this.thisJFrame, message, title, 0);
                    } else {
                        Report report = StatisticsReporter.reportAttributeValueStatisticsByCluster(netGUI.getSegmentation(), firstParameter, secondParameter);
                        netGUI.addReportTab(report);
                        AttributeValueStatisticsByClusterInputWindow.this.dispose();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(AttributeValueStatisticsByClusterInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
    }
}

