/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.stag;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.census.workers.CircuitType;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.census.workers.SiblingMode;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.roles.RoleRelationWorker;
import org.tip.puck.net.relations.workers.RelationModelReporter;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.net.workers.ControlReporter;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.stag.CountAndRate;
import org.tip.puck.stag.StatisticTag;
import org.tip.puck.statistics.GenderedDouble;
import org.tip.puck.statistics.GenderedInt;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.IntWithMax;
import org.tip.puck.util.MathUtils;

public class Stag {
    private static final Logger logger = LoggerFactory.getLogger(Stag.class);
    public static final int GENEALOGY_GRAPHIC_WIDTH = 400;
    public static final int GENEALOGY_GRAPHIC_HEIGHT = 240;
    public static final String CROSS_FIRST_COUSIN_MARRIAGE_PATTERN = "XF(X)HX";
    public static final String LEVIRATE_MARRIAGE_PATTERN = "X(X)X.F";
    public static final String SORORATE_MARRIAGE_PATTERN = "X(X)X.H";
    public static final String DOUBLE_OR_EXCHANGE_MARRIAGE_PATTERN = "X(X)X.X(X)X";
    public static final String NIECE_NEPHEW_MARRIAGE_PATTERN = "X(X)XX";
    public static final String PARALLEL_FIRST_COUSIN_MARRIAGE_PATTERN = "XH(X)HX XF(X)FX";
    public static final String FIRST_COUSIN_MARRIAGE_PATTERN = "XX(X)XX";
    public static final String DOUBLE_MARRIAGE_PATTERN = "H(X)H.F(X)F";
    public static final String EXCHANGE_MARRIAGE_PATTERN = "H(X)F.H(X)F";

    public static CountAndRate analyzeCircuitCensus(String pattern, Net source) throws PuckException {
        CensusCriteria criteria = new CensusCriteria();
        criteria.setPattern(pattern);
        criteria.setClosingRelation("SPOUSE");
        criteria.setChainClassification("SIMPLE");
        criteria.setCircuitType(CircuitType.CIRCUIT);
        criteria.setFiliationType(FiliationType.COGNATIC);
        criteria.setRestrictionType(RestrictionType.NONE);
        criteria.setSiblingMode(SiblingMode.FULL);
        criteria.setSymmetryType(SymmetryType.PERMUTABLE);
        CircuitFinder finder = new CircuitFinder(new Segmentation(source), criteria);
        finder.findCircuits();
        finder.count();
        long count = finder.getCircuitCoupleCount();
        double density = finder.getCircuitCoupleDensity();
        CountAndRate result = new CountAndRate(count, density);
        return result;
    }

    public static AttributeDescriptors buildAttributeDescriptorStatistics(Net source) {
        AttributeDescriptors result;
        try {
            result = AttributeWorker.getExogenousAttributeDescriptors(source, null).sort();
        }
        catch (Exception exception) {
            logger.warn("ERROR IN STAG REFRESHING", (Throwable)exception);
            result = new AttributeDescriptors();
        }
        logger.debug("Done.");
        return result;
    }

    public static Properties buildBasicStatistics(Net source) {
        Properties result;
        block10: {
            result = new Properties();
            try {
                int errorCount = 0;
                if (source == null) break block10;
                Chronometer chrono = new Chronometer().start();
                result.put(StatisticTag.NUM_OF_INDIVIDUALS.name(), (Object)source.individuals().size());
                GenderedInt genders = StatisticsWorker.genderDistribution(source.individuals());
                result.put(StatisticTag.NUM_OF_MEN.name(), (Object)genders.getMenValue());
                result.put(StatisticTag.NUM_OF_WOMEN.name(), (Object)genders.getWomenValue());
                result.put(StatisticTag.NUM_OF_UNKNOWN.name(), (Object)genders.getUnknownValue());
                GenderedDouble percentages = StatisticsWorker.genderPercentageDistribution(genders);
                result.put(StatisticTag.RATE_OF_MEN.name(), (Object)percentages.getMenValue());
                result.put(StatisticTag.RATE_OF_WOMEN.name(), (Object)percentages.getWomenValue());
                result.put(StatisticTag.RATE_OF_UNKNOWN.name(), (Object)percentages.getUnknownValue());
                result.put(StatisticTag.NUM_OF_UNIONS.name(), (Object)StatisticsWorker.numberOfPartnerships(source.families()));
                int marriageCount = StatisticsWorker.numberOfMarriages(source.families());
                result.put(StatisticTag.NUM_OF_MARRIAGES.name(), (Object)marriageCount);
                result.put(StatisticTag.DENSITY_OF_MARRIAGES.name(), (Object)StatisticsWorker.densityOfMarriages(marriageCount, source.individuals().size()));
                result.put(StatisticTag.NUM_OF_NON_SINGLE_MEN.name(), (Object)StatisticsWorker.numberOfNotSingles(source.individuals(), Gender.MALE));
                result.put(StatisticTag.NUM_OF_NON_SINGLE_WOMEN.name(), (Object)StatisticsWorker.numberOfNotSingles(source.individuals(), Gender.FEMALE));
                result.put(StatisticTag.NUM_OF_RELATION_MODELS.name(), (Object)source.relationModels().size());
                result.put(StatisticTag.NUM_OF_RELATIONS.name(), (Object)source.relations().size());
                int filiationCount = StatisticsWorker.numberOfFiliationTies(source.families());
                result.put(StatisticTag.NUM_OF_PARENT_CHILD_TIES.name(), (Object)filiationCount);
                result.put(StatisticTag.DENSITY_OF_FILIATION.name(), (Object)StatisticsWorker.densityOfFiliations(filiationCount, source.individuals().size()));
                int numberOfFertileMarriages = StatisticsWorker.numberOfFertileMarriages(source.families());
                result.put(StatisticTag.NUM_OF_FERTILE_MARRIAGES.name(), (Object)numberOfFertileMarriages);
                result.put(StatisticTag.RATE_OF_FERTILE_MARRIAGES.name(), (Object)MathUtils.percent(numberOfFertileMarriages, marriageCount));
                result.put(StatisticTag.NUM_OF_COWIFE_RELATIONS.name(), (Object)StatisticsWorker.numberOfCoSpouseRelations(source.individuals(), Gender.FEMALE));
                result.put(StatisticTag.NUM_OF_COHUSBAND_RELATIONS.name(), (Object)StatisticsWorker.numberOfCoSpouseRelations(source.individuals(), Gender.MALE));
                IntWithMax component = null;
                try {
                    component = StatisticsWorker.numberOfComponents(source.individuals());
                    result.put(StatisticTag.NUM_OF_COMPONENTS.name(), (Object)component.value());
                    result.put(StatisticTag.MAX_OF_COMPONENTS.name(), (Object)component.max());
                }
                catch (Exception exception) {
                    logger.warn("Error on components.", (Throwable)exception);
                    ++errorCount;
                }
                try {
                    Partition<Individual> agnaticPartition = PartitionMaker.createRaw("PATRIC partition", source.individuals(), "PATRIC", null);
                    result.put(StatisticTag.MEAN_OF_COMPONENTS_SHARE_AGNATIC.name(), (Object)agnaticPartition.meanShare());
                    result.put(StatisticTag.MEAN_OF_COMPONENTS_SHARE_AGNATIC_WO_SINGLETON.name(), (Object)agnaticPartition.meanShare(2));
                    result.put(StatisticTag.MAX_OF_COMPONENTS_SHARE_AGNATIC.name(), (Object)agnaticPartition.maxShare());
                }
                catch (PuckException exception) {
                    logger.warn("Error on PartitionMaker.", (Throwable)exception);
                    ++errorCount;
                }
                try {
                    Partition<Individual> uterinePartition = PartitionMaker.createRaw("MATRIC partition", source.individuals(), "MATRIC", null);
                    result.put(StatisticTag.MEAN_OF_COMPONENTS_SHARE_UTERINE.name(), (Object)uterinePartition.meanShare());
                    result.put(StatisticTag.MEAN_OF_COMPONENTS_SHARE_UTERINE_WO_SINGLETON.name(), (Object)uterinePartition.meanShare(2));
                    result.put(StatisticTag.MAX_OF_COMPONENTS_SHARE_UTERINE.name(), (Object)uterinePartition.maxShare());
                }
                catch (PuckException exception) {
                    logger.warn("Error on PartitionMaker.", (Throwable)exception);
                    ++errorCount;
                }
                result.put(StatisticTag.NUM_OF_ELEMENTARY_CYCLES.name(), (Object)StatisticsWorker.cyclomatic(marriageCount, filiationCount, source.individuals().size(), component.value()));
                try {
                    Chronometer chronoBis = new Chronometer();
                    result.put(StatisticTag.DEPTH.name(), (Object)StatisticsWorker.depth(source.individuals()));
                    result.put(StatisticTag.DEPTH_MEAN.name(), (Object)StatisticsWorker.meanDepth(source.individuals()));
                }
                catch (Exception exception) {
                    logger.warn("Error on depth.", (Throwable)exception);
                    ++errorCount;
                }
                result.put(StatisticTag.MEAN_SPOUSE_OF_MEN.name(), (Object)StatisticsWorker.meanNumberOfSpouses(source.individuals(), Gender.MALE));
                result.put(StatisticTag.MEAN_SPOUSE_OF_WOMEN.name(), (Object)StatisticsWorker.meanNumberOfSpouses(source.individuals(), Gender.FEMALE));
                result.put(StatisticTag.MEAN_AGNATIC_FRATRY_SIZE.name(), (Object)StatisticsWorker.meanSibsetSize(source.individuals(), Gender.MALE));
                result.put(StatisticTag.MEAN_UTERINE_FRATRY_SIZE.name(), (Object)StatisticsWorker.meanSibsetSize(source.individuals(), Gender.FEMALE));
                result.put(StatisticTag.MEAN_CHILDREN_PER_FERTILE_COUPLE.name(), (Object)StatisticsWorker.meanSibsetSize(source.families()));
                logger.debug("Total Time: {}s", (Object)(chrono.stop().interval() / 1000L));
                result.put(StatisticTag.BASIC_GSTATISTICS_ERROR.name(), (Object)errorCount);
            }
            catch (Exception exception) {
                logger.warn("ERROR IN basic statistics building.", (Throwable)exception);
            }
        }
        logger.debug("Done.");
        return result;
    }

    public static Properties buildBasicStatistics(RelationModel source) {
        Properties result = new Properties();
        try {
            int errorCount = 0;
            if (source != null) {
                RoleRelationWorker worker = new RoleRelationWorker(source, 2);
                result.put(StatisticTag.SELF_NAME.name(), worker.getRelations().getSelfName());
                result.put(StatisticTag.NUM_OF_TERMS.name(), (Object)worker.getTerms().size());
                result.put(StatisticTag.NUM_OF_FEMALES.name(), (Object)worker.getTermsByGender(Gender.FEMALE).size());
                result.put(StatisticTag.NUM_OF_FEMALES_EXCLUSIVE.name(), (Object)worker.getTermsByExclusiveGender(Gender.FEMALE).size());
                result.put(StatisticTag.NUM_OF_FEMALES_SPEAKER.name(), (Object)worker.getTermsByEgoGender(Gender.FEMALE).size());
                result.put(StatisticTag.NUM_OF_FEMALES_SPEAKER_EXCLUSIVE.name(), (Object)worker.getTermsByExclusiveEgoGender(Gender.FEMALE).size());
                result.put(StatisticTag.NUM_OF_MALES.name(), (Object)worker.getTermsByGender(Gender.MALE).size());
                result.put(StatisticTag.NUM_OF_MALES_EXCLUSIVE.name(), (Object)worker.getTermsByExclusiveGender(Gender.MALE).size());
                result.put(StatisticTag.NUM_OF_MALES_SPEAKER.name(), (Object)worker.getTermsByEgoGender(Gender.MALE).size());
                result.put(StatisticTag.NUM_OF_MALES_SPEAKER_EXCLUSIVE.name(), (Object)worker.getTermsByExclusiveEgoGender(Gender.MALE).size());
                result.put(StatisticTag.GENERATION_PATTERN_FEMALE.name(), worker.getGenerationPatterns()[1]);
                result.put(StatisticTag.GENERATION_PATTERN_MALE.name(), worker.getGenerationPatterns()[0]);
                result.put(StatisticTag.GENERATION_PATTERN_TOTAL.name(), worker.getGenerationPatterns()[3]);
                result.put(StatisticTag.NUM_OF_AUTORECIPROCAL_TERMS.name(), (Object)worker.getAutoReciprocalRoles().size());
                result.put(StatisticTag.RECURSIVE_TERMS.name(), worker.getRecursiveRolePattern());
                result.put(StatisticTag.ASCENDANT_CLASSIFICATION.name(), worker.getCollateralClassification()[0].name());
                result.put(StatisticTag.COUSIN_CLASSIFICATION.name(), worker.getCollateralClassification()[1].name());
                result.put(StatisticTag.KIN_TERM_NETWORK_FEMALE_COMPONENTS.name(), (Object)worker.getGraphStatistics(Gender.FEMALE, "NRCOMPONENTS").intValue());
                result.put(StatisticTag.KIN_TERM_NETWORK_FEMALE_CONCENTRATION.name(), (Object)worker.getGraphStatistics(Gender.FEMALE, "CONCENTRATION").doubleValue());
                result.put(StatisticTag.KIN_TERM_NETWORK_FEMALE_SPEAKER_DENSITY.name(), (Object)worker.getGraphStatistics(Gender.FEMALE, "DENSITY").doubleValue());
                result.put(StatisticTag.KIN_TERM_NETWORK_FEMALE_SPEAKER_MEAN_CLUSTERING_COEFFICIENT.name(), (Object)worker.getGraphStatistics(Gender.FEMALE, "MEANCLUSTERINGCOEFF").doubleValue());
                result.put(StatisticTag.KIN_TERM_NETWORK_FEMALE_SPEAKER_MEAN_DEGREE.name(), (Object)worker.getGraphStatistics(Gender.FEMALE, "MEANDEGREE").doubleValue());
                result.put(StatisticTag.KIN_TERM_NETWORK_MALE_COMPONENTS.name(), (Object)worker.getGraphStatistics(Gender.MALE, "NRCOMPONENTS").intValue());
                result.put(StatisticTag.KIN_TERM_NETWORK_MALE_CONCENTRATION.name(), (Object)worker.getGraphStatistics(Gender.MALE, "CONCENTRATION").doubleValue());
                result.put(StatisticTag.KIN_TERM_NETWORK_MALE_SPEAKER_DENSITY.name(), (Object)worker.getGraphStatistics(Gender.MALE, "DENSITY").doubleValue());
                result.put(StatisticTag.KIN_TERM_NETWORK_MALE_SPEAKER_MEAN_CLUSTERING_COEFFICIENT.name(), (Object)worker.getGraphStatistics(Gender.MALE, "MEANCLUSTERINGCOEFF").doubleValue());
                result.put(StatisticTag.KIN_TERM_NETWORK_MALE_SPEAKER_MEAN_DEGREE.name(), (Object)worker.getGraphStatistics(Gender.MALE, "MEANDEGREE").doubleValue());
                result.put(StatisticTag.BASIC_TSTATISTICS_ERROR.name(), (Object)errorCount);
            }
        }
        catch (Exception exception) {
            logger.warn("ERROR IN STAG REFRESHING", (Throwable)exception);
        }
        logger.debug("Done.");
        return result;
    }

    public static Properties buildCircuitStatistics(Net source) {
        Properties result;
        block20: {
            result = new Properties();
            try {
                CountAndRate data;
                int errorCount = 0;
                if (source == null) break block20;
                Chronometer chrono = new Chronometer().start();
                try {
                    data = Stag.analyzeCircuitCensus(CROSS_FIRST_COUSIN_MARRIAGE_PATTERN, source);
                    result.put(StatisticTag.NUM_OF_CROSS_FIRST_COUSIN_MARRIAGES.name(), (Object)data.getCount());
                    result.put(StatisticTag.RATE_OF_CROSS_FIRST_COUSIN_MARRIAGES.name(), (Object)data.getRate());
                }
                catch (Exception exception) {
                    logger.error("Error on cross first cousin marriages.", (Throwable)exception);
                    ++errorCount;
                }
                try {
                    chrono.reset();
                    data = Stag.analyzeCircuitCensus(LEVIRATE_MARRIAGE_PATTERN, source);
                    result.put(StatisticTag.NUM_OF_LEVIRATE_MARRIAGES.name(), (Object)data.getCount());
                    result.put(StatisticTag.RATE_OF_LEVIRATE_MARRIAGES.name(), (Object)data.getRate());
                }
                catch (Exception exception) {
                    logger.error("Error on levirate marriages.", (Throwable)exception);
                    ++errorCount;
                }
                try {
                    chrono.reset();
                    data = Stag.analyzeCircuitCensus(SORORATE_MARRIAGE_PATTERN, source);
                    result.put(StatisticTag.NUM_OF_SORORATE_MARRIAGES.name(), (Object)data.getCount());
                    result.put(StatisticTag.RATE_OF_SORORATE_MARRIAGES.name(), (Object)data.getRate());
                }
                catch (Exception exception) {
                    logger.error("Error on sororate marriages.", (Throwable)exception);
                    ++errorCount;
                }
                try {
                    chrono.reset();
                    data = Stag.analyzeCircuitCensus(DOUBLE_OR_EXCHANGE_MARRIAGE_PATTERN, source);
                    result.put(StatisticTag.NUM_OF_DOUBLE_OR_EXCHANGE_MARRIAGES.name(), (Object)data.getCount());
                    result.put(StatisticTag.RATE_OF_DOUBLE_OR_EXCHANGE_MARRIAGES.name(), (Object)data.getRate());
                }
                catch (Exception exception) {
                    logger.error("Error on double or exchange marriages.", (Throwable)exception);
                    ++errorCount;
                }
                try {
                    chrono.reset();
                    data = Stag.analyzeCircuitCensus(NIECE_NEPHEW_MARRIAGE_PATTERN, source);
                    result.put(StatisticTag.NUM_OF_NIECE_NEPHEW_MARRIAGES.name(), (Object)data.getCount());
                    result.put(StatisticTag.RATE_OF_NIECE_NEPHEW_MARRIAGES.name(), (Object)data.getRate());
                }
                catch (Exception exception) {
                    logger.error("Error on Niece/Nephew marriages.", (Throwable)exception);
                    ++errorCount;
                }
                try {
                    chrono.reset();
                    data = Stag.analyzeCircuitCensus(PARALLEL_FIRST_COUSIN_MARRIAGE_PATTERN, source);
                    result.put(StatisticTag.NUM_OF_PARALLEL_FIRST_COUSIN_MARRIAGES.name(), (Object)data.getCount());
                    result.put(StatisticTag.RATE_OF_PARALLEL_FIRST_COUSIN_MARRIAGES.name(), (Object)data.getRate());
                }
                catch (Exception exception) {
                    logger.error("Error on parallel first cousin marriages.", (Throwable)exception);
                    ++errorCount;
                }
                try {
                    chrono.reset();
                    data = Stag.analyzeCircuitCensus(FIRST_COUSIN_MARRIAGE_PATTERN, source);
                    result.put(StatisticTag.NUM_OF_FIRST_COUSIN_MARRIAGES.name(), (Object)data.getCount());
                    result.put(StatisticTag.RATE_OF_FIRST_COUSIN_MARRIAGES.name(), (Object)data.getRate());
                }
                catch (Exception exception) {
                    logger.error("Error on first cousin marriages.", (Throwable)exception);
                    ++errorCount;
                }
                try {
                    chrono.reset();
                    data = Stag.analyzeCircuitCensus(DOUBLE_MARRIAGE_PATTERN, source);
                    result.put(StatisticTag.NUM_OF_DOUBLE_MARRIAGES.name(), (Object)data.getCount());
                    result.put(StatisticTag.RATE_OF_DOUBLE_MARRIAGES.name(), (Object)data.getRate());
                }
                catch (Exception exception) {
                    logger.error("Error on double marriages.", (Throwable)exception);
                    ++errorCount;
                }
                try {
                    chrono.reset();
                    data = Stag.analyzeCircuitCensus(EXCHANGE_MARRIAGE_PATTERN, source);
                    result.put(StatisticTag.NUM_OF_EXCHANGE_MARRIAGES.name(), (Object)data.getCount());
                    result.put(StatisticTag.RATE_OF_EXCHANGE_MARRIAGES.name(), (Object)data.getRate());
                }
                catch (Exception exception) {
                    logger.error("Error on exchange marriages.", (Throwable)exception);
                    ++errorCount;
                }
                result.put(StatisticTag.BASIC_GSTATISTICS_ERROR.name(), (Object)errorCount);
            }
            catch (Exception exception) {
                logger.warn("ERROR IN basic statistics building.", (Throwable)exception);
            }
        }
        logger.debug("Done.");
        return result;
    }

    public static Properties buildControlStatistics(Net source) {
        Properties result = new Properties();
        try {
            ControlReporter.ControlType[] controlTypeArray = ControlReporter.ControlType.values();
            int n = controlTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ControlReporter.ControlType type = controlTypeArray[n2];
                Report report = ControlReporter.reportControls(source, null, new ControlReporter.ControlType[]{type});
                if (report != null) {
                    result.put(type.name(), (Object)report.status());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("ERRRORRRR");
            exception.printStackTrace();
            logger.error("Error controls.", (Throwable)exception);
        }
        logger.debug("Done.");
        return result;
    }

    public static Properties buildControlStatistics(RelationModel source) {
        Properties result = new Properties();
        try {
            RelationModelReporter.ControlType[] controlTypeArray = RelationModelReporter.ControlType.values();
            int n = controlTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RelationModelReporter.ControlType type = controlTypeArray[n2];
                Report report = RelationModelReporter.reportControl(source, type);
                if (report != null) {
                    result.put(type.name(), (Object)report.status());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            logger.error("Error controls.", (Throwable)exception);
        }
        logger.debug("Done.");
        return result;
    }

    public static Properties buildGeographyStatistics(Net source) {
        Properties result = new Properties();
        try {
            if (source != null) {
                result.put(StatisticTag.GEOGRAPHY_AVAILABLE.name(), (Object)(source.getGeography() != null ? 1 : 0));
            }
        }
        catch (Exception exception) {
            logger.warn("ERROR IN geography statistics building.", (Throwable)exception);
        }
        logger.debug("Done.");
        return result;
    }
}

