/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences.workers;

import org.tip.puck.PuckException;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.ExpansionMode;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.sequences.EgoSequence;
import org.tip.puck.sequences.EgoSequences;
import org.tip.puck.sequences.Ordinal;
import org.tip.puck.sequences.Sequence;
import org.tip.puck.sequences.SequenceType;
import org.tip.puck.sequences.Sequences;
import org.tip.puck.sequences.workers.SequenceCriteria;

public class SequenceMaker {
    public static EgoSequence createSequence(Individual ego, SequenceCriteria criteria) {
        EgoSequence result = new EgoSequence(ego);
        result.putInOrder(ego.relations(), SequenceType.MOVES);
        return result;
    }

    public static EgoSequence createPersonalEventSequence(Individual ego, Segmentation segmentation, SequenceCriteria criteria) {
        String egoRoleName = criteria.getEgoRoleName();
        EgoSequence result = new EgoSequence(ego);
        Relations relations = new Relations();
        for (Relation relation : ego.relations()) {
            if (!segmentation.getCurrentRelations().contains(relation) || !relation.getRoleNames(ego).contains(egoRoleName)) continue;
            relations.add(relation);
        }
        result.putInOrder(relations, SequenceType.EVENTS);
        return result;
    }

    public static EgoSequences createPersonalSequences(Segmentation segmentation, SequenceCriteria criteria) {
        EgoSequences result = new EgoSequences();
        for (Individual individual : segmentation.getCurrentIndividuals().toSortedList()) {
            result.add(SequenceMaker.createPersonalEventSequence(individual, segmentation, criteria));
        }
        return result;
    }

    public static EgoSequences createBiographies(Net net, Segmentation segmentation, SequenceCriteria criteria) throws PuckException {
        EgoSequences result = new EgoSequences();
        net.getFamilyEvents(segmentation);
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            result.add(SequenceMaker.createSequence(individual, criteria));
        }
        net.removeFamilyEvents();
        return result;
    }

    public static EgoSequence createExtendedSequence(Individual individual, SequenceCriteria criteria) {
        EgoSequence result = new EgoSequence(individual);
        result.putInOrder(individual.relations(), SequenceType.EVENTS);
        ExpansionMode expansionMode = criteria.getExpansionMode();
        FiliationType filiationType = criteria.getFiliationType();
        for (Individual relative : NetUtils.neighbors(individual, expansionMode, filiationType)) {
            result.putInOrder(relative.relations(), SequenceType.EVENTS);
        }
        return result;
    }

    public static EgoSequences createExtendedBiographies(Net net, Segmentation segmentation, SequenceCriteria criteria) throws PuckException {
        EgoSequences result = new EgoSequences();
        net.getFamilyEvents(segmentation);
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            result.add(SequenceMaker.createExtendedSequence(individual, criteria));
        }
        net.removeFamilyEvents();
        return result;
    }

    public static Sequences<Sequence<Relation>, Relation> createRelationSequences(Segmentation segmentation, SequenceCriteria criteria) {
        Sequences<Sequence<Relation>, Relation> result = new Sequences<Sequence<Relation>, Relation>();
        int id = 0;
        for (Relation station : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName())) {
            String stringTime;
            String stringId = station.getAttributeValue(criteria.getLocalUnitLabel());
            id = stringId != null ? Integer.parseInt(stringId) : 0;
            Sequence<Relation> sequence = (Sequence<Relation>)result.getById(id);
            if (sequence == null) {
                sequence = new Sequence<Relation>(criteria.getLocalUnitLabel(), id);
                result.put(sequence);
            }
            if ((stringTime = station.getAttributeValue(criteria.getDateLabel())) == null) continue;
            int time = Integer.parseInt(stringTime);
            if (sequence.getStation(new Ordinal(time)) == null) {
                sequence.put(new Ordinal(time), station.ageFiltered(criteria.getMinAge(), time));
                continue;
            }
            System.err.println("Ambigous local unit label: " + criteria.getLocalUnitLabel() + " " + sequence.getStation(new Ordinal(time)) + " vs " + station);
        }
        return result;
    }

    public static Sequence<Relations> createRelationSetSequence(Segmentation segmentation, SequenceCriteria criteria) throws PuckException {
        Sequence<Relations> result = new Sequence<Relations>(criteria.getLocalUnitLabel(), 0);
        Integer[] integerArray = criteria.getDates();
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            int time = integerArray[n2];
            Relations relations = new Relations();
            relations.setId(time);
            result.put(new Ordinal(time), relations);
            ++n2;
        }
        for (Relation relation : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName()).getByAttribute(criteria.getLocalUnitLabel(), null)) {
            Integer time = relation.getTime(criteria.getDateLabel());
            if (time == null || !result.getTimes().contains(new Ordinal(time))) continue;
            result.getStation(new Ordinal(time)).put(relation);
        }
        return result;
    }

    public static EgoSequence createPersonalStateSequence(Individual individual, Segmentation segmentation, SequenceCriteria sequenceCriteria) {
        EgoSequence result = new EgoSequence(individual);
        for (Ordinal time : Ordinal.getOrdinals(sequenceCriteria.getDates())) {
            Relation relation;
            if (sequenceCriteria.getMaxAge() < 1000 && IndividualValuator.ageAtYear(individual, time.getYear()) >= sequenceCriteria.getMaxAge() || sequenceCriteria.getMinAge() > 0 && IndividualValuator.ageAtYear(individual, time.getYear()) < sequenceCriteria.getMinAge() || (relation = (Relation)individual.relations().getByModelName(sequenceCriteria.getRelationModelName()).getByTime(sequenceCriteria.getDateLabel(), time.getYear()).getFirst()) == null || !segmentation.getCurrentRelations().contains(relation) || !relation.getRoleNames(individual).contains(sequenceCriteria.getEgoRoleName())) continue;
            result.put(time, relation);
        }
        return result;
    }
}

