/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individualizable;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.RelationValuator;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.sequences.EventComparator;
import org.tip.puck.sequences.Ordinal;
import org.tip.puck.sequences.Sequence;
import org.tip.puck.sequences.SequenceType;
import org.tip.puck.sequences.Sequenceable;
import org.tip.puck.sequences.workers.SequenceCriteria;
import org.tip.puck.util.Numberable;

public class EgoSequence
extends Sequence<Relation>
implements Individualizable,
Sequenceable<Relation> {
    Individual ego;

    public EgoSequence(Individual ego) {
        this.ego = ego;
        this.id = ego.getId();
    }

    public EgoSequence(Individual ego, int id) {
        this.ego = ego;
        this.id = id;
    }

    @Override
    public Individual getEgo() {
        return this.ego;
    }

    @Override
    public String getLabel() {
        return this.ego.signature();
    }

    public <S extends Sequenceable<E>, E extends Numberable> EgoSequence(S sequence) {
        this.ego = new Individual(sequence.getId(), sequence.getLabel(), Gender.UNKNOWN);
        this.id = sequence.getId();
        this.idLabel = sequence.idLabel();
        for (Ordinal time : sequence.getTimes()) {
            this.stations.put(time, (Relation)sequence.getStation(time));
        }
    }

    public Integer getEgoAge(Integer year) {
        Integer result = year != null ? IndividualValuator.ageAtYear(this.ego, year) : null;
        return result;
    }

    @Override
    public EgoSequence clone() {
        EgoSequence result = new EgoSequence(this.ego, this.id);
        for (Ordinal key : this.stations.keySet()) {
            result.put(key, (Relation)this.getStation(key));
        }
        return result;
    }

    @Override
    public EgoSequence clone(int id) {
        EgoSequence result = this.clone();
        result.setId(id);
        return result;
    }

    public void putInOrder(Relations events, SequenceType type) {
        SequenceCriteria criteria = new SequenceCriteria();
        ArrayList<Relation> orderedEvents = new ArrayList<Relation>();
        for (Relation event : events) {
            String startPlace = event.getAttributeValue(criteria.getStartPlaceLabel());
            String endPlace = event.getAttributeValue(criteria.getEndPlaceLabel());
            if (type == SequenceType.MOVES && (startPlace == null || endPlace == null)) continue;
            if (startPlace == null && endPlace == null) {
                startPlace = event.getAttributeValue("PLACE");
                endPlace = event.getAttributeValue("PLACE");
            }
            if (startPlace == null && endPlace == null) continue;
            orderedEvents.add(event);
        }
        Collections.sort(orderedEvents, new EventComparator(criteria));
        for (Relation event : orderedEvents) {
            this.stations.put(new Ordinal(String.valueOf(event.getId()), this.stations.size(), RelationValuator.getYear(event)), event);
        }
    }

    public Integer getOrder(Relation event) {
        Integer result = null;
        for (Actor actor : event.actors().getById(this.ego.getId())) {
            String orderString = actor.getAttributeValue("ORDER");
            if (!StringUtils.isNumeric((CharSequence)orderString)) continue;
            result = Integer.parseInt(orderString);
            break;
        }
        return result;
    }
}

