/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.partitions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Individual;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportTable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;

public class PartitionReporter {
    private static final Logger logger = LoggerFactory.getLogger(PartitionReporter.class);

    public static ReportChart createClusterDistributionChart(Map<Integer, Integer> clusterSizeDistribution, String label) throws PuckException {
        ReportChart result;
        if (clusterSizeDistribution == null) {
            result = null;
        } else {
            result = new ReportChart(label, ReportChart.GraphType.STACKED_BARS);
            int clusterIndex = 0;
            for (Integer size : clusterSizeDistribution.keySet()) {
                result.setHeader("" + size, clusterIndex);
                result.addValue(clusterSizeDistribution.get(size).intValue(), 0);
                ++clusterIndex;
            }
        }
        return result;
    }

    public static <E> Report reportPartitionStatistics(Segmentation segmentation, StatisticsCriteria criteria) throws PuckException {
        if (segmentation == null || criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report();
        Chronometer chrono = new Chronometer();
        result.setTitle("Basic partition statistics.");
        result.setOrigin("Partition reporter");
        result.setTarget(segmentation.getLabel());
        if (segmentation.isOn()) {
            result.setInputComment("Segmentation:\n" + segmentation.getSummary());
        }
        ArrayList<ReportChart> charts = new ArrayList<ReportChart>(20);
        ArrayList<ReportTable> sourceTables = new ArrayList<ReportTable>(20);
        HashMap<ReportTable, ReportTable> tables = new HashMap<ReportTable, ReportTable>(20);
        HashMap<ReportTable, Double> meanValues = new HashMap<ReportTable, Double>(20);
        HashMap<ReportTable, Double> medianValues = new HashMap<ReportTable, Double>(20);
        HashMap<ReportTable, Integer> nrClusters = new HashMap<ReportTable, Integer>(20);
        HashMap<ReportTable, Integer> nrItems = new HashMap<ReportTable, Integer>(20);
        for (PartitionCriteria partitionCriteria : criteria.getPartitionCriteriaList()) {
            if (StringUtils.isEmpty((CharSequence)partitionCriteria.getLabel())) continue;
            Partition<Individual> partition = PartitionMaker.create(segmentation.getLabel(), segmentation.getCurrentIndividuals(), partitionCriteria, segmentation.getGeography());
            ReportChart sourceChart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria(), segmentation.getGeography());
            ReportTable sourceTable = ReportTable.transpose(sourceChart.createReportTableWithSum());
            sourceTables.add(sourceTable);
            TreeMap<Integer, Integer> clusterSizeDistribution = ReportTable.columnSizeDistribution(sourceTable);
            ReportChart chart = PartitionReporter.createClusterDistributionChart(clusterSizeDistribution, partition.getCriteriaLabel());
            if (chart == null) continue;
            charts.add(chart);
            ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
            tables.put(sourceTable, table);
            meanValues.put(sourceTable, MathUtils.meanValue(clusterSizeDistribution));
            medianValues.put(sourceTable, MathUtils.medianValue(clusterSizeDistribution));
            nrClusters.put(sourceTable, partition.nonNullClusterCount());
            nrItems.put(sourceTable, partition.clusteredItemsCount());
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            result.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                result.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable sourceTable : sourceTables) {
            result.outputs().appendln(sourceTable.getTitle());
            result.outputs().appendln();
            ReportTable table = (ReportTable)tables.get(sourceTable);
            result.outputs().appendln("number of (nonnull) clusters =" + nrClusters.get(sourceTable));
            result.outputs().appendln("number of clustered items =" + nrItems.get(sourceTable));
            result.outputs().appendln("mean =" + meanValues.get(sourceTable));
            result.outputs().appendln("median =" + medianValues.get(sourceTable));
            result.outputs().appendln(table);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

