/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.Arrays;
import org.tip.puck.net.Individual;
import org.tip.puck.net.KinType;

public class BicomponentEdge {
    private Individual source;
    private Individual target;
    private KinType kinType;
    private int back;

    public BicomponentEdge(Individual source, Individual target, KinType kinType, int back) {
        this.source = source;
        this.target = target;
        this.kinType = kinType;
        this.back = back;
    }

    public boolean equals(Object o) {
        return Arrays.equals(this.getKey(), ((BicomponentEdge)o).getKey());
    }

    public Individual getTarget() {
        return this.target;
    }

    public Individual getSource() {
        return this.source;
    }

    private int[] getKey() {
        int[] key = new int[]{this.source.getId(), this.target.getId()};
        return key;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getKey());
    }

    private BicomponentEdge inverse() {
        BicomponentEdge result = new BicomponentEdge(this.target, this.source, this.invType(), this.back);
        return result;
    }

    public BicomponentEdge adjusted(Individual ego) {
        BicomponentEdge result = ego == this.source ? this : (ego == this.target ? this.inverse() : null);
        return result;
    }

    private KinType invType() {
        KinType result;
        switch (this.kinType) {
            case SPOUSE: {
                result = KinType.SPOUSE;
                break;
            }
            case CHILD: {
                result = KinType.PARENT;
                break;
            }
            case PARENT: {
                result = KinType.CHILD;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public KinType getKinType() {
        return this.kinType;
    }

    public int getBack() {
        return this.back;
    }

    public String toString() {
        return this.source + " " + this.target + " " + (Object)((Object)this.kinType) + " " + this.back;
    }
}

