/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeFilter {
    private static final Logger logger = LoggerFactory.getLogger(AttributeFilter.class);
    private Scope scope;
    private String optionalRelationName;
    private String label;
    private Mode mode;

    public AttributeFilter() {
        this.scope = Scope.ALL;
        this.optionalRelationName = null;
        this.label = null;
        this.mode = Mode.NONE;
    }

    public AttributeFilter(Scope scope, String label, Mode mode) {
        this.scope = scope == null ? Scope.NONE : scope;
        this.label = label;
        this.mode = mode == null ? Mode.NONE : mode;
    }

    public AttributeFilter(String optionalRelationName, String label, Mode mode) {
        this.scope = Scope.RELATION;
        this.optionalRelationName = optionalRelationName;
        this.label = label;
        this.mode = mode == null ? Mode.NONE : mode;
    }

    public String getLabel() {
        return this.label;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getOptionalRelationName() {
        return this.optionalRelationName;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMode(Mode mode) {
        this.mode = mode == null ? Mode.NONE : mode;
    }

    public void setOptionalRelationName(String optionalRelationName) {
        this.optionalRelationName = optionalRelationName;
    }

    public void setScope(Scope scope) {
        this.scope = scope == null ? Scope.NONE : scope;
    }

    public String toString() {
        String result;
        if (this.getMode() == null || this.getMode() == Mode.NONE || this.getScope() == null || this.getScope() == Scope.NONE) {
            result = null;
        } else {
            String scopeLabel = this.getScope() == Scope.RELATION ? this.getOptionalRelationName() : this.getScope().name().toLowerCase();
            result = String.format("%s.%s=%s", scopeLabel, this.getLabel(), this.getMode().name().toLowerCase());
        }
        return result;
    }

    public static enum Mode {
        NONE,
        CLEAN_BLANK,
        CLEAN,
        REMOVE,
        REPLACE_BY_BLANK,
        FORCE_TO_BLANK,
        ANONYMIZE_BY_NUMBERING,
        ANONYMIZE_BY_CONSISTENT_NUMBERING,
        ANONYMIZE_BY_GENDER_AND_ID_HF,
        ANONYMIZE_BY_GENDER_AND_ID_MF,
        ANONYMIZE_BY_FIRST_NAME,
        ANONYMIZE_BY_LAST_NAME,
        REDUCE_DATE,
        ANONYMIZE_DATE,
        TRIM_VALUE,
        UPPERCASE_VALUE,
        LOWERCASE_VALUE,
        CAPITALIZE_VALUE;

    }

    public static enum Scope {
        NONE,
        ALL,
        CORPUS,
        INDIVIDUALS,
        FAMILIES,
        RELATION,
        RELATIONS,
        ACTORS;

    }
}

