/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles.io;

import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.ods.ODSBufferedReader;
import org.tip.puck.io.xls.XLSBufferedReader;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.roles.RoleRelationMaker;
import org.tip.puck.net.relations.roles.RoleRelationRules;
import org.tip.puck.net.relations.roles.io.IOTermsTools;
import org.tip.puck.report.Report;

public class EMICFile {
    private static final Logger logger = LoggerFactory.getLogger(EMICFile.class);
    public static String DEFAULT_CHARSET_NAME = "UTF-8";

    public static RelationModel load(File source, Report report, RoleRelationRules ruleConstraints) throws PuckException {
        RelationModel result;
        if (source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("File=[" + source + "].", new Object[0]);
        }
        if (!source.exists()) {
            throw PuckExceptions.FILE_NOT_FOUND.create("File=[" + source + "].", new Object[0]);
        }
        if (!source.isFile()) {
            throw PuckExceptions.NOT_A_FILE.create("File=[" + source + "].", new Object[0]);
        }
        String name = StringUtils.lowerCase((String)source.getName());
        if (name.endsWith(".emic.ods")) {
            result = EMICFile.loadFromEMICODSFile(source, report, ruleConstraints);
        } else if (name.endsWith(".emic.txt")) {
            result = EMICFile.loadFromEMICTXTFile(source, report, ruleConstraints);
        } else if (name.endsWith(".emic.xls")) {
            result = EMICFile.loadFromEMICXLSFile(source, report, ruleConstraints);
        } else {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + source + "].", new Object[0]);
        }
        return result;
    }

    public static RelationModel loadFromEMICODSFile(File file, Report report, RoleRelationRules ruleConstraints) throws PuckException {
        RelationModel result;
        ODSBufferedReader in = null;
        try {
            try {
                in = new ODSBufferedReader(file);
                result = EMICFile.readFromEMICTXTFile(in, report, ruleConstraints);
                result.setName(IOTermsTools.getBaseName(file, ".emic.ods"));
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (Exception exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "\nOpening file [" + file + "]\n[" + exception.getMessage() + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static RelationModel loadFromEMICTXTFile(File file, Report report, RoleRelationRules ruleConstraints) throws PuckException {
        RelationModel result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), DEFAULT_CHARSET_NAME));
                result = EMICFile.readFromEMICTXTFile(in, report, ruleConstraints);
                result.setName(IOTermsTools.getBaseName(file, ".emic.txt"));
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "\nOpening file [" + file + "]\n[" + exception.getMessage() + "]", new Object[0]);
            }
            catch (Exception exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "\nOpening file [" + file + "]\n[" + exception.getMessage() + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static RelationModel loadFromEMICXLSFile(File file, Report report, RoleRelationRules ruleConstraints) throws PuckException {
        RelationModel result;
        XLSBufferedReader in = null;
        try {
            try {
                in = new XLSBufferedReader(file);
                result = EMICFile.readFromEMICTXTFile(in, report, ruleConstraints);
                result.setName(IOTermsTools.getBaseName(file, ".emic.xls"));
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (Exception exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "\nOpening file [" + file + "]\n[" + exception.getMessage() + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static RelationModel readFromEMICTXTFile(BufferedReader in, Report report, RoleRelationRules ruleConstraints) throws PuckException {
        logger.debug("Read attributes.");
        Attributes attributes = new Attributes();
        IOTermsTools.readAttributesVertically(attributes, in);
        StringList lines = IOTermsTools.readTermRuleLines(in);
        String selfName = IOTermsTools.extractSelfName(attributes);
        RoleRelationRules rules = ruleConstraints == null ? IOTermsTools.extractRelationRoleRules(attributes) : ruleConstraints;
        report.outputs().appendln("Source reading");
        report.outputs().appendln();
        report.outputs().append("Self Name:\t\t").appendln(selfName);
        report.outputs().append("Role Relation Rules:\t").appendln(rules);
        report.outputs().appendln();
        RelationModel result = RoleRelationMaker.createEmic("default", selfName, lines, rules, report);
        return result;
    }
}

