/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import fr.devinsy.util.StringList;
import java.util.List;
import java.util.Map;
import org.tip.puck.net.Gender;
import org.tip.puck.net.KinType;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.roles.MetaRole;
import org.tip.puck.net.relations.roles.RoleDefinition;
import org.tip.puck.net.relations.roles.RoleDefinitions;
import org.tip.puck.net.relations.roles.RoleRelationWorker;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.report.Report;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class RoleRelationReporter {
    private static Report reportCompositions(RoleRelationWorker worker) {
        Report result = new Report("Compositions");
        result.outputs().appendln("Compositions (" + worker.getMaxIterations() + " iterations): Relation Model " + worker.getTitle());
        result.outputs().appendln();
        Map<Role, Map<Role, Roles>> compositions = worker.getCompositions();
        String headLine = "\u00b0";
        for (Role role : compositions.keySet()) {
            headLine = String.valueOf(headLine) + "\t" + role;
        }
        result.outputs().appendln(headLine);
        for (Role alpha : compositions.keySet()) {
            String compositionLine = alpha + "\t";
            Map<Role, Roles> map = compositions.get(alpha);
            for (Role beta : map.keySet()) {
                String cell = "";
                for (Role gamma : map.get(beta)) {
                    cell = cell.isEmpty() ? "" + gamma : String.valueOf(cell) + ";" + gamma;
                }
                compositionLine = String.valueOf(compositionLine) + cell + "\t";
            }
            result.outputs().appendln(compositionLine);
        }
        result.outputs().appendln();
        Map<KinType, Roles> recursiveRoles = worker.getRecursiveRoles();
        result.outputs().appendln(String.valueOf(recursiveRoles.get((Object)KinType.UNKNOWN).size()) + " Recursive terms");
        result.outputs().appendln();
        result.outputs().appendln(ToolBox.toLine(recursiveRoles.get((Object)KinType.UNKNOWN), "TOTAL", ": ", ";"));
        for (KinType kinType : KinType.basicTypesWithSiblings()) {
            Roles roles = recursiveRoles.get((Object)kinType);
            if (roles.isEmpty()) continue;
            result.outputs().appendln(ToolBox.toLine(roles, kinType.toString(), " (" + roles.size() + "): ", ";"));
        }
        return result;
    }

    private static Report reportReciprocals(RoleRelationWorker worker) {
        Report result = new Report("Reciprocals");
        result.outputs().appendln("Reciprocals: Relation Model " + worker.getTitle());
        result.outputs().appendln();
        String autoReciprocalLine = null;
        Map<Role, Roles> reciprocalRoles = worker.getReciprocalRoles();
        Roles autoReciprocalRoles = worker.getAutoReciprocalRoles();
        for (Role role : reciprocalRoles.keySet()) {
            String reciprocalLine = role + "\t";
            for (Role reciprocalRole : reciprocalRoles.get(role)) {
                reciprocalLine = reciprocalLine.equals(role + "\t") ? String.valueOf(reciprocalLine) + reciprocalRole : String.valueOf(reciprocalLine) + ";" + reciprocalRole;
            }
            result.outputs().appendln(reciprocalLine);
            if (!autoReciprocalRoles.contains(role)) continue;
            autoReciprocalLine = autoReciprocalLine == null ? "" + role : String.valueOf(autoReciprocalLine) + ";" + role;
        }
        result.outputs().appendln();
        if (autoReciprocalRoles.isEmpty()) {
            result.outputs().appendln("0 autoreciprocal terms");
        } else {
            result.outputs().appendln(String.valueOf(autoReciprocalRoles.size()) + " autoreciprocal terms:\t" + autoReciprocalLine);
        }
        return result;
    }

    private static Report reportNetwork(RoleRelationWorker worker) {
        Report result = new Report("Network");
        result.outputs().appendln("Kin Term Network Analysis: Relation Model " + worker.getTitle());
        result.outputs().appendln(worker.getRules());
        result.outputs().appendln();
        result.outputs().appendln(worker.getNetworkAnalysis());
        return result;
    }

    private static Report reportBasicCompositions(RoleRelationWorker worker) {
        Report result = new Report("Basic Compositions");
        result.outputs().appendln("Compositions: Relation Model " + worker.getTitle());
        result.outputs().appendln();
        Roles metaRoles = worker.getGenerators();
        String headLine = "SELF\t";
        for (Role role : metaRoles.toSortedList()) {
            if (role.getName().equals("SELF")) continue;
            headLine = String.valueOf(headLine) + role + "\t";
        }
        result.outputs().appendln(headLine);
        Map<Role, Partition<Role>> basicCompositions = worker.getBasicCompositions();
        for (Role self : basicCompositions.keySet()) {
            String roleLine = self + "\t";
            Partition<Role> partition = basicCompositions.get(self);
            for (Role role : metaRoles.toSortedList()) {
                if (((MetaRole)role).isSelf()) continue;
                Cluster<Role> cluster = partition.getCluster(new Value(role));
                roleLine = cluster != null ? String.valueOf(roleLine) + cluster.getItemsAsSortedString() + "\t" : String.valueOf(roleLine) + "\t";
            }
            result.outputs().appendln(roleLine);
        }
        return result;
    }

    private static Report reportDefinitions(RoleRelationWorker worker) {
        Report result = new Report("Definitions");
        result.outputs().appendln("Relation Model " + worker.getTitle());
        result.outputs().appendln();
        Map<Role, RoleDefinitions> roleDefininitionsByRole = worker.getRoleDefininitionsByRole();
        for (Role role : roleDefininitionsByRole.keySet()) {
            result.outputs().appendln(role);
            for (RoleDefinition definition : roleDefininitionsByRole.get(role)) {
                String emic = "";
                List<Role> emicList = worker.getEmicGenerator(definition).toSortedList();
                if (!emicList.isEmpty()) {
                    emic = emicList.toString();
                }
                result.outputs().appendln("\t" + definition.toString() + "\t" + emic);
            }
        }
        return result;
    }

    public static Report reportRoleRelations(RelationModel model, int maxIterations) {
        String title = model.getName();
        Report result = new Report("Terminology " + title);
        RoleRelationWorker worker = new RoleRelationWorker(model, maxIterations);
        result.outputs().append(RoleRelationReporter.reportBasicStatistics(worker));
        result.outputs().append(RoleRelationReporter.reportDetailedStatistics(worker));
        result.outputs().append(RoleRelationReporter.reportPositions(worker));
        result.outputs().append(RoleRelationReporter.reportDefinitions(worker));
        result.outputs().append(RoleRelationReporter.reportBasicCompositions(worker));
        result.outputs().append(RoleRelationReporter.reportCompositions(worker));
        result.outputs().append(RoleRelationReporter.reportReciprocals(worker));
        result.outputs().append(RoleRelationReporter.reportNetwork(worker));
        return result;
    }

    private static Report reportPositions(RoleRelationWorker worker) {
        Report result = new Report("Positions");
        result.outputs().appendln("Positions (" + worker.getMaxIterations() + " iterations): Relation Model " + worker.getTitle());
        result.outputs().appendln();
        Map<Role, StringList> positions = worker.getPositions();
        for (Role role : positions.keySet()) {
            String positionString = role.toString();
            for (String position : positions.get(role)) {
                positionString = positionString.equals(role.toString()) ? String.valueOf(positionString) + "\t" + position : String.valueOf(positionString) + ";" + position;
            }
            result.outputs().appendln(positionString);
        }
        return result;
    }

    private static Report reportBasicStatistics(RoleRelationWorker worker) {
        Report result = new Report("Overview");
        result.outputs().appendln("Relation Model " + worker.getTitle());
        result.outputs().appendln();
        result.outputs().appendln("Self term = " + worker.getRelations().getSelfName());
        result.outputs().appendln();
        result.outputs().appendln("Gender pattern:");
        result.outputs().appendln("Terms:\t" + worker.getTerms().size());
        result.outputs().appendln("Male\t" + worker.getTermsByGender(Gender.MALE).size() + "\t(" + worker.getTermsByExclusiveGender(Gender.MALE).size() + " excl.)");
        result.outputs().appendln("Female:\t" + worker.getTermsByGender(Gender.FEMALE).size() + "\t(" + worker.getTermsByExclusiveGender(Gender.FEMALE).size() + " excl.)");
        result.outputs().appendln("Male Speaker:\t" + worker.getTermsByEgoGender(Gender.MALE).size() + "\t(" + worker.getTermsByExclusiveEgoGender(Gender.MALE).size() + " excl.)");
        result.outputs().appendln("Female Speaker:\t" + worker.getTermsByEgoGender(Gender.FEMALE).size() + "\t(" + worker.getTermsByExclusiveEgoGender(Gender.FEMALE).size() + " excl.)");
        result.outputs().appendln();
        result.outputs().appendln("Generation pattern (+|0|-):");
        result.outputs().appendln("Total:\t" + worker.getGenerationPatterns()[3]);
        result.outputs().appendln("Male:\t" + worker.getGenerationPatterns()[0]);
        result.outputs().appendln("Female:\t" + worker.getGenerationPatterns()[1]);
        result.outputs().appendln();
        result.outputs().appendln("Composition structure:");
        result.outputs().appendln("Autoreciprocal Terms:\t" + worker.getAutoReciprocalRoles().size());
        result.outputs().appendln("Recursive Terms:\t" + worker.getRecursiveRolePattern());
        result.outputs().appendln();
        result.outputs().appendln("Typology:");
        result.outputs().appendln("Ascendant classification:\t" + (Object)((Object)worker.getCollateralClassification()[0]));
        result.outputs().appendln("Cousin classification:\t" + (Object)((Object)worker.getCollateralClassification()[1]));
        result.outputs().appendln();
        result.outputs().appendln("Kin Term Network (m.s. / f.s.):");
        result.outputs().appendln("Density:\t" + worker.getGraphStatistics(Gender.MALE, "DENSITY") + "\t" + worker.getGraphStatistics(Gender.FEMALE, "DENSITY"));
        result.outputs().appendln("Mean Degree:\t" + worker.getGraphStatistics(Gender.MALE, "MEANDEGREE") + "\t" + worker.getGraphStatistics(Gender.FEMALE, "MEANDEGREE"));
        result.outputs().appendln("Mean Clustering Coefficient:\t" + worker.getGraphStatistics(Gender.MALE, "MEANCLUSTERINGCOEFF") + "\t" + worker.getGraphStatistics(Gender.FEMALE, "MEANCLUSTERINGCOEFF"));
        result.outputs().appendln("Components:\t" + worker.getGraphStatistics(Gender.MALE, "NRCOMPONENTS") + "\t" + worker.getGraphStatistics(Gender.FEMALE, "NRCOMPONENTS"));
        result.outputs().appendln("Concentration:\t" + worker.getGraphStatistics(Gender.MALE, "CONCENTRATION") + "\t" + worker.getGraphStatistics(Gender.FEMALE, "CONCENTRATION"));
        return result;
    }

    private static Report reportDetailedStatistics(RoleRelationWorker worker) {
        Roles exclusiveTerms;
        Roles terms;
        Report result = new Report("Details");
        result.outputs().appendln("Relation Model " + worker.getTitle());
        result.outputs().appendln();
        result.outputs().appendln("Self term = " + worker.getRelations().getSelfName());
        result.outputs().appendln();
        result.outputs().appendln("Terms:\t" + worker.getTerms().size() + "\t" + worker.getTerms());
        for (Gender gender : Gender.valuesNotUnknown()) {
            terms = worker.getTermsByEgoGender(gender);
            exclusiveTerms = worker.getTermsByExclusiveEgoGender(gender);
            result.outputs().appendln("Terms for " + (Object)((Object)gender) + " speaker:\t" + terms.size() + "\t" + terms.toSortedList());
            result.outputs().appendln("Terms exclusive for " + (Object)((Object)gender) + " speaker:\t" + exclusiveTerms.size() + "\t" + exclusiveTerms.toSortedList());
        }
        for (Gender gender : Gender.valuesNotUnknown()) {
            terms = worker.getTermsByGender(gender);
            exclusiveTerms = worker.getTermsByExclusiveGender(gender);
            result.outputs().appendln((Object)((Object)gender) + " Terms:\t" + terms.size() + "\t" + terms.toSortedList());
            result.outputs().appendln("Exclusively " + (Object)((Object)gender) + " terms:\t" + exclusiveTerms.size() + "\t" + exclusiveTerms.toSortedList());
        }
        Map<Role, List<Integer>> generations = worker.getGenerations();
        result.outputs().appendln();
        result.outputs().appendln("Gender and Generation: ");
        result.outputs().appendln("Generation\tMale\tFemale\tUnkown\tTotal");
        for (Integer generation : worker.getGenerationLevels()) {
            String line = "" + generation;
            Integer[] integerArray = worker.getTermCountsByGenerationAndGender().get(generation);
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer byGender = integerArray[n2];
                line = String.valueOf(line) + "\t" + byGender;
                ++n2;
            }
            result.outputs().appendln(line);
        }
        result.outputs().appendln();
        result.outputs().appendln("Term\tEgo Gender\tAlter Gender\tGenerations");
        for (Role role : worker.getTerms().toSortedList()) {
            result.outputs().appendln(String.valueOf(role.getName()) + "\t" + (Object)((Object)worker.getEgoGender(role)) + "\t" + (Object)((Object)worker.getGender(role)) + "\t" + generations.get(role));
        }
        result.outputs().appendln();
        result.outputs().appendln(RoleRelationReporter.reportCousinTerms(worker));
        return result;
    }

    private static StringList reportCousinTerms(RoleRelationWorker worker) {
        StringList result = new StringList();
        Map<MetaRole, RoleRelationWorker.CousinClassification>[] cousinClassifications = worker.getCollateralClassifications();
        Map<MetaRole, List<List<Role>>>[] cousinTerms = worker.getCollateralTerms();
        String[] firstHeadLine = new String[]{"Ascendant Classification", "Cousin Classification"};
        String[] secondHeadLine = new String[]{"Parents\tParallel Ascendants\tCross Ascendants", "Siblings\tParallel Cousins\tCross Cousins"};
        int i = 0;
        while (i < 2) {
            result.appendln();
            result.appendln(String.valueOf(firstHeadLine[i]) + "\t" + (Object)((Object)worker.getCollateralClassification()[i]));
            result.appendln();
            result.appendln("Config\tType\t" + secondHeadLine[i]);
            for (MetaRole config : cousinTerms[i].keySet()) {
                List<List<Role>> terms = cousinTerms[i].get(config);
                result.appendln(config + "\t" + (Object)((Object)cousinClassifications[i].get(config)) + "\t" + terms.get(0) + "\t" + terms.get(1) + "\t" + terms.get(2));
            }
            ++i;
        }
        return result;
    }
}

