/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.kinsources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.tip.puck.io.kinsources.CatalogItem;
import org.tip.puck.io.kinsources.CatalogItemComparator;

public class Catalog
implements Iterable<CatalogItem> {
    private String source;
    private List<CatalogItem> items;

    public Catalog() {
        this.items = new ArrayList<CatalogItem>();
    }

    public Catalog(int initialCapacity) {
        this.items = new ArrayList<CatalogItem>(initialCapacity);
    }

    public void add(CatalogItem source) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        this.items.add(source);
    }

    public void addAll(Catalog source) {
        if (source != null) {
            for (CatalogItem item : source) {
                if (this.items.contains(item)) continue;
                this.add(item);
            }
        }
    }

    public void clear() {
        this.items.clear();
    }

    public boolean contains(CatalogItem criteria) {
        boolean result = this.items.contains(criteria);
        return result;
    }

    public Catalog copy() {
        Catalog result = new Catalog(this.items.size());
        for (CatalogItem item : this.items) {
            result.add(item);
        }
        return result;
    }

    public long countOfItems() {
        long result = this.items.size();
        return result;
    }

    public Catalog findWithFile() {
        Catalog result = new Catalog(this.items.size());
        for (CatalogItem dataset : this.items) {
            if (dataset.getIndividualCount() == null || dataset.getIndividualCount() == 0L) continue;
            result.add(dataset);
        }
        return result;
    }

    public CatalogItem getByIndex(int index) {
        CatalogItem result = this.items.get(index);
        return result;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isEmpty() {
        boolean result = this.items.isEmpty();
        return result;
    }

    public boolean isNotEmpty() {
        boolean result = !this.isEmpty();
        return result;
    }

    @Override
    public Iterator<CatalogItem> iterator() {
        Iterator<CatalogItem> result = this.items.iterator();
        return result;
    }

    public synchronized void remove(CatalogItem item) {
        this.items.remove(item);
    }

    public Catalog reverse() {
        Collections.reverse(this.items);
        Catalog result = this;
        return result;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public int size() {
        int result = this.items.size();
        return result;
    }

    public Catalog sortBy(CatalogItemComparator.Criteria sortCriteria) {
        Collections.sort(this.items, new CatalogItemComparator(sortCriteria));
        Catalog result = this;
        return result;
    }

    public Catalog sortById() {
        Collections.sort(this.items, new CatalogItemComparator(CatalogItemComparator.Criteria.ID));
        Catalog result = this;
        return result;
    }

    public Catalog sortByName() {
        Collections.sort(this.items, new CatalogItemComparator(CatalogItemComparator.Criteria.NAME));
        Catalog result = this;
        return result;
    }
}

