/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.bar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.io.GEOTXTFile;
import org.tip.puck.io.bar.BARAttributesLine;
import org.tip.puck.io.bar.BARTXTIndividualLine;
import org.tip.puck.io.bar.BARTXTLabelsLine;
import org.tip.puck.io.iur.IURTXTFile;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.net.workers.NetUtils;

public class BARTXTFile {
    private static final Logger logger = LoggerFactory.getLogger(BARTXTFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 2048;
    public static final String BIRTH_ORDER_LABEL = "ORD";
    public static final String HUSBAND_ORDER_LABEL = "HUSB_ORD";
    public static final String WIFE_ORDER_LABEL = "WIFE_ORD";
    public static final String DIVORCE_LABEL = "DIV";

    public static Net load(File file) throws PuckException {
        Net result = BARTXTFile.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net load(File file, String charsetName) throws PuckException {
        Net result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = BARTXTFile.read(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                exception.printStackTrace();
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                exception.printStackTrace();
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static Net read(BufferedReader in) throws PuckException {
        Net result = new Net();
        BARTXTFile.readIndividuals(result, in);
        BARTXTFile.readFamilies(result, in);
        BARTXTFile.readFamilyAttributes(result, in);
        boolean relationEnded = false;
        while (!relationEnded) {
            if (IURTXTFile.readRelations(result, in)) continue;
            relationEnded = true;
        }
        Geography geography = GEOTXTFile.readGeography(in);
        if (geography != null) {
            result.setGeography(geography);
        }
        logger.debug("Done.");
        return result;
    }

    public static BARAttributesLine readAttributesLine(BufferedReader in) throws PuckException {
        BARAttributesLine result;
        try {
            in.mark(2048);
            String line = BARTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                String[] tokens = line.split("\\t");
                result = new BARAttributesLine();
                result.setId(Double.valueOf(tokens[0]).intValue());
                int tokenCount = 1;
                while (tokenCount < tokens.length) {
                    result.values().add(tokens[tokenCount].trim());
                    ++tokenCount;
                }
            } else {
                in.reset();
                result = null;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
        }
        return result;
    }

    public static void readFamilies(Net result, BufferedReader in) throws PuckException {
        logger.debug("Read second block.");
        BARTXTLabelsLine labelsLine = BARTXTFile.readLabelsLine(in, Status.MANDATORY);
        if (labelsLine != null && labelsLine.size() > 1) {
            boolean ended = false;
            while (!ended) {
                BARAttributesLine source = BARTXTFile.readAttributesLine(in);
                if (source == null) {
                    ended = true;
                    continue;
                }
                if (source.id() == 0) continue;
                int attributeIndex = 0;
                while (attributeIndex < source.values().size()) {
                    String label = (String)labelsLine.get(attributeIndex + 1);
                    String value = source.values().get(attributeIndex);
                    if (StringUtils.isNotBlank((CharSequence)value)) {
                        if (label.equals(BIRTH_ORDER_LABEL) && StringUtils.isNumeric((CharSequence)value)) {
                            ((Individual)result.individuals().getById(source.id())).setBirthOrder(new Double(value).intValue());
                        } else if (label.equals(DIVORCE_LABEL)) {
                            String[] exSpouseIds;
                            String[] stringArray = exSpouseIds = value.split(";");
                            int n = exSpouseIds.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String exSpouseId = stringArray[n2];
                                if (StringUtils.isNumeric((CharSequence)exSpouseId)) {
                                    Family family = result.families().getBySpouses(source.id(), Integer.parseInt(exSpouseId));
                                    if (family != null) {
                                        family.setDivorced();
                                    } else {
                                        System.err.println("Divorced spouse missing for " + source.id() + ": " + exSpouseId);
                                        result.individuals().setAttribute(source.id(), "NOTE_DIV", "Divorced of " + value);
                                    }
                                }
                                ++n2;
                            }
                        } else {
                            result.individuals().setAttribute(source.id(), label, value);
                        }
                    }
                    ++attributeIndex;
                }
            }
        }
    }

    public static boolean readFamilyAttributes(Net target, BufferedReader in) throws PuckException {
        boolean result;
        logger.debug("Read family attribute block.");
        try {
            in.mark(2048);
            BARTXTLabelsLine labelsLine = BARTXTFile.readLabelsLine(in, Status.MANDATORY);
            if (labelsLine == null) {
                result = false;
            } else if (labelsLine.size() != 1 || !((String)labelsLine.get(0)).equalsIgnoreCase("FAMILY")) {
                logger.debug(String.valueOf((String)labelsLine.get(0)) + ": This block is not a family attributes block. Rewind");
                result = false;
                in.reset();
            } else {
                logger.debug("Read family attribute block.");
                labelsLine = BARTXTFile.readLabelsLine(in, Status.MANDATORY);
                if (labelsLine != null && labelsLine.size() > 1) {
                    boolean ended = false;
                    while (!ended) {
                        BARAttributesLine source = BARTXTFile.readAttributesLine(in);
                        if (source == null) {
                            ended = true;
                            continue;
                        }
                        if (source.id() == 0) continue;
                        int husbandId = Integer.parseInt(source.values().get(0));
                        int wifeId = Integer.parseInt(source.values().get(1));
                        Family family = target.families().getBySpouses(husbandId, wifeId);
                        int attributeCount = 2;
                        while (attributeCount < source.values().size()) {
                            String label = (String)labelsLine.get(attributeCount + 1);
                            String value = source.values().get(attributeCount);
                            if (StringUtils.isNotBlank((CharSequence)value)) {
                                family.setAttribute(label, value);
                                if (label.equals(HUSBAND_ORDER_LABEL) && StringUtils.isNumeric((CharSequence)value)) {
                                    family.setHusbandOrder(new Double(value).intValue());
                                }
                                if (label.equals(WIFE_ORDER_LABEL) && StringUtils.isNumeric((CharSequence)value)) {
                                    family.setWifeOrder(new Double(value).intValue());
                                }
                                if (label.equals("UNIONSTATUS")) {
                                    family.setUnionStatus(UnionStatus.valueOf(value));
                                }
                            }
                            ++attributeCount;
                        }
                    }
                }
                logger.debug("Family Attributes loaded.");
                result = true;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            throw PuckExceptions.IO_ERROR.create(exception, "Error on readFamilyAttributes.", new Object[0]);
        }
        logger.debug("Done.");
        return result;
    }

    public static BARTXTIndividualLine readIndividualLine(BufferedReader in) throws PuckException {
        BARTXTIndividualLine result;
        try {
            in.mark(2048);
            String line = BARTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                String[] tokens = line.split("\\t");
                result = new BARTXTIndividualLine(Format.ONEMODE);
                result.setId(Double.valueOf(tokens[0]).intValue());
                if (tokens.length > 1) {
                    result.setName(tokens[1]);
                }
                if (tokens.length > 2 && tokens[2].length() > 0) {
                    result.setGender(tokens[2].charAt(0));
                } else {
                    result.setGender('X');
                }
                if (tokens.length > 3 && NumberUtils.isNumber((String)tokens[3])) {
                    result.setFatherId(Double.valueOf(tokens[3]).intValue());
                } else {
                    result.setFatherId(0);
                }
                if (tokens.length > 4 && NumberUtils.isNumber((String)tokens[4])) {
                    result.setMotherId(Double.valueOf(tokens[4]).intValue());
                } else {
                    result.setMotherId(0);
                }
                int tokenCount = 5;
                while (tokenCount < tokens.length) {
                    if (NumberUtils.isNumber((String)tokens[tokenCount])) {
                        result.spouseIds().add(Double.valueOf(tokens[tokenCount]).intValue());
                    }
                    ++tokenCount;
                }
            } else {
                in.reset();
                result = null;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
        }
        return result;
    }

    public static BARTXTIndividualLine readIndividualLineTwoMode(BufferedReader in) throws PuckException {
        BARTXTIndividualLine result;
        try {
            in.mark(2048);
            String line = BARTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                String[] tokens = line.split("\\t");
                result = new BARTXTIndividualLine(Format.TWOMODE);
                result.setId(Double.valueOf(tokens[0]).intValue());
                if (tokens.length > 1) {
                    result.setName(tokens[1]);
                }
                if (tokens.length > 2 && tokens[2].length() > 0) {
                    result.setGender(tokens[2].charAt(0));
                } else {
                    result.setGender('X');
                }
                if (tokens.length > 3 && NumberUtils.isNumber((String)tokens[3])) {
                    result.setOriginFamilyId(Double.valueOf(tokens[3]).intValue());
                } else {
                    result.setOriginFamilyId(0);
                }
                int tokenCount = 4;
                while (tokenCount < tokens.length) {
                    if (NumberUtils.isNumber((String)tokens[tokenCount])) {
                        result.personalFamilyIds().add(Double.valueOf(tokens[tokenCount]).intValue());
                    }
                    ++tokenCount;
                }
            } else {
                in.reset();
                result = null;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
        }
        return result;
    }

    public static void readIndividuals(Net result, BufferedReader in) throws PuckException {
        Format format = BARTXTFile.readLabelsLine(in, Status.OPTIONAL).getFormat();
        logger.debug("Read first block.");
        boolean ended = false;
        while (!ended) {
            BARTXTIndividualLine source = format == Format.TWOMODE ? BARTXTFile.readIndividualLineTwoMode(in) : BARTXTFile.readIndividualLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            if (source.id() == 0) continue;
            Individual individual = result.get(source.id());
            if (individual == null) {
                individual = new Individual(source.id());
                result.individuals().put(individual);
            }
            if (!StringUtils.isBlank((CharSequence)source.name())) {
                individual.setName(source.name());
            }
            if (Gender.valueOf(source.gender()) != Gender.UNKNOWN) {
                individual.setGender(Gender.valueOf(source.gender()));
            }
            if (source.originFamilyId() != 0) {
                if (individual.getOriginFamily() == null) {
                    Family parents = (Family)result.families().getById(source.originFamilyId());
                    if (parents == null) {
                        parents = new Family(source.originFamilyId());
                        result.families().put(parents);
                    }
                    parents.getChildren().put(individual);
                    individual.setOriginFamily(parents);
                }
            } else if ((source.fatherId() != 0 || source.motherId() != 0) && individual.getOriginFamily() == null) {
                Family parents;
                Individual mother;
                Individual father;
                boolean isNewFamily = false;
                if (source.fatherId() == 0) {
                    father = null;
                } else {
                    father = result.get(source.fatherId());
                    if (father == null) {
                        father = new Individual(source.fatherId());
                        result.individuals().put(father);
                        isNewFamily = true;
                    }
                }
                if (source.motherId() == 0) {
                    mother = null;
                } else {
                    mother = result.get(source.motherId());
                    if (mother == null) {
                        mother = new Individual(source.motherId());
                        result.individuals().put(mother);
                        isNewFamily = true;
                    }
                }
                if (isNewFamily || father == null || mother == null) {
                    parents = null;
                } else {
                    parents = result.families().getBySpouses(father, mother);
                    if (parents != null && (parents.getHusband() == mother || parents.getWife() == father)) {
                        parents.setHusband(father);
                        parents.setWife(mother);
                    }
                }
                if (parents == null) {
                    parents = new Family(result.families().size() + 1);
                    result.families().put(parents);
                    parents.setSpouses(father, mother);
                    if (father != null) {
                        father.getPersonalFamilies().add(parents);
                    }
                    if (mother != null) {
                        mother.getPersonalFamilies().add(parents);
                    }
                }
                parents.getChildren().put(individual);
                individual.setOriginFamily(parents);
            }
            if (format == Format.TWOMODE) {
                for (int personalFamilyId : source.personalFamilyIds()) {
                    if (personalFamilyId == 0) continue;
                    Family family = (Family)result.families().getById(personalFamilyId);
                    if (family == null) {
                        family = new Family(personalFamilyId);
                        result.families().put(family);
                    }
                    if (individual.isMale()) {
                        family.setHusband(individual);
                    } else {
                        family.setWife(individual);
                    }
                    if (family.getHusband() != null && family.getWife() != null) {
                        family.setMarried(true);
                    }
                    individual.getPersonalFamilies().put(family);
                }
                continue;
            }
            for (int spouseId : source.spouseIds()) {
                Family family;
                if (spouseId == 0) continue;
                boolean isNewFamily = false;
                Individual spouse = (Individual)result.individuals().getById(spouseId);
                if (spouse == null) {
                    spouse = new Individual(spouseId);
                    result.individuals().put(spouse);
                    isNewFamily = true;
                }
                if ((family = isNewFamily ? null : result.families().getBySpouses(individual, spouse)) == null) {
                    family = new Family(result.families().size() + 1);
                    if (individual.isMale()) {
                        family.setSpouses(individual, spouse);
                    } else {
                        family.setSpouses(spouse, individual);
                    }
                    result.families().put(family);
                }
                family.setMarried(true);
                individual.getPersonalFamilies().put(family);
                spouse.getPersonalFamilies().put(family);
            }
        }
    }

    public static BARTXTLabelsLine readLabelsLine(BufferedReader in, Status status) throws PuckException {
        BARTXTLabelsLine result;
        try {
            in.mark(2048);
            String line = BARTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                if (status == Status.MANDATORY) {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Bad labels line format: [" + line + "].", new Object[0]);
                }
                in.reset();
                result = null;
            } else {
                String[] tokens = line.split("\\t");
                result = new BARTXTLabelsLine();
                if (tokens[0].equalsIgnoreCase("IDI")) {
                    result.setFormat(Format.TWOMODE);
                } else {
                    result.setFormat(Format.ONEMODE);
                }
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    result.add(token);
                    ++n2;
                }
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading labels line.", new Object[0]);
        }
        return result;
    }

    public static String readNotEmptyLine(BufferedReader in) throws PuckException {
        String result;
        try {
            boolean ended = false;
            result = null;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    result = null;
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                ended = true;
                result = line;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
        }
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET_NAME));
                BARTXTFile.write(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                exception.printStackTrace();
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                exception.printStackTrace();
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
    }

    public static void write(PrintWriter out, BARAttributesLine source) {
        if (source != null) {
            StringBuffer buffer = new StringBuffer(192);
            buffer.append(source.id());
            for (String value : source.values()) {
                buffer.append("\t");
                buffer.append(value);
            }
            out.println(buffer.toString());
        }
    }

    public static void write(PrintWriter out, BARTXTIndividualLine source) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(String.format("%d\t%s\t%c\t%d\t%d", source.id(), source.name(), Character.valueOf(source.gender()), source.fatherId(), source.motherId()));
        for (int spouseId : source.spouseIds()) {
            buffer.append(String.format("\t%d", spouseId));
        }
        out.println(buffer.toString());
    }

    public static void write(PrintWriter out, BARTXTLabelsLine source) {
        StringBuffer buffer = new StringBuffer(192);
        Iterator iterator = source.iterator();
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            if (buffer.length() != 0) {
                buffer.append("\t");
            }
            buffer.append(value);
        }
        out.println(buffer.toString());
    }

    public static void write(PrintWriter out, Net source) {
        logger.debug("Write first block labels.");
        out.println("ID\tName\tGender\tFather\tMother\tSpouses");
        logger.debug("Write first block data.");
        for (Individual individual : source.individuals().toSortedList()) {
            BARTXTIndividualLine target = new BARTXTIndividualLine(Format.ONEMODE);
            target.setId(individual.getId());
            target.setName(individual.getName());
            target.setGender(individual.getGender().toChar());
            if (individual.getFather() == null) {
                target.setFatherId(0);
            } else {
                target.setFatherId(individual.getFather().getId());
            }
            if (individual.getMother() == null) {
                target.setMotherId(0);
            } else {
                target.setMotherId(individual.getMother().getId());
            }
            for (Family family : individual.getPersonalFamilies().toSortedList()) {
                Individual spouse;
                if (!family.hasMarried() || (spouse = family.getOtherParent(individual)) == null) continue;
                target.spouseIds().add(spouse.getId());
            }
            BARTXTFile.write(out, target);
        }
        out.println();
        logger.debug("Find labels.");
        BARTXTLabelsLine labelsLine = new BARTXTLabelsLine();
        labelsLine.add("Id");
        for (Individual individual : source.individuals()) {
            for (String label : individual.attributes().labels().sort()) {
                if (labelsLine.contains(label)) continue;
                labelsLine.add(label);
            }
        }
        if (!labelsLine.contains(BIRTH_ORDER_LABEL) && NetUtils.isBirthOrderUsed(source.individuals())) {
            labelsLine.add(BIRTH_ORDER_LABEL);
        }
        if (labelsLine.size() != 1 || source.relationModels().size() != 0) {
            BARTXTFile.write(out, labelsLine);
        }
        if (labelsLine.size() != 1) {
            for (Individual individual : source.individuals().toSortedList()) {
                BARAttributesLine target = new BARAttributesLine();
                target.setId(individual.getId());
                if (!individual.attributes().isEmpty() || individual.getBirthOrder() != null) {
                    int labelIndex = 1;
                    while (labelIndex < labelsLine.size()) {
                        String label = (String)labelsLine.get(labelIndex);
                        Object value = StringUtils.equals((CharSequence)label, (CharSequence)BIRTH_ORDER_LABEL) ? (individual.getBirthOrder() == null ? null : String.valueOf(individual.getBirthOrder())) : individual.getAttributeValue(label);
                        if (value == null) {
                            target.values().add("");
                        } else {
                            target.values().add(((String)value).replace('\t', ' '));
                        }
                        ++labelIndex;
                    }
                }
                BARTXTFile.write(out, target);
            }
        }
        out.println();
        logger.debug("Write relations.");
        IURTXTFile.writeRelations(out, source.relationModels(), source.relations());
        logger.debug("Write geography.");
        if (source.getGeography() != null) {
            GEOTXTFile.writeGeography(out, source.getGeography());
        }
    }

    protected static enum Format {
        ONEMODE,
        TWOMODE;

    }

    protected static enum Status {
        MANDATORY,
        OPTIONAL;

    }
}

