/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Links;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.NodeValuator;
import org.tip.puck.matrix.Matrix;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.util.Value;
import org.tip.puck.util.Values;

public class GraphMaker {
    public static Graph<Node<String>> createGraph(String name, Matrix matrix, Map<Value, Double> vector, String vectorLabel) {
        Graph<Node<String>> result = new Graph<Node<String>>(name);
        int row = 0;
        while (row < matrix.getRowDim()) {
            Node<String> node = new Node<String>(row, matrix.getRowLabel(row));
            Double value = vector.get(new Value(matrix.getRowLabel(row)));
            if (value == null) {
                node.setAttribute(vectorLabel, "0.");
            } else {
                node.setAttribute(vectorLabel, "" + value);
            }
            result.addNode(row, node);
            ++row;
        }
        row = 0;
        while (row < matrix.getRowDim()) {
            int col = 0;
            while (col < matrix.getRowDim()) {
                if (matrix.get(row, col) > 0) {
                    result.addArcWeight(row, col, (double)matrix.get(row, col));
                }
                ++col;
            }
            ++row;
        }
        return result;
    }

    public static <E> Map<String, Map<Value, Integer>> getPartitionNumbersMaps(List<String> labels, Graph<E> model) {
        HashMap<String, Map<Value, Integer>> result = new HashMap<String, Map<Value, Integer>>();
        for (String label : labels) {
            Values values = NodeValuator.get(model, label);
            if (values.isNumeric()) continue;
            Partition<Value> partition = PartitionMaker.create(label, values);
            result.put(label, PartitionMaker.getPartitionNumbersMap(partition));
        }
        return result;
    }

    public static <E> Map<Value, Graph<E>> createSubgraphsByLineTags(Graph<E> source) {
        TreeMap<Value, Graph<E>> result = new TreeMap<Value, Graph<E>>();
        Partition<Link> linkPartition = new Partition<Link>();
        for (Link link : source.getLinks()) {
            for (String tag : link.getTags()) {
                linkPartition.put(link, Value.valueOf(tag));
            }
        }
        for (Cluster cluster : linkPartition.getClusters()) {
            Graph subGraph = new Graph(String.valueOf(source.getLabel()) + " " + cluster.getValue());
            subGraph.addLinks(new Links(cluster.getItems()));
            result.put(cluster.getValue(), subGraph);
        }
        return result;
    }

    public static <E> Graph<E> extractSubgraph(Graph<E> source, List<Node<E>> nodes, String label) {
        Graph result = new Graph(label);
        for (Node<E> node : nodes) {
            result.addNode(node.getReferent());
        }
        for (Link link : source.getLinks()) {
            if (!nodes.contains(link.getSourceNode()) || !nodes.contains(link.getTargetNode())) continue;
            result.addLink(link.getSourceReferent(), link.getTargetReferent(), link.getType(), link.getWeight());
        }
        return result;
    }

    public static <E> Graph<E> removeLoops(Graph<E> source) {
        Graph result = new Graph(String.valueOf(source.getLabel()) + "_NOLOOPS");
        for (Node<E> node : source.getNodes()) {
            result.addNode(node.getReferent());
        }
        for (Link link : source.getLinks()) {
            if (link.isLoop()) continue;
            result.addLink(link.getSourceReferent(), link.getTargetReferent(), link.getType(), link.getWeight());
        }
        return result;
    }

    public static <E> Graph<E> reduce(Graph<E> source, int minDegree) {
        ArrayList<Node<Node<E>>> nodes = new ArrayList<Node<Node<E>>>();
        for (Node<E> node : source.getNodes()) {
            if (node.getDegree() < minDegree) continue;
            nodes.add(node);
        }
        Graph<E> result = GraphMaker.extractSubgraph(source, nodes, String.valueOf(source.getLabel()) + "_MINDEG_" + minDegree);
        return result;
    }

    public static <E> Graph<E> getCyclicCore(Graph<E> source) {
        Graph<E> previousResult = GraphMaker.removeLoops(source);
        Graph<E> result = GraphMaker.reduce(previousResult, 2);
        while (result.nodeCount() < previousResult.nodeCount()) {
            previousResult = result;
            result = GraphMaker.reduce(previousResult, 2);
        }
        return result;
    }
}

