/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo.workers;

import fr.devinsy.util.StringSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.net.workers.AttributeValueDescriptor;
import org.tip.puck.net.workers.AttributeValueDescriptors;

public class GeocodingWorker {
    private GeocodingWorker() {
    }

    public static Graph<Place> geocodeAttributeValueDescriptors(Geography geography, AttributeValueDescriptors valueDescriptors, double weightFactor) {
        Graph<Place> result = new Graph<Place>();
        if (geography != null && valueDescriptors != null) {
            for (AttributeValueDescriptor valueDescriptor : valueDescriptors) {
                Place place = geography.get(valueDescriptor.getValue());
                if (place == null || !place.isGeocoded()) continue;
                Node<Place> node = result.addNode(place);
                node.incWeight((double)valueDescriptor.getCount() * weightFactor);
            }
        }
        return result;
    }

    public static <E> Graph<Place> geocodeGraph(Geography geography, Graph<E> source) {
        Graph<Place> result;
        if (source == null) {
            result = null;
        } else {
            result = new Graph<Place>();
            result.setLabel(source.getLabel());
            if (geography != null) {
                for (Node<E> node : source.getNodes()) {
                    Place place;
                    String sourceNodeLabel = node.getLabel();
                    if (!StringUtils.isNotBlank((CharSequence)sourceNodeLabel) || (place = geography.get(sourceNodeLabel)) == null || !place.isGeocoded()) continue;
                    result.addNode(node.getId(), place);
                }
                for (Node<Object> node : result.getNodes()) {
                    Node<E> sourceNode = source.getNodes().get(node.getId());
                    for (Link link : sourceNode.getLinks()) {
                        if (result.getNodes().get(link.getTargetId()) == null || result.getNodes().get(link.getSourceId()) == null) continue;
                        if (link.isArc()) {
                            result.addArc(link.getSourceId(), link.getTargetId(), link.getWeight());
                            continue;
                        }
                        result.addEdge(link.getSourceId(), link.getTargetId(), link.getWeight());
                    }
                }
            }
        }
        return result;
    }

    public static Graph<Place> geocodeToponyms(Geography geography, StringSet toponyms) {
        Graph<Place> result = new Graph<Place>();
        if (geography != null && toponyms != null) {
            for (String toponym : toponyms) {
                Place place = geography.get(toponym);
                if (place == null || !place.isGeocoded()) continue;
                result.addNode(place);
            }
        }
        return result;
    }

    @Deprecated
    public static Graph<Place> geocodeToponymStrings(Geography geography, StringSet toponyms, double weightStep) {
        Graph<Place> result = new Graph<Place>();
        if (geography != null && toponyms != null) {
            for (String toponym : toponyms) {
                List<Node<Place>> nodes = result.getNodesByLabel(toponym).toList();
                if (nodes.isEmpty()) {
                    Place place = geography.get(toponym);
                    if (place == null || !place.isGeocoded()) continue;
                    Node<Place> node = result.addNode(place);
                    node.incWeight(weightStep);
                    continue;
                }
                Node<Place> node = nodes.get(0);
                node.incWeight(weightStep);
            }
        }
        return result;
    }
}

