/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo.io;

import java.io.File;
import java.security.InvalidParameterException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.io.GEOODSFile;
import org.tip.puck.geo.io.GEOTXTFile;
import org.tip.puck.geo.io.GEOXLSFile;

public class GEOFile {
    private static final Logger logger = LoggerFactory.getLogger(GEOFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public static Geography load(File source) throws PuckException {
        Geography result = GEOFile.load(source, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Geography load(File source, String charsetName) throws PuckException {
        Geography result;
        if (source == null) {
            throw new InvalidParameterException("Null parameter");
        }
        String fileName = source.getName().toLowerCase();
        if (fileName.endsWith(".ods")) {
            result = GEOODSFile.load(source);
        } else if (StringUtils.endsWithAny((CharSequence)fileName, (CharSequence[])new CharSequence[]{".txt", ".csv"})) {
            result = GEOTXTFile.load(source, charsetName);
        } else if (fileName.endsWith(".xls")) {
            result = GEOXLSFile.load(source);
        } else {
            throw new InvalidParameterException("Unknown extension.");
        }
        return result;
    }

    public static void save(File target, Geography source) throws PuckException {
        if (source == null) {
            throw new InvalidParameterException("Null parameter");
        }
        String fileName = target.getName().toLowerCase();
        if (fileName.endsWith(".ods")) {
            GEOODSFile.save(target, source);
        } else if (StringUtils.endsWithAny((CharSequence)fileName, (CharSequence[])new CharSequence[]{".txt", ".csv"})) {
            GEOTXTFile.save(target, source);
        } else if (fileName.endsWith(".xls")) {
            GEOXLSFile.save(target, source);
        } else {
            throw new InvalidParameterException("Unknown extension.");
        }
    }
}

