/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo;

import fr.devinsy.util.StringSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.PlaceComparator;

public class Places
extends ArrayList<Place> {
    private static final long serialVersionUID = -8277613440390116082L;

    public Places() {
    }

    public Places(int capacity) {
        super(capacity);
    }

    public Places(Places source) {
        if (source != null) {
            for (Place place : source) {
                this.add(place);
            }
        }
    }

    public Place getByToponym(String searchedName) {
        boolean ended = false;
        Iterator iterator = this.iterator();
        Place result = null;
        while (!ended) {
            if (iterator.hasNext()) {
                Place current = (Place)iterator.next();
                if (!StringUtils.equals((CharSequence)current.getToponym(), (CharSequence)searchedName)) continue;
                ended = true;
                result = current;
                continue;
            }
            ended = true;
            result = null;
        }
        return result;
    }

    public void sortByToponym() {
        Collections.sort(this, new PlaceComparator(PlaceComparator.Sorting.TOPONYM));
    }

    public StringSet toponyms() {
        StringSet result = new StringSet();
        for (Place place : this) {
            result.add(place.getToponym());
        }
        return result;
    }
}

