/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo;

import java.text.Collator;
import java.util.Comparator;
import org.tip.puck.geo.Place;

public class PlaceComparator
implements Comparator<Place> {
    private Sorting sorting;

    public PlaceComparator() {
        this.sorting = Sorting.DEFAULT;
    }

    public PlaceComparator(Sorting sorting) {
        this.sorting = sorting;
    }

    @Override
    public int compare(Place alpha, Place bravo) {
        int result = PlaceComparator.compare(alpha, bravo, this.sorting);
        return result;
    }

    public String getLabel(Place source) {
        String result = source == null ? null : source.getToponym();
        return result;
    }

    public static int compare(Place alpha, Place bravo, Sorting sorting) {
        int result;
        if (alpha == null && bravo == null) {
            result = 0;
        } else if (alpha == null) {
            result = -1;
        } else if (bravo == null) {
            result = 1;
        } else {
            switch (sorting) {
                case DEFAULT: 
                case TOPONYM: {
                    result = PlaceComparator.compare(alpha.getToponym(), bravo.getToponym());
                    break;
                }
                default: {
                    result = 0;
                }
            }
        }
        return result;
    }

    public static int compare(String alpha, String bravo) {
        int result = alpha == null && bravo == null ? 0 : (alpha == null ? -1 : (bravo == null ? 1 : Collator.getInstance().compare(alpha, bravo)));
        return result;
    }

    public static enum Sorting {
        DEFAULT,
        TOPONYM;

    }
}

