/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo;

import fr.devinsy.util.StringList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.Places;

public class IndexOfToponyms {
    private Map<String, Place> index = new HashMap<String, Place>();

    public IndexOfToponyms clear() {
        this.index.clear();
        return this;
    }

    public boolean contains(String toponym) {
        boolean result = this.get(toponym) != null;
        return result;
    }

    public Place get(String toponym) {
        Place result = toponym == null ? null : this.index.get(StringUtils.lowerCase((String)toponym));
        return result;
    }

    public StringList getToponyms() {
        StringList result = new StringList();
        for (String name : this.index.keySet()) {
            result.add((Object)name);
        }
        return result;
    }

    public IndexOfToponyms index(Place place) {
        if (place != null) {
            this.index.put(StringUtils.lowerCase((String)place.getToponym()), place);
            Iterator iterator = place.getHomonyms().iterator();
            while (iterator.hasNext()) {
                String homonym = (String)iterator.next();
                this.index.put(StringUtils.lowerCase((String)homonym), place);
            }
        }
        return this;
    }

    public IndexOfToponyms index(Places places) {
        if (places != null) {
            for (Place place : places) {
                this.index(place);
            }
        }
        return this;
    }

    public int size() {
        int result = this.index.size();
        return result;
    }
}

