/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.census.chains;

import java.util.Arrays;
import org.tip.puck.util.MathUtils;

public class Vector
implements Comparable<Vector> {
    private int[] numbers;
    int[] reducedNumbers;
    int[] apexGenders;

    public Vector(int order) {
        this.setNumbers(new int[2 * order]);
    }

    private int getLength(int i) {
        return new Double(Math.floor(Math.log(this.number(i) + 1) / Math.log(2.0))).intValue() - 1;
    }

    public int order() {
        return this.getNumbers().length / 2;
    }

    private int number(int i) {
        return Math.abs(this.getNumbers()[i]);
    }

    private int reducedNumber(int i) {
        return this.reducedNumbers[i];
    }

    private int apexGender(int i) {
        return this.apexGenders[i];
    }

    public Vector(int[] numbers) {
        this.setNumbers(numbers);
    }

    public Vector(Vector vector) {
        this.setNumbers(vector.getNumbers());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object otherVector) {
        boolean result = true;
        Vector other = (Vector)otherVector;
        if (this.order() != other.order()) {
            result = false;
        } else {
            int i = 0;
            while (i < 2 * this.order()) {
                if (this.number(i) != other.number(i)) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public String toString() {
        return Arrays.toString(this.getNumbers());
    }

    private int length() {
        int j = 0;
        int i = 0;
        while (i < this.getNumbers().length) {
            j += this.getLength(i);
            ++i;
        }
        return j + this.order() - 1;
    }

    public Vector transform(int i) {
        int n = this.getNumbers().length;
        int[] v = new int[n];
        int j = 0;
        if (i % 2 == 0) {
            int k = i;
            while (k < i + n) {
                v[j] = this.getNumbers()[k % n];
                ++j;
                ++k;
            }
        } else {
            int k = i;
            while (k > i - n) {
                v[j] = this.getNumbers()[(k + n) % n];
                ++j;
                --k;
            }
        }
        return new Vector(v);
    }

    public int genderedCompareTo(Vector other) {
        int result = this.compareTo(other, CompareCriterion.EGOGENDER);
        if (result == 0) {
            result = this.compareTo(other);
        }
        return result;
    }

    @Override
    public int compareTo(Vector other) {
        int result = 0;
        CompareCriterion[] compareCriterionArray = CompareCriterion.values();
        int n = compareCriterionArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareCriterion criterion = compareCriterionArray[n2];
            result = this.compareTo(other, criterion);
            if (result != 0) break;
            ++n2;
        }
        return result;
    }

    private static int compare(int a, int b) {
        return new Integer(a).compareTo(b);
    }

    private int egoGenderInt() {
        return Math.abs(this.getNumbers()[0] % 2);
    }

    private int alterGenderInt() {
        return Math.abs(this.getNumbers()[this.getNumbers().length - 1] % 2);
    }

    private int compareGender() {
        return Math.abs(Vector.compare(this.egoGenderInt(), this.alterGenderInt()));
    }

    private void reduce() {
        this.reducedNumbers = new int[this.getNumbers().length];
        this.apexGenders = new int[this.getNumbers().length];
        int i = 0;
        while (i < this.getNumbers().length) {
            int a = this.number(i);
            int d = new Double(Math.floor(Math.log(a + 1) / Math.log(2.0))).intValue();
            int k = MathUtils.pow2(d);
            int r = a - k + 1;
            this.apexGenders[i] = new Long(Math.round(new Double(r) / new Double(k))).intValue();
            this.reducedNumbers[i] = a - (this.apexGenders[i] + 1) * k / 2;
            if (this.getNumbers()[i] < 0) {
                this.apexGenders[i] = -1;
            }
            ++i;
        }
    }

    private int compareTo(Vector other, CompareCriterion criterion) {
        int result = 0;
        block0 : switch (criterion) {
            case ORDER: {
                result = Vector.compare(this.order(), other.order());
                break;
            }
            case LENGTH: {
                result = Vector.compare(this.length(), other.length());
                break;
            }
            case LEFT_BRANCH_LENGTH: {
                int i = 0;
                while (i < this.order()) {
                    result = Vector.compare(this.getLength(2 * i), other.getLength(2 * i));
                    if (result != 0) break block0;
                    ++i;
                }
                break;
            }
            case HETERO: {
                result = -Vector.compare(this.compareGender(), other.compareGender());
                break;
            }
            case EGOGENDER: {
                result = this.egoGenderInt() - other.egoGenderInt();
                break;
            }
            case GENDER_PROFILE: {
                this.reduce();
                other.reduce();
                int i = 0;
                while (i < this.getNumbers().length) {
                    int otherNumber;
                    int number;
                    if (this.linear(i) || other.linear(i)) {
                        number = this.number(i);
                        otherNumber = other.number(i);
                    } else {
                        number = this.reducedNumber(i);
                        otherNumber = other.reducedNumber(i);
                    }
                    result = Vector.compare(number, otherNumber);
                    if (result != 0) break;
                    ++i;
                }
                if (result != 0) break;
                i = 0;
                while (i < this.getNumbers().length) {
                    result = Vector.compare(this.apexGender(i), other.apexGender(i));
                    if (result != 0) break block0;
                    ++i;
                }
                break;
            }
        }
        return result;
    }

    private boolean linear(int i) {
        int otherBranch = i + 1 - 2 * (i % 2);
        boolean result = this.getNumbers()[otherBranch] == 0;
        return result;
    }

    public int[] getNumbers() {
        return this.numbers;
    }

    public void setNumbers(int[] numbers) {
        this.numbers = numbers;
    }

    private static enum CompareCriterion {
        ORDER,
        LENGTH,
        LEFT_BRANCH_LENGTH,
        HETERO,
        EGOGENDER,
        GENDER_PROFILE;

    }
}

