/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.stag;

import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.stag.StatisticTags;

public enum StatisticTag {
    NUM_OF_INDIVIDUALS(Scope.GENEALOGY, Type.LONG),
    NUM_OF_MEN(Scope.GENEALOGY, Type.LONG),
    NUM_OF_WOMEN(Scope.GENEALOGY, Type.LONG),
    NUM_OF_UNKNOWN(Scope.GENEALOGY, Type.LONG),
    RATE_OF_MEN(Scope.GENEALOGY, Type.DOUBLE),
    RATE_OF_WOMEN(Scope.GENEALOGY, Type.DOUBLE),
    RATE_OF_UNKNOWN(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_UNIONS(Scope.GENEALOGY, Type.LONG),
    NUM_OF_MARRIAGES(Scope.GENEALOGY, Type.LONG),
    DENSITY_OF_MARRIAGES(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_NON_SINGLE_MEN(Scope.GENEALOGY, Type.LONG),
    NUM_OF_NON_SINGLE_WOMEN(Scope.GENEALOGY, Type.LONG),
    NUM_OF_PARENT_CHILD_TIES(Scope.GENEALOGY, Type.LONG),
    DENSITY_OF_FILIATION(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_FERTILE_MARRIAGES(Scope.GENEALOGY, Type.LONG),
    RATE_OF_FERTILE_MARRIAGES(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_COWIFE_RELATIONS(Scope.GENEALOGY, Type.LONG),
    NUM_OF_COHUSBAND_RELATIONS(Scope.GENEALOGY, Type.LONG),
    NUM_OF_RELATIONS(Scope.GENEALOGY, Type.LONG),
    NUM_OF_RELATION_MODELS(Scope.GENEALOGY, Type.LONG),
    NUM_OF_COMPONENTS(Scope.GENEALOGY, Type.LONG),
    MAX_OF_COMPONENTS(Scope.GENEALOGY, Type.LONG),
    MEAN_OF_COMPONENTS_SHARE_AGNATIC(Scope.GENEALOGY, Type.DOUBLE),
    MAX_OF_COMPONENTS_SHARE_AGNATIC(Scope.GENEALOGY, Type.DOUBLE),
    MEAN_OF_COMPONENTS_SHARE_AGNATIC_WO_SINGLETON(Scope.GENEALOGY, Type.DOUBLE),
    MEAN_OF_COMPONENTS_SHARE_UTERINE(Scope.GENEALOGY, Type.DOUBLE),
    MAX_OF_COMPONENTS_SHARE_UTERINE(Scope.GENEALOGY, Type.DOUBLE),
    MEAN_OF_COMPONENTS_SHARE_UTERINE_WO_SINGLETON(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_ELEMENTARY_CYCLES(Scope.GENEALOGY, Type.LONG),
    DEPTH(Scope.GENEALOGY, Type.LONG),
    DEPTH_MEAN(Scope.GENEALOGY, Type.DOUBLE),
    MEAN_SPOUSE_OF_MEN(Scope.GENEALOGY, Type.DOUBLE),
    MEAN_SPOUSE_OF_WOMEN(Scope.GENEALOGY, Type.DOUBLE),
    MEAN_AGNATIC_FRATRY_SIZE(Scope.GENEALOGY, Type.DOUBLE),
    MEAN_UTERINE_FRATRY_SIZE(Scope.GENEALOGY, Type.DOUBLE),
    MEAN_CHILDREN_PER_FERTILE_COUPLE(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_CROSS_FIRST_COUSIN_MARRIAGES(Scope.GENEALOGY, Type.LONG),
    RATE_OF_CROSS_FIRST_COUSIN_MARRIAGES(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_LEVIRATE_MARRIAGES(Scope.GENEALOGY, Type.LONG),
    RATE_OF_LEVIRATE_MARRIAGES(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_SORORATE_MARRIAGES(Scope.GENEALOGY, Type.LONG),
    RATE_OF_SORORATE_MARRIAGES(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_DOUBLE_OR_EXCHANGE_MARRIAGES(Scope.GENEALOGY, Type.LONG),
    RATE_OF_DOUBLE_OR_EXCHANGE_MARRIAGES(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_NIECE_NEPHEW_MARRIAGES(Scope.GENEALOGY, Type.LONG),
    RATE_OF_NIECE_NEPHEW_MARRIAGES(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_PARALLEL_FIRST_COUSIN_MARRIAGES(Scope.GENEALOGY, Type.LONG),
    RATE_OF_PARALLEL_FIRST_COUSIN_MARRIAGES(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_FIRST_COUSIN_MARRIAGES(Scope.GENEALOGY, Type.LONG),
    RATE_OF_FIRST_COUSIN_MARRIAGES(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_DOUBLE_MARRIAGES(Scope.GENEALOGY, Type.LONG),
    RATE_OF_DOUBLE_MARRIAGES(Scope.GENEALOGY, Type.DOUBLE),
    NUM_OF_EXCHANGE_MARRIAGES(Scope.GENEALOGY, Type.LONG),
    RATE_OF_EXCHANGE_MARRIAGES(Scope.GENEALOGY, Type.DOUBLE),
    BASIC_GSTATISTICS_ERROR(Scope.GENEALOGY, Type.LONG),
    GENERAL_CHECK(Scope.TERMINOLOGY, Type.LONG),
    NUM_OF_TERMS(Scope.TERMINOLOGY, Type.LONG),
    SELF_NAME(Scope.TERMINOLOGY, Type.STRING),
    NUM_OF_FEMALES(Scope.TERMINOLOGY, Type.LONG),
    NUM_OF_FEMALES_EXCLUSIVE(Scope.TERMINOLOGY, Type.LONG),
    NUM_OF_FEMALES_SPEAKER(Scope.TERMINOLOGY, Type.LONG),
    NUM_OF_FEMALES_SPEAKER_EXCLUSIVE(Scope.TERMINOLOGY, Type.LONG),
    NUM_OF_MALES(Scope.TERMINOLOGY, Type.LONG),
    NUM_OF_MALES_EXCLUSIVE(Scope.TERMINOLOGY, Type.LONG),
    NUM_OF_MALES_SPEAKER(Scope.TERMINOLOGY, Type.LONG),
    NUM_OF_MALES_SPEAKER_EXCLUSIVE(Scope.TERMINOLOGY, Type.LONG),
    GENERATION_PATTERN_MALE(Scope.TERMINOLOGY, Type.STRING),
    GENERATION_PATTERN_FEMALE(Scope.TERMINOLOGY, Type.STRING),
    GENERATION_PATTERN_TOTAL(Scope.TERMINOLOGY, Type.STRING),
    NUM_OF_AUTORECIPROCAL_TERMS(Scope.TERMINOLOGY, Type.LONG),
    RECURSIVE_TERMS(Scope.TERMINOLOGY, Type.STRING),
    ASCENDANT_CLASSIFICATION(Scope.TERMINOLOGY, Type.STRING),
    COUSIN_CLASSIFICATION(Scope.TERMINOLOGY, Type.STRING),
    KIN_TERM_NETWORK_FEMALE_COMPONENTS(Scope.TERMINOLOGY, Type.LONG),
    KIN_TERM_NETWORK_FEMALE_CONCENTRATION(Scope.TERMINOLOGY, Type.DOUBLE),
    KIN_TERM_NETWORK_FEMALE_SPEAKER_DENSITY(Scope.TERMINOLOGY, Type.DOUBLE),
    KIN_TERM_NETWORK_FEMALE_SPEAKER_MEAN_CLUSTERING_COEFFICIENT(Scope.TERMINOLOGY, Type.DOUBLE),
    KIN_TERM_NETWORK_FEMALE_SPEAKER_MEAN_DEGREE(Scope.TERMINOLOGY, Type.DOUBLE),
    KIN_TERM_NETWORK_MALE_COMPONENTS(Scope.TERMINOLOGY, Type.LONG),
    KIN_TERM_NETWORK_MALE_CONCENTRATION(Scope.TERMINOLOGY, Type.DOUBLE),
    KIN_TERM_NETWORK_MALE_SPEAKER_DENSITY(Scope.TERMINOLOGY, Type.DOUBLE),
    KIN_TERM_NETWORK_MALE_SPEAKER_MEAN_CLUSTERING_COEFFICIENT(Scope.TERMINOLOGY, Type.DOUBLE),
    KIN_TERM_NETWORK_MALE_SPEAKER_MEAN_DEGREE(Scope.TERMINOLOGY, Type.DOUBLE),
    BASIC_TSTATISTICS_ERROR(Scope.TERMINOLOGY, Type.LONG),
    GEOGRAPHY_AVAILABLE(Scope.GEOGRAPHY, Type.BOOLEAN),
    COMPUTING_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_BEGIN_DATETIME(Scope.SYSTEM, Type.STRING),
    COMPUTING_END_DATETIME(Scope.SYSTEM, Type.STRING),
    GRAPHICS_COUNT(Scope.SYSTEM, Type.LONG),
    COMPUTING_CONTROLS_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_BASICS_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GEOGRAPHY_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_ATTRIBUTES_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_CIRCUITS_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GRAPHIC_COMPONENTS_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GRAPHIC_COMPLETENESS_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GRAPHIC_SIBSETDISTRIBUTION_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GRAPHIC_CONSANGUINEPAIRS_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GRAPHIC_BIASWEIGHTS_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GRAPHIC_BIASNETWEIGHTS_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GRAPHIC_GENDERS_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GRAPHIC_PEDG2_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GRAPHIC_PEDG3_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GRAPHIC_UNIONSTATUS_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GRAPHIC_FIRSTCOUSINMARRIAGES_TIME(Scope.SYSTEM, Type.LONG),
    COMPUTING_GRAPHIC_ANCESTORCHAINS_TIME(Scope.SYSTEM, Type.LONG);

    private Scope scope;
    private Type type;

    private StatisticTag(Scope scope, Type type) {
        this.scope = scope;
        this.type = type;
    }

    public boolean isBasic() {
        boolean result;
        switch (this) {
            case NUM_OF_INDIVIDUALS: 
            case NUM_OF_UNIONS: 
            case NUM_OF_RELATIONS: 
            case DEPTH: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isGenealogy() {
        boolean result = this.scope == Scope.GENEALOGY;
        return result;
    }

    public boolean isNotBasic() {
        boolean result = !this.isBasic();
        return result;
    }

    public boolean isTerminology() {
        boolean result = this.scope == Scope.TERMINOLOGY;
        return result;
    }

    public Scope scope() {
        return this.scope;
    }

    public Type type() {
        return this.type;
    }

    public static boolean isBasic(String name) {
        StatisticTag statistic = (StatisticTag)EnumUtils.getEnum(StatisticTag.class, (String)StringUtils.upperCase((String)name));
        boolean result = statistic == null ? false : statistic.isBasic();
        return result;
    }

    public static boolean isNotBasic(String name) {
        boolean result = !StatisticTag.isBasic(name);
        return result;
    }

    public static StatisticTags tags() {
        StatisticTags result = new StatisticTags();
        StatisticTag[] statisticTagArray = StatisticTag.values();
        int n = statisticTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatisticTag tag = statisticTagArray[n2];
            result.add(tag);
            ++n2;
        }
        return result;
    }

    public static enum Scope {
        GENEALOGY,
        TERMINOLOGY,
        GEOGRAPHY,
        SYSTEM;

    }

    public static enum Type {
        DOUBLE,
        LONG,
        STRING,
        BOOLEAN;

    }
}

