/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.stag;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.io.puc.PUCFile;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.ControlReporter;
import org.tip.puck.report.Report;
import org.tip.puck.stag.Stag;

public class StagChecker {
    private static Properties buildStats(Net net) {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)Stag.buildControlStatistics(net));
        Report report = ControlReporter.reportControls(net, null, new ControlReporter.ControlType[]{ControlReporter.ControlType.MISSING_DATES});
        result.putAll((Map<?, ?>)Stag.buildBasicStatistics(net));
        result.putAll((Map<?, ?>)Stag.buildGeographyStatistics(net));
        result.putAll((Map<?, ?>)Stag.buildCircuitStatistics(net));
        return result;
    }

    private static void check(Net net, Properties refStats, Properties newStats) {
        for (Object key : refStats.keySet()) {
            String newValue;
            String refValue;
            String name = (String)key;
            if (StringUtils.contains((CharSequence)name, (CharSequence)"TIME") || StringUtils.contains((CharSequence)name, (CharSequence)"GRAPHICS_COUNT") || StringUtils.equals((CharSequence)(refValue = String.valueOf(refStats.get(name))), (CharSequence)(newValue = String.valueOf(newStats.get(name))))) continue;
            System.out.println(String.valueOf(net.getLabel()) + ": " + name + " " + refValue + " " + newValue);
        }
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            File directory = new File(args[0]);
            if (directory.exists() && directory.isDirectory()) {
                File[] files = directory.listFiles();
                Arrays.sort(files, NameFileComparator.NAME_COMPARATOR);
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (StringUtils.endsWith((CharSequence)file.getName(), (CharSequence)".stats")) {
                        File pucFile = new File(file.getAbsolutePath().replace(".stats", ".puc"));
                        File statFile = file;
                        System.out.println("=== " + pucFile.getName());
                        try {
                            Net net = PUCFile.load(pucFile);
                            Properties refStats = new Properties();
                            refStats.load(new FileReader(statFile));
                            Properties newStats = StagChecker.buildStats(net);
                            StagChecker.check(net, refStats, newStats);
                        }
                        catch (PuckException exception) {
                            exception.printStackTrace();
                        }
                        catch (FileNotFoundException exception) {
                            exception.printStackTrace();
                        }
                        catch (IOException exception) {
                            exception.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
        } else {
            System.out.println("Please, set parameter.");
        }
    }
}

