/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.segmentation;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.geo.Geography;
import org.tip.puck.net.Families;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.RelationValuator;
import org.tip.puck.net.workers.FamilyValuator;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionCriteriaList;
import org.tip.puck.segmentation.DefaultSegment;
import org.tip.puck.segmentation.Segment;
import org.tip.puck.segmentation.Segments;
import org.tip.puck.util.Labels;

public class Segmentation {
    private String label;
    private Segments segments = new Segments();
    private int currentSegmentIndex;
    private Geography geography;

    public Segmentation(Individuals individuals, Families families, Relations relations, Geography geography) {
        this.segments.add(new DefaultSegment(individuals, families, relations, geography));
        this.currentSegmentIndex = 0;
        this.geography = geography;
    }

    public Segmentation(Net source) {
        this.label = source.getLabel();
        this.segments.add(new DefaultSegment(source.individuals(), source.families(), source.relations(), source.getGeography()));
        this.currentSegmentIndex = 0;
        this.geography = source.getGeography();
    }

    public Segmentation(Net source, Segmentation reference) throws PuckException {
        this.label = source.getLabel();
        this.geography = source.getGeography();
        this.segments.add(new DefaultSegment(source.individuals(), source.families(), source.relations(), source.getGeography()));
        if (reference != null) {
            int index = 1;
            while (index < reference.getSegments().size()) {
                Segment sourceSegment = (Segment)reference.getSegments().get(index);
                Segment targetSegment = this.addSegment(sourceSegment.getCriteria());
                targetSegment.selectCluster(sourceSegment.getCurrentClusterIndex());
                ++index;
            }
            this.currentSegmentIndex = reference.getCurrentSegmentIndex();
        }
    }

    /*
     * Unable to fully structure code
     */
    public Segment addSegment(PartitionCriteria criteria) throws PuckException {
        block1: {
            if (criteria != null && !StringUtils.isBlank((CharSequence)criteria.getRelationModelName())) ** GOTO lbl6
            result = null;
            break block1;
lbl-1000:
            // 1 sources

            {
                this.segments.remove(this.segments.size() - 1);
lbl6:
                // 2 sources

                ** while (this.currentSegmentIndex != this.segments.size() - 1)
            }
lbl7:
            // 1 sources

            result = this.segments.addSegment(this.getCurrentSegment(), criteria);
            ++this.currentSegmentIndex;
        }
        result.setGeography(this.geography);
        return result;
    }

    public void clear() throws PuckException {
        this.currentSegmentIndex = 0;
        this.clearBelow();
    }

    public void clearBelow() throws PuckException {
        while (this.segments.size() - 1 > this.currentSegmentIndex) {
            this.segments.remove(this.segments.size() - 1);
        }
    }

    public Families getAllFamilies() {
        Families result = ((Segment)this.segments.get(0)).getCurrentFamilies();
        return result;
    }

    public Individuals getAllIndividuals() {
        Individuals result = ((Segment)this.segments.get(0)).getCurrentIndividuals();
        return result;
    }

    public Relations getAllRelations() {
        Relations result = ((Segment)this.segments.get(0)).getCurrentRelations();
        return result;
    }

    public PartitionCriteriaList getCriteriaList() {
        PartitionCriteriaList result = new PartitionCriteriaList(this.size());
        int index = 1;
        while (index < this.segments.size()) {
            Segment segment = (Segment)this.segments.get(index);
            if (segment != null) {
                result.add(segment.getCriteria());
            }
            ++index;
        }
        return result;
    }

    public int getCurrentClusterIndex() {
        int result = ((Segment)this.segments.get(this.currentSegmentIndex)).getCurrentClusterIndex();
        return result;
    }

    public List<String> getCurrentClusterLabels() {
        List<String> result = ((Segment)this.segments.get(this.currentSegmentIndex)).getClusterLabels();
        return result;
    }

    public Families getCurrentFamilies() {
        Families result = ((Segment)this.segments.get(this.currentSegmentIndex)).getCurrentFamilies();
        return result;
    }

    public Individuals getCurrentIndividuals() {
        Individuals result = ((Segment)this.segments.get(this.currentSegmentIndex)).getCurrentIndividuals();
        return result;
    }

    public Relations getCurrentRelations() {
        Relations result = ((Segment)this.segments.get(this.currentSegmentIndex)).getCurrentRelations();
        return result;
    }

    public Segment getCurrentSegment() {
        Segment result = (Segment)this.segments.get(this.currentSegmentIndex);
        return result;
    }

    public int getCurrentSegmentIndex() {
        return this.currentSegmentIndex;
    }

    public String getLabel() {
        return this.label;
    }

    public Families getOutOfCurrentClusterFamilies() {
        Families result = ((Segment)this.segments.get(this.currentSegmentIndex)).getOutOfCurrentClusterFamilies();
        return result;
    }

    public Individuals getOutOfCurrentClusterIndividuals() {
        Individuals result = ((Segment)this.segments.get(this.currentSegmentIndex)).getOutOfCurrentClusterIndividuals();
        return result;
    }

    public Relations getOutOfCurrentClusterRelations() {
        Relations result = ((Segment)this.segments.get(this.currentSegmentIndex)).getOutOfCurrentClusterRelations();
        return result;
    }

    public StringList getSegmentLabels() {
        StringList result = new StringList();
        result.add((Object)((Segment)this.segments.get(0)).getLabel());
        int segmentIndex = 1;
        while (segmentIndex < this.segments.size()) {
            result.add((Object)(String.valueOf(segmentIndex) + " " + ((Segment)this.segments.get(segmentIndex)).getLabel()));
            ++segmentIndex;
        }
        return result;
    }

    public Segments getSegments() {
        return this.segments;
    }

    public String getSummary() {
        StringList summary = new StringList();
        summary.appendln(String.format("%s (%d)", ((Segment)this.segments.get(0)).getLabel(), ((Segment)this.segments.get(0)).getCurrentSize()));
        int segmentIndex = 1;
        while (segmentIndex <= this.currentSegmentIndex) {
            summary.appendln(String.format("%d %s (%d)", segmentIndex, ((Segment)this.segments.get(segmentIndex)).getLabel(), ((Segment)this.segments.get(segmentIndex)).getCurrentSize()));
            ++segmentIndex;
        }
        String result = summary.toString();
        return result;
    }

    public boolean isAtTheBottom() {
        boolean result = this.currentSegmentIndex == this.segments.size() - 1;
        return result;
    }

    public boolean isAtTheTop() {
        boolean result = this.currentSegmentIndex == 0;
        return result;
    }

    public boolean isOn() {
        boolean result = this.currentSegmentIndex > 0;
        return result;
    }

    public void refresh() throws PuckException {
        int stepIndex = 1;
        while (stepIndex < this.segments.size()) {
            ((Segment)this.segments.get(stepIndex)).refresh((Segment)this.segments.get(stepIndex - 1));
            ++stepIndex;
        }
    }

    public void selectCluster(Individual individual) throws PuckException {
        if (individual != null) {
            ((Segment)this.segments.get(this.currentSegmentIndex)).selectCluster(individual);
        }
    }

    public void selectCluster(int index) throws PuckException {
        ((Segment)this.segments.get(this.currentSegmentIndex)).selectCluster(index);
    }

    public void selectNextPartition() throws PuckException {
        this.selectPartition(this.currentSegmentIndex + 1);
    }

    public void selectPartition(int index) throws PuckException {
        if (index < 0 || index >= this.segments.size()) {
            throw PuckExceptions.INVALID_PARAMETER.create("Index out of bounds.", new Object[0]);
        }
        int stepIndex = this.currentSegmentIndex + 1;
        while (stepIndex <= index) {
            ((Segment)this.segments.get(stepIndex)).refresh((Segment)this.segments.get(stepIndex - 1));
            ++stepIndex;
        }
        this.currentSegmentIndex = index;
    }

    public void selectPreviousPartition() throws PuckException {
        this.selectPartition(this.currentSegmentIndex - 1);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int size() {
        int result = this.segments.size();
        return result;
    }

    public static List<Labels> buildModelLabels(Individuals individuals, Families families, RelationModels relationModels, Relations relations) {
        ArrayList<Labels> result = new ArrayList<Labels>();
        Labels labels = new Labels(PartitionCriteria.RelationModelCanonicalNames.INDIVIDUAL.toString());
        labels.addAll((List<String>)IndividualValuator.getAttributeLabels(individuals));
        result.add(labels);
        labels = new Labels(PartitionCriteria.RelationModelCanonicalNames.FAMILY.toString());
        labels.addAll(FamilyValuator.getAttributeLabels(families));
        result.add(labels);
        for (RelationModel relationModel : relationModels) {
            labels = new Labels(relationModel.getName());
            labels.addAll(RelationValuator.getAttributeLabels(relations.getByModel(relationModel)));
            result.add(labels);
        }
        return result;
    }

    public String toString() {
        String result = String.valueOf(this.label) + " " + this.currentSegmentIndex;
        if (this.segments != null) {
            result = String.valueOf(result) + " " + this.segments.get(this.currentSegmentIndex);
        }
        return result;
    }

    public Geography getGeography() {
        return this.geography;
    }
}

