/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.report;

import java.util.ArrayList;
import java.util.List;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportTable;
import org.tip.puck.sequences.Ordinal;
import org.tip.puck.sequences.Sequenceable;

public class ChartReport
extends Report {
    private List<ReportChart> charts = new ArrayList<ReportChart>(20);
    private List<ReportTable> tables = new ArrayList<ReportTable>(20);

    public ChartReport(String title) {
        super(title);
    }

    public void addChartWithTables(ReportChart chart, String title) {
        if (chart != null) {
            chart.setTitle(title);
            this.charts.add(chart);
            ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
            table.setTitle(chart.getTitle());
            this.tables.add(table);
        }
    }

    public void addChartsWithTables(Sequenceable<ReportChart> chartSequence, String title) {
        for (Ordinal time : chartSequence.getTimes()) {
            ReportChart chart = chartSequence.getStation(time);
            if (chart == null) continue;
            chart.setTitle(String.valueOf(title) + " " + time);
            this.charts.add(chart);
            ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
            table.setTitle(chart.getTitle());
            this.tables.add(table);
        }
    }

    public void addChart(ReportChart chart) {
        this.charts.add(chart);
    }

    public void addTable(ReportTable table) {
        this.tables.add(table);
    }

    public void arrangeChartsAndTables(int width) {
        int nr = Math.min(4, width);
        int chartIndex = 0;
        while (chartIndex < this.charts.size()) {
            this.outputs().append(this.charts.get(chartIndex));
            if (chartIndex % nr == nr - 1) {
                this.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : this.tables) {
            this.outputs().appendln(table.getTitle());
            this.outputs().appendln(table);
        }
    }
}

